
/**********************************************************************
 * $Id: loadSaveCom.c,v 1.5 93/01/22 12:08:57 tap Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

#include <xerion/commands.h>

/***********************************************************************
 *	Name:		command_save
 *	Description:	
 *	Parameters:	
 *	Return Value:	
 ***********************************************************************/
int	command_save (tokc, tokv)
  int	tokc ;
  char	*tokv[] ;
{
  IUsage(" ") ;
  if (GiveHelp(tokc)) {
    ISynopsis("save a network to file (disabled!!)");
    IHelp
      (IHelpArgs,
       "This command  has been disabled. Use  a build file and \"saveWeights\"",
       "instead.",
       "SEE ALSO",
       "read, saveWeights, loadWeights",
       NULL);
    return 0 ;
  }

  IErrorAbort("This command has been disabled") ;

  return 0 ;
}
/**********************************************************************/

#if 0
static void	saveNetStructure   ARGS((Net net, FILE *fp)) ;
static void	saveGroupStructure ARGS((Group group, void *data)) ;
static void	saveUnitStructure  ARGS((Unit unit, void *data)) ;
static void	saveLinkStructure  ARGS((Net net, void *data)) ;
static void	saveConstraints    ARGS((Net net, void *data)) ;
static void	printGroupName     ARGS((Group group, void *data)) ;


/***********************************************************************
 *	Name:		command_save
 *	Description:	
 *	Parameters:	
 *	Return Value:	
 ***********************************************************************/
int	command_save (tokc, tokv)
  int	tokc ;
  char	*tokv[] ;
{
  FILE		*outStream, *oldDout ;
  char		*commandName, command[BUFSIZ] ;
  Boolean	compress = TRUE ;

  IUsage("[ -noCompress ] [ <file> ]") ;
  if (GiveHelp(tokc)) {
    ISynopsis("save a network to file");
    IHelp
      (IHelpArgs,
       "\"save\"  saves the  current network to  a  file.  The file contains a",
       "series of  commands which  can be  read back  into the simulator  in",
       "order to  rebuild the net.  The  file consists of  two sections. The",
       "first specifies  the structure of the  network (how  many units, how",
       "they are connected, etc.). The second part of the file specifies the",
       "values of all the  fields in the structures.  Note that example sets",
       "are not saved with the file. They must be explicitly added after the",
       "net has been loaded.",
       "",
       "By default, the file is compressed  after it has  been created. This",
       "is because the  file may be  very large, but  it will  have  a  high",
       "degree  of  redundancy, and  be very  compressible. To override  the",
       "compression, use the \"-noCommpress\" option.  If no file is specified",
       "on the command line, \"save\" writes to standard output.",
       "",
       "The network can be reloaded with the \"read\" command.",
       "EXAMPLE",
       "To save the current network to the file bp.x,",
       "",
       "\txerion-> save bp.x",
       "NOTE",
       "This command  depends  on the   network  building  commands (addNet,",
       "addUnit, connectUnits, etc.)  as well as the  \"set\" command.  If you",
       "are writing  your  own   simulator and creating   complex  extension",
       "records, you should see the sman page for create-bindings.",
       "SEE ALSO",
       "read, saveWeights, loadWeights",
       NULL);
    return 0;
  }

  commandName = *tokv ;
  for (++tokv, --tokc ; tokc > 0 && *tokv[0] == '-' ; ++tokv, --tokc) {
    if (strncmp(*tokv, "-noCompress", strlen(*tokv)) == 0) {
      compress = FALSE ;
    } else {
      IErrorAbort("Unknown option: %s", *tokv) ;
    }
  }

  if (tokc == 0) {
    outStream = dout ;
  } else if (tokc == 1) {
    if (compress) {
      sprintf(command, "compress > %s.Z", *tokv) ;
      outStream = (FILE *)popen(command, "w") ;
    } else {
      outStream = IOpenFileOrAbort(*tokv, "w", NULL) ;
    }
  } else {
    IErrorAbort(IPrintUsage(commandName, usage)) ;
    return 0 ;
  }

  if (outStream == NULL)
    IErrorAbort("Cannot open output to %s", tokc ? *tokv : "stdout") ;

  if (currentNet == NULL)
    IErrorAbort("No current network") ;

  fprintf(outStream, "#\n# Start of Network Building\n#\n") ;
  fprintf(outStream, "echo -n \"Building network...\"\n") ;
  saveNetStructure(currentNet, outStream) ;
  fprintf(outStream, "echo \"done\"\n") ;
  fprintf(outStream, "echo \"Example sets were NOT saved with the net.\"\n") ;
  fprintf(outStream, "echo \"They must be reloaded using the command \\\"addExamples\\\"\".\n");
  fprintf(outStream, "#\n# Start of Field Initialization\n#\n") ;
  fprintf(outStream, "echo -n \"Initializing network...\"\n") ;

  sprintf(command, "show -set currentNet") ;
  oldDout = dout, dout = outStream ;
  IDoCommandLine(command) ;
  dout = oldDout ;
  fprintf(outStream, "echo \"done\"\n") ;

  if (outStream != dout) {
    if (compress)
      pclose(outStream) ;
    else
      ICloseFile(outStream) ;
    fprintf(dout,
	    "Network saved in file %s%s\n", *tokv, compress ? ".Z" : "") ;
  }
  return 1 ;
}
/**********************************************************************/


/*********************************************************************
 *	Name:		saveNetStructure
 *	Description:	saves the structure of an entire network (no
 *			example sets though)
 *	Parameters:
 *	  Net		net - the net
 *	  FILE		*fp - the file pointer for output
 *	Return Value:
 *	  static void	saveNetStructure - NONE
 *********************************************************************/
static void	saveNetStructure(net, fp)
  Net		net ;
  FILE		*fp ;
{
  /* add the net and set it current */
  if (net->type & RECURRENT)
    fprintf(fp, "addNet -type 0x%0x -time %d \"%s\"\n",
	    net->type, net->timeSlices, net->name) ;
  else
    fprintf(fp, "addNet -type 0x%0x \"%s\"\n", net->type, net->name) ;

  fprintf(fp, "useNet \"%s\"\n", net->name) ;

  /* delete bias so that no connections are automatically created */
  fprintf(fp, "deleteGroups \"%s\"\n", "Bias") ;

  /* save all the groups (and their units) then save the Bias unit */
  netForAllOtherGroups(net, BIAS, saveGroupStructure, (void *)fp) ;
  netForAllGroups     (net, BIAS, saveGroupStructure, (void *)fp) ;

  /* now make up the constraints and frozen array */
  saveLinkStructure(net, (void *)fp) ;
  fprintf(fp, "\n") ;
  saveConstraints(net, (void *)fp) ;
  fprintf(fp, "\n") ;

  /* Finally, order the groups */
  fprintf(fp, "orderGroups ") ;
  netForAllGroups(net, ALL, printGroupName, (void *)fp) ;
  fprintf(fp, "\n") ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		saveGroupStructure
 *	Description:	saves a structure of a group (i.e. type and name)
 *			plus all of its units.
 *	Parameters:
 *	  Group		group - the group
 *	  void		*data - file pointer for output
 *	Return Value:
 *	  static void	saveGroupStructure - NONE
 *********************************************************************/
static void	saveGroupStructure(group, data)
  Group		group ;
  void		*data ;
{
  fprintf((FILE *)data, 
	  "addGroup -type 0x%0x \"%s\" 0\n", group->type, group->name) ;
  groupForAllUnits(group, saveUnitStructure, data) ;
  fprintf((FILE *)data, "\n") ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		printGroupName
 *	Description:	prints a group name followed by a space
 *	Parameters:
 *	  Group		group - the group
 *	  void		*data - file pointer for output
 *	Return Value:
 *	  static void	printGroupName - NONE
 *********************************************************************/
static void	printGroupName(group, data)
  Group		group ;
  void		*data ;
{
  fprintf((FILE *)data, "\"%s\" ", group->name) ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		saveUnitStructure
 *	Description:	saves the structure of a unit in a network
 *			(i.e. which group the unit belongs in)
 *	Parameters:
 *	  Unit		unit  - the unit
 *	  void		*data - file pointer for output
 *	Return Value:
 *	  static void	saveUnitStructure - 
 *********************************************************************/
static void	saveUnitStructure(unit, data)
  Unit		unit ;
  void		*data ;
{
  fprintf((FILE *)data, 
	  "addUnit \"%s\" \"%s\"\n", unit->name, unit->group->name) ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		saveLinkStructure
 *	Description:	saves the structure of the incoming connections
 *			of a net. (i.e. where the links come from and
 *			what type they are).
 *	Parameters:
 *	  Net		net  - the net of interest
 *	  void		*data - the file pointer to write to
 *	Return Value:
 *	  static void	saveLinkStructure - NONE
 *********************************************************************/
static void	saveLinkStructure(net, data)
  Net		net ;
  void		*data ;
{
  FILE		*fp = (FILE *)data ;
  int		idx ;
  int		numLinks = net->numLinks ;
  Link		*links   = net->links ;

  for (idx = 0 ; idx < numLinks ; ++idx) {
    Link        link    = links[idx] ;
    fprintf(fp, "connectUnits -type 0x%0x \"%s\" \"%s\"\n", 
	    link->type, link->preUnit->name, link->postUnit->name) ;
  }
}
/********************************************************************/

static void	saveConstraints(net, data)
  Net		net ;
  void		*data ;
{
  int		linkIdx ;
  FILE		*fp = (FILE *)data ;
  int		numLinks = net->numLinks ;
  Link		*links   = net->links ;

  for (linkIdx = 1 ; linkIdx < numLinks ; ++linkIdx) {
    if (links[linkIdx]->variableIdx == links[linkIdx-1]->variableIdx) {
      fprintf(fp, "constrainLink \"%s\" \"%s\"\n", 
	      links[linkIdx]->name, links[linkIdx-1]->name) ;
    }
  }
}
#endif
