%{
/**********************************************************************
 * $Id: exampleLex.l,v 1.4 92/11/30 14:07:53 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/*********************************************************************
 *	lexicographical analyser for the example files
 *********************************************************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "exampleParse.h"
#include "y.tab.h"

static char	*stripPrefix() ;
static void 	skipLine() ;
%}
W	[ 	]
D	[0-9]
%%
"\n"		{ ++exampleFileLineNumber ; }
#		{ ++exampleFileLineNumber ; skipLine() ; }
{W}+		{ ; }
"all"		{ return ALL ; }
"next"		{ return NEXT ; }
"last"		{ return LAST ; }
^tag:.*$	{ strncpy(yylval.stringValue, stripPrefix(yytext, "tag:"), 
			  sizeof(yylval.stringValue)) ;
		  return TAG ; }
{D}+ 		{ sscanf(yytext, "%f", &yylval.realValue) ; return INTEGER ; }
({D}+\.?|{D}*\.{D}+)([eE][-+]{D}+)? {
		  sscanf(yytext, "%f", &yylval.realValue) ; return REAL ; }
"NaN"		{ setNaN(yylval.realValue) ; return REAL ; }
.		{ return yytext[0] ; }
%%

/*********************************************************************
 *	Name:		skipLine
 *	Description:	inputs everything up to a new line
 *********************************************************************/
static void skipLine() 
{
  int	c ;
  for (c = input() ; c != EOF && c != '\n' ; c = input())
    ;
  if (c != EOF)
    unput(c) ;
}
/********************************************************************/


/*********************************************************************
 *	Name:		stripPrefix
 *	Description:	strips a prefix (plus trailing whitespace)
 *			from a string
 *	Parameters:
 *	  char		*string - the string 
 *	  char		*prefix - the prefix
 *	Return Value:
 *	  static char	*stripPrefix - ptr to the remainder
 *********************************************************************/
static char	*stripPrefix(string, prefix)
  char		*string ;
  char		*prefix ;
{
  char		*ptr ;
  
  for (ptr = string + strlen(prefix) ; isspace(*ptr) ; ++ptr) 
    ;
  return ptr ;
}
/********************************************************************/
