######################################################################
# $Id: create-bindings.awk,v 1.6 93/02/16 11:22:58 drew Exp $
######################################################################

######################################################################
# Copyright 1990, 1991 by University of Toronto, Toronto, Ontario, Canada.
# 
#			 All Rights Reserved
# 
# Permission to use, copy, modify, distribute, and sell this software
# and its documentation for any purpose is hereby granted without fee, 
# provided that the above copyright notice appears in all copies and that 
# both the copyright notice and this permission notice appear in 
# supporting documentation, and that the name of University of Toronto 
# not be used in advertising or publicity pertaining to distribution 
# of the software without specific, written prior permission.  
# University of Toronto makes no representations about the suitability 
# of this software for any purpose. It is provided "as is" without 
# express or implied warranty. 
#
# UNIVERSITY OF TORONTO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND 
# FITNESS, IN NO EVENT SHALL UNIVERSITY OF TORONTO BE LIABLE FOR ANY 
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER 
# RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF 
# CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
######################################################################

########################################################################
# Beginning
########################################################################
BEGIN {
  if (debug!=0)
    print "/* DEBUG ON!!! */"
  nest_level = 0;
  basic_type["char"]   = "char";
  basic_type["Boolean"]= "char";
  basic_type["int"]    = "int";
  basic_type["long"]   = "long";
  basic_type["short"]  = "short";
  basic_type["Real"]   = "Real";
  basic_type["double"] = "double";
  basic_type["float"]  = "float";
  basic_type["String"] = "String";
  basic_type["struct"] = "struct";
  basic_type["union"]  = "union";

  basic_type["LinkExtensionRec"]  = "LinkExtensionRec" ;
  basic_type["NetExtensionRec"]   = "NetExtensionRec" ;
  basic_type["GroupExtensionRec"] = "GroupExtensionRec" ;
  basic_type["UnitExtensionRec"]  = "UnitExtensionRec" ;
  basic_type["ExampleExtensionRec"] = "ExampleExtensionRec" ;
  basic_type["ExampleSetExtensionRec"] = "ExampleSetExtensionRec" ;


  struct_type["struct"] = "t" ;
  struct_type["union"]  = "t" ;

  cap["char"]    = "Char";
  cap["int"]     = "Int";
  cap["long"]    = "Long";
  cap["short"]   = "Short";
  cap["Real"]    = "Real";
  cap["double"]  = "Double";
  cap["float"]   = "Float";
  cap["String"]  = "String";

  struct[""]="";
  union[""]="";
  field_struct[""]="";
  field_type[""]="";
  field_name[""]="";
  field_default[""]="";
  field_alt_name[""]="";
  field_orig_name[""]="";
  field_num=0;
  array_base_address["P_OBJECT|P_FIXED"]="[0]";
  var_type[""]="";
  struct_var_type[""]="";
  default_field_value[""]="";
  mark_saved_object[""] = "";
  visible[""] = 0;
  default[""] = 0;
  default_var[""] = 0;
  netParam[""] = 0;
  minimizeParam[""] = 0;
  save[""] = 0;
}

########################################################################
# confused!
########################################################################
$1 == "extern" && nest_level > 0 {
  print "ERROR: Terribly confused: extern declaration and nest_level > 0!?!";
  print "line is: ",$0
  panic ="t" ; 
  exit 1 ;
}

########################################################################
# going deeper into a structure
########################################################################
/{/ && nest_level > 0 {
  nest_level++;
}

########################################################################
# a  variable instance of a type we know about
########################################################################
$1 == "extern" && basic_type[$2] != "" && /;.*BIND[^A-Za-z0-9]/ {
  if ("struct" == basic_type[$2]) {
    type = $3 ;
    idx  = 4 ;
  } else {
    type = basic_type[$2];
    idx  = 3 ;
  }

  name = pointer_type[$2] $idx ;

  # collect the name along with all the *'s before it	
  while ($idx == "*" && idx < NF) 
    name = $name $(++idx) ;
  ++idx ;

  # take the semi-colon off the end of the name
  if (substr(name, length(name), length(name)) == ";") 
    name = substr(name, 1, length(name)-1) ;
  else if ($idx == ";") {
    ++idx ;
  } else {
    print "ERROR: expected semi-colon after ", name, "on line:\n", $0;
    print "line is:\n",$0;
    panic = "t"; 
    exit 1;
  }

  # check if its a pointer
  mode  = "P_OBJECT";
  indirection = 1;
  for (i = 1 ; i <= 2 && substr(name, 1, 1) == "*" ; ++i) {
    mode = "P" mode ;
    indirection++ ;
    name = substr(name, 2, length(name));
  }

  # check if its an array declaration
  count = "";
  array = "";
  if (substr(name, length(name), 1) == "]") {
    p = index(name, "[");
    q = index(name, "]");
    count = substr(name, p + 1, q - p - 1) ;
    end = substr(name, q+1, length(name));
    if (index(end, "[")>0) {
      mode = "P" mode ;
      indirection++;
      array = "|PP_FIXED";
    } else
      array = "|P_FIXED";
    name  = substr(name, 1, p - 1);

  # find the counter (assuming idx is still set to the next field)
  } else {
    for ( ; idx <= NF ; idx++) {
      if ($idx == "counter:") {
        count = $(idx+1);
	if (index(count, ",")>0)
	  count = substr(count, 1, index(count, ",")-1);
        if ($(idx+1) + 1 > 1) 
	  array = "|" substr("PPP", 1, indirection-1)"_FIXED";
        else 
	  array = "|" substr("PPP", 1, indirection-1)"_COUNT";
      } else if ($idx == "nosave:" || $idx == "nsi:")
        save[name] = 0;
      else if ($idx == "invis:" || $idx == "nsi:")
        visible[name] = 0;
      else if ($idx == "default:")
        default_var[name] = $(idx+1);
    }
  }

  if ((array == "|P_FIXED" || array == "|P_COUNT") \
       && !(mode == "P_OBJECT" || mode == "PP_OBJECT") \
       || array == "|PP_COUNT" && !(mode == "PPP_OBJECT")) {
    print "ERROR: can only have these types of arrays:";
    print "type x[N];"
    print "type *x; /* array: counter: n */"
    print "type **x; /* array: counter: n */"
    print "Illegal types were:",mode,array,indirection;
    print "line is:\n",$0
    panic="t"; 
    exit 1;
  }

  # set the variables
  if (struct_type[$2] == "t") {
    struct_var_type[name]  = type ;
    struct_var_mode[name]  = mode ;
    struct_var_array[name] = array ;
    struct_var_count[name] = count ;
  } else {
    var_type[name]  = type;
    var_mode[name]  = mode;
    var_array[name] = array;
    var_count[name] = count;
  }
  if (array=="|P_COUNT" || array=="|PP_COUNT") {
    var_counter[count] = name ;
    var_type[count]    = "" ;
  }

  if (debug!=0) {
    if (struct_type[$2] == "t")
      print "/* struct var", name, type, mode, array, count" */"
    else
      print "/* var", name, type, mode, array, count" */"
  }
}

########################################################################
# a field in a structure definition with a basic type
########################################################################
NF>1 && nest_level == 1 &&  !/;.*NOBIND[^A-Za-z0-9]/ && basic_type[$1] != "" {

  if (basic_type[$1]=="struct") {
    type = $2;
    i = 3;
  } else {
    type = basic_type[$1] ;
    i = 2;
  }
  name = pointer_type[$1] $i ;
  
  while ($i=="*" && i<=NF) name = name $++i;
  # take the semi-colon off the end of the name
  if (substr(name,length(name),length(name))!=";" && $(i+1) != ";") {
    print "ERROR: expected semi-colon at the end of",$2,"on line",NR"\n",$0;
        panic="t"; exit 1;
  }
  if (substr(name,length(name),length(name)) == ";")
    name = substr(name,1,length(name)-1);
  array = "";
  array2 = "";
  mode = "P_OBJECT";
  count = "";
  count2 = "";
  indirection = 1;
  if (substr(name,1,1)=="*") {
    mode = "P" mode;
    indirection++;
    name = substr(name,2,length(name));
    if (substr(name,1,1)=="*") {
      mode = "P" mode;
      indirection++;
      name = substr(name,2,length(name));
    }
  }

  # check if its an array declaration
  array = "";
  if (substr(name,length(name),length(name))=="]") {
    p = index(name, "[");
    q = index(name, "]");
    if (p<1) {
      print "ERROR: syntax error: no [ before a ]";
      print "line is:\n",$0
      panic="t"; exit 1;
    }

    count = substr(name, p + 1, q - p - 1) ;
    end = substr(name, q+1, length(name));
    name  = substr(name, 1, p - 1);
    if (end!="") {
      p = index(end, "[");
      q = index(end, "]");
      count2 = substr(end, p + 1, q - p - 1) ;
      array = "PP_FIXED";
      array2 = "P_FIXED";
      mode = "P" mode;
      if (q!=length(end)) {
        print "ERROR: cannot understand junk:", end;
        print "line is:\n",$0
        panic="t"; exit 1;
      }
      if (debug>0)
        print "/* count2", name, count2, "*/";
    } else
      array = "|P_FIXED";
  }

  # find the counter
  if (array=="") {
    for (i=4;i<=NF;i++) {
      if ($i=="counter:") {
        p = index($(i+1), ",");
	if (p>0) {
	  count = substr($(i+1), 1, p-1);
	  if (indirection>=3) {
	    count2 = substr($(i+1), p+1, length($(i+1)));
            if (count2 + 1 > 1)
	      array2 = substr("PPP",1,indirection-2)"_FIXED";
            else
	      array2 = substr("PPP",1,indirection-2)"_COUNT";
	  }
	} else
          count = $(i+1);
        if (count + 1 > 1)
	  array = "|" substr("PPP",1,indirection-1)"_FIXED";
        else
	  array = "|" substr("PPP",1,indirection-1)"_COUNT";
      }
      if ($i=="nosave:" || $i=="nsi:")
        save[struct_name "." name] = 0;
      if ($i=="invis:" || $i=="nsi:")
        visible[struct_name "." name] = 0;
      if ($i=="default:")
        default[struct_name "." name] = $(i+1);
      else if ($i == "netParam:")
        netParam[struct_name "." name] = $(i+1);
      else if ($i == "miniParam:")
        minimizeParam[struct_name "." name] = $(i+1);
    }
  }
  for (i=4;i<=NF;i++) {
    if ($i=="save:") {
      mark_saved_object[struct_name "." name] = "save";
    }
  }
  if ((array=="|P_FIXED" || array=="|P_COUNT") && !(mode=="P_OBJECT" || mode=="PP_OBJECT") || array=="|PP_COUNT" && !(mode=="PPP_OBJECT")) {
    print "ERROR: can only have these types of arrays:";
    print "<type> x[N];"
    print "<type> *x; /* array: counter: n */"
    print "<type> **x; /* array: counter: n */"
    print "Illegal types were:",array,mode;
    print "line is:\n",$0
    panic="t"; exit 1;
  }

  if (array=="|P_COUNT"||array=="|PP_COUNT") {
    field_counter[struct_name":"count]="t";
    if (debug!=0)
      print "/* set",struct_name,count,"to be a field counter */";
    if (count2!="") {
      field_counter[struct_name":"count2]="t";
      if (debug!=0)
        print "/* set",struct_name,count2,"to be a field counter */";
    }
  }
  field_lookup[struct_name ":" name] = field_num;
  field_mode[field_num]=mode;
  field_name[field_num]=name;
  field_type[field_num]=type;
  field_struct[field_num]=struct_name;
  field_array[field_num]=array;
  field_array2[field_num]=array2;
  field_count[field_num]=count;
  field_count2[field_num]=count2;
  field_indirection[field_num]=indirection;
  if (debug!=0)
    print "/* field",field_num,name,mode,type,indirection,struct_name,array,count,count2,"*/";
  field_num++;
}

########################################################################
# A normal typedef
########################################################################
/^[^{][^{]*BIND[^A-Za-z0-9]/ && $1 == "typedef" {

  if (basic_type[$2] == "struct") {
     isStruct = "t" ;
     type     = $3 ;
     nextWord = 4 ;
  } else {
     isStruct = "" ;
     type = $2 ;
     nextWord = 3 ;
  }

  for (idx = nextWord ; idx <= NF ; ++idx) {
    if ($idx == ",") {
      continue ;
    } else if ($idx == "/*") {
       for (++idx ; idx <= NF && $idx != "*/" ; ++idx) 
         ;
       continue ;
    } else if ($idx == ";") {
      break ;
    } else {
      pointer = "" ;
      name    = $idx ;
      for (i = 1 ; i <= 2 && substr(name, 1, 1) == "*" ; ++i) {
        pointer = pointer "*" ;
        name    = substr(name, 2, length(name));
      }
      if (substr(name, length(name), length(name)) == ";"	\
	  || substr(name, length(name), length(name)) == ",")
        name = substr(name, 1, length(name)-1) ;

      basic_type[name]   = type ;
      struct_type[name]  = isStruct ;
      pointer_type[name] = pointer ;
      if (debug > 0)
	printf("/* typedef: \"%s\" \"%s\" \"%s\" */\n", name, basic_type[name], pointer_type[name]) ;
    }
  }
}

########################################################################
# going into a structure definition
########################################################################
/{.*BIND[^A-Za-z0-9]/ && $1 == "typedef" && basic_type[$2] == "struct" {
  if (debug!=0)
    print "/* going into",struct_name,"*/"

  if (nest_level) {
    print "ERROR: error in create-smip-access, struct inside struct, line ",NR;
    panic = "t" ; 
    exit 1;
  }
  count       = "";
  nest_level  = 1;
  struct_name = $3;
  struct[struct_name] = "t";
  if ($2 == "union")
    union[struct_name] = "t";
}


########################################################################
# coming out of depth in a structure
########################################################################
/}/ && nest_level > 0 {
  nest_level--;
  if (debug!=0)
    print "/* coming outof",struct_name,"*/"

  if (nest_level == 0) {
    for (idx = 2 ; idx <= NF ; ++idx) {
      if ($idx == ",") {
	continue ;
      } else if ($idx == "/*") {
	 for (++idx ; idx <= NF && $idx != "*/" ; ++idx) 
	   ;
	 continue ;
      } else if ($idx == ";") {
	break ;
      } else {
	pointer = "" ;
	name    = $idx ;
	for (i = 1 ; i <= 2 && substr(name, 1, 1) == "*" ; ++i) {
	  pointer = pointer "*" ;
	  name    = substr(name, 2, length(name));
	}
        if (substr(name, length(name), length(name)) == ";" \
	    || substr(name, length(name), length(name)) == ",")
          name = substr(name, 1, length(name)-1) ;
	basic_type[name]   = struct_name ;
	struct_type[name]  = "t" ;
	pointer_type[name] = pointer ;
	if (debug > 0)
	  printf("/* typedef: \"%s\" \"%s\" \"%s\" */\n", name, basic_type[name], pointer_type[name]) ;
      }
    }
  }
}

########################################################################
# Done Processing, dump the data.
########################################################################
END {

  if (panic) exit 1;

  if (debug!=0) {
    for (s in basic_type) {
         printf("/* basic_type: \"%s\" \"%s\" */\n", s, basic_type[s]) ;
    }
  }
  printf("\n") ;
  for (s in basic_type) {
    if (struct_type[s] == "t" && s != "struct" && s != "union" \
        && struct[basic_type[s]] == "") {
      if (union[s] != "")
        printf("union  %s { int foo ; } ;\n", basic_type[s]) ;
      else
        printf("struct %s { int foo ; } ;\n", basic_type[s]) ;
    }
  }
  printf("\n") ;

  print "\nvoid EnterBindings()\n{";
  print "  /* declarations */"
  for (s in struct) if (s!="") {
    if (union[s] != "")
      print "  union ",s,"*"s"_ptr = NULL;";
    else
      print "  struct",s,"*"s"_ptr = NULL;";
  }

  print ""
  print "  ISetFeatureMask(ITF_VISIBLE | ITF_SAVE);"
  print "\n  /* structure types */"
  for (s in struct) if (s!="")
    print "  IEnterType(\"" s "\",sizeof(struct "s"),IS_STRUCT);";

  # sort the var names so that the counters come first
  n_vars=0;
  for (v in var_type) {
  if (var_counter[v]!="") {
  printf("v = %s, var_count = %s\n", v, var_count[v]) > "junk" ;
    if (var_count[v]+1==1 && var_type[v]=="") {
      print "ERROR: Cant find counter \""v"\" for var \""var_counter[v]"\"";
      exit 1;
    }
    if (debug!=0)
      print "/* counter:",v,n_vars,"*/";
    ordered_var[n_vars++]=v;
    var_prop[v] = var_prop[v] "|IS_COUNTER";
  }
  }
  for (v in var_type) if (var_counter[v]=="") {
    ordered_var[n_vars++]=v;
    if (debug!=0)
      print "/* non-counter:",v,n_vars,"*/";
  }

  # sort the field names so that the counters come first
  # should check that counters exist
  n_fields=0;
  for (i=0;i<field_num;i++)
    if (field_counter[field_struct[i]":"field_name[i]]=="t") {
      field_order[n_fields++]=i;
      field_prop[i] = field_prop[i] "|IS_COUNTER";
      if (debug!=0)
        print "/* field counter    :",i,field_struct[i],field_name[i],"*/";
    } else {
      if (debug!=0)
        print "/* field non-counter:",i,field_struct[i],field_name[i],"*/";
    }
  for (i=0;i<field_num;i++)
    if (field_counter[field_struct[i]":"field_name[i]]!="t")
      field_order[n_fields++]=i;

  print "\n  /* structure fields (" field_num ") */"
  for (j=0;j<field_num;j++) {
    i = field_order[j];
    t = field_type[i];
    s = field_struct[i];
    f = field_name[i];
    o = field_orig[i];
    d = field_default[i];
    a = field_array[i];
    a2 = field_array2[i];
    m = field_mode[i];
    c = field_count[i];
    c2 = field_count2[i];
    p = "0" field_prop[i];
    p2 = "0" field_prop2[i];
    e = array_base_address[m a];
    if (struct[t]=="" && basic_type[t]=="") {
      print "ERROR: unknown type",t,"for field:",j,it,"in struct",s;
          panic="t"; exit 1;
    }
    if (o!="") {
      print "  IAltFieldName(\"" s "\", \"" o "\", \"" f "\");";
    } else {
      print "  IEnterField(\"" s "\", \"" t "\", \"" f "\",(char*)&(" s "_ptr->" f e ")-(char*)" s "_ptr," m a ", " p ", \"" c "\");";
      if (c2!="")
	print "  IEnterFieldCounter(\"" s "\", \"" f "\", " a2 ", " p2 ", \"" c2 "\");";
    }
  }
  for (s in mark_saved_object) {
    if (s!="")
      print "  MarkToSave(\"" s "\");";
  }
  for (s in visible) {
    if (s!="")
      print "  ISetVisible(\"" s "\", " visible[s] ");";
  }
  for (s in save) {
    if (s!="")
      print "  ISetSave(\"" s "\", " save[s] ");";
  }
  for (s in default) {
    if (s!="")
      print "  IAddDefault(\"" s "\", \"" default[s] "\");";
  }
  for (s in netParam) {
    if (s!="")
      print "  IAddNetParam(\"" s "\");";
  }
  for (s in minimizeParam) {
    if (s!="")
      print "  IAddMinimizeParam(\"" s "\");";
  }
  print "}\n";
  print "\nvoid BindObjects()\n{\n";
  print "\n  /* simple variables */"
  for (i=0;i<n_vars;i++) {
    v = ordered_var[i];
    if (debug!=0)
      print "/*",v,"*/"
    e = array_base_address[var_mode[v] var_array[v]];
    if (v!="" && basic_type[var_type[v]]!="struct")
      print "  IBind" cap[var_type[v]] "(\"" v "\",&" v e ", " var_mode[v] var_array[v] ",0" var_prop[v] ", \"" var_count[v] "\");";
  }

  print "\n  /* structure variables */"
  for (v in struct_var_type) {
    if (v!="") {
      if (debug!=0)
        print "  /*",v,struct_var_type[v],struct[struct_var_type[v]],"*/";
      e = array_base_address[struct_var_mode[v] struct_var_array[v]];
      print "  IBindStruct(\"" v "\", \"" struct_var_type[v] "\",(char*)&" v e", " struct_var_mode[v] struct_var_array[v] ", \"" struct_var_count[v] "\");";
    }
  }
  for (s in default_var) {
    if (s!="")
      print "  ISetValue(\"" s "\", \"" default_var[s] "\");";
      print "  IAddDefault(\"" s "\", \"" default_var[s] "\");";
  }
  print "}\n";
}

