.CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
.C $Id: create-bindings.l,v 1.5 93/01/26 11:29:25 drew Exp $
.CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
.C
.CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
.C   Copyright 1990,1991,1992,1993 by The University of Toronto,
.C		      Toronto, Ontario, Canada.
.C 
.C			 All Rights Reserved
.C 
.C Permission to use, copy, modify, distribute, and sell this software
.C and  its documentation  for any   purpose is hereby granted without
.C fee, provided that the above copyright notice appears in all copies
.C and  that both  the  copyright  notice  and this permission  notice
.C appear in supporting documentation, and that the name of University
.C of Toronto not  be used in  advertising or publicity  pertaining to
.C distribution of   the   software   without specific, written  prior
.C permission.  University  of Toronto makes no representations  about
.C the suitability of  this software for any  purpose.  It is provided
.C "as is" without express or implied warranty.
.C
.C UNIVERSITY OF TORONTO DISCLAIMS ALL WARRANTIES WITH REGARD  TO THIS
.C SOFTWARE, INCLUDING ALL  IMPLIED WARRANTIES  OF MERCHANTABILITY AND
.C FITNESS, IN NO EVENT SHALL UNIVERSITY  OF TORONTO BE LIABLE FOR ANY
.C SPECIAL,  INDIRECT  OR    CONSEQUENTIAL  DAMAGES OR     ANY DAMAGES
.C WHATSOEVER RESULTING FROM LOSS OF USE, DATA  OR PROFITS, WHETHER IN
.C AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
.C OUT  OF OR  IN CONNECTION  WITH  THE USE   OR  PERFORMANCE  OF THIS
.C SOFTWARE.
.C
.CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
.C
.de BF		\" boldface a word
\fI\\$1\fP
..
.de FT		\" start a field table with title
.PP
.nf
.ta 2.5i 4.5i
.ce 1
\\$1
..
.de CF		\" center a function on a line
.sp
.ce 1
\\$1
.sp
..
.TH create-bindings LOCAL "December 1992" "Xerion" "Xerion Manual"
.SH NAME
create-bindings - create a bindings file from C header files

.SH SYNOPSIS
create-bindings <output file> file1 [ file2 ... ]

.SH DESCRIPTION
The 
.BF create-bindings
command reads a series of input C header files and creates a C source
code file which can be used by the Xerion command line interface.  The
generated file contains descriptions of data structures and variables
which will be accessable from the Xerion command line via the
.BF set,
.BF show,
and
.BF print,
commands.

To register variables for binding, the variable must be declared on
its own line, and there must be a comment containing the keyword
.BF BIND
on the line.  For example, to register an integer variable for
binding, include the following line in a header file:

extern int       foo ;      /* BIND */

The binder knows about the data types int, long, short, float, double,
char, Real, String, Link, Unit, Group, Net and ExampleSet as well as
the extension records for the simulator objects.  Also, it knows about
pointers to and arrays of these data types.  A maximum of three levels
of indirection is allowed. E.g.

.nf
extern float     bar ;             /* BIND */
extern float     floatArray[10] ;  /* BIND */
extern char      *name ;           /* BIND */
extern Net       currentNet ;      /* BIND */
.fi

To register a structure type, the following format must be used:

.nf
typedef struct ArrayStruct {  /* BIND */
  Real *array ;
  int  dim ;
} arrayStruct ;
.fi

Once a structure type has been registered, an instance of the
structure may be registered:

extern struct ArrayStruct    array ;      /* BIND */

Within a structure that is registered, all fields are automatically
registered unless there is a comment on the line on which they are
defined containing the string
.BF NOBIND.
E.g.

.nf
typedef struct ArrayStruct {  /* BIND */
  Real *array ;
  int  dim ;            /* NOBIND */
} arrayStruct ;
.fi

will register the structure type
.BF "struct ArrayStruct,"
but will not register it as containing a field called dim.  The
binder will not recognize pointers as arrays unless there is a counter
registered for the size of the array.  This is done using the keyword
.BF counter:.
For example

.nf
typedef struct ArrayStruct {  /* BIND */
  Real *array ;		      /* counter: dim */
  int  dim ;
} arrayStruct ;
.fi

will register the structure field 
.BF dim
as being the dimension for the array 
.BF array.
If the array is two dimensional, a second counter may be listed,
separated by a comma. E.g.

.nf
typedef struct ArrayStruct {  /* BIND */
  Real **array ;	      /* counter: dim1,dim2 */
  int  dim1 ;
  int  dim2 ;
} arrayStruct ;
.fi

Other keywords that are recognized include:

.IP \fIinvis:\fP 1i
which states that the variable should not be visible to
.BF show,
.BF set,
and
.BF print,
unless explicitly made so by the 
.BF visible 
command.

.IP \fInosave:\fP 1i
which specifies that the variable should not be printed by the command
.BF "show -set."

.IP \fInsi:\fP 1i
which is equivalent to 
.BF "nosave: invis:."

.IP \fIdefault:\fP 1i
which specifies a default value to be assigned to
the variable.

.IP \fInetParam:\fP 1i
which specifies that the field is a network 
paramater. This is only valid for fields in
.BF NetRec
or
.BF NetExtensionRec.
Fields marked as 
.BF netParam's
are shown in the 
.BF "Learning Methods"
display as 
.BF "Misc. Parameters".

.SH SEE ALSO
extract-commands(LOCAL)

.SH AUTHORS
The original version of create-bindings was written by Tony Plate
(tap@ai.toronto.edu). Since then it has been extensively revised by
Drew van Camp (drew@ai.toronto.edu).

\" Local Variables: *
\" mode:nroff *
\" End: *
