######################################################################
# $Id: setup.sh,v 1.4 93/01/15 11:20:07 drew Exp $
######################################################################

######################################################################
# Copyright 1990, 1991 by University of Toronto, Toronto, Ontario, Canada.
# 
#			 All Rights Reserved
# 
# Permission to use, copy, modify, distribute, and sell this software
# and its documentation for any purpose is hereby granted without fee, 
# provided that the above copyright notice appears in all copies and that 
# both the copyright notice and this permission notice appear in 
# supporting documentation, and that the name of University of Toronto 
# not be used in advertising or publicity pertaining to distribution 
# of the software without specific, written prior permission.  
# University of Toronto makes no representations about the suitability 
# of this software for any purpose. It is provided "as is" without 
# express or implied warranty. 
#
# UNIVERSITY OF TORONTO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND 
# FITNESS, IN NO EVENT SHALL UNIVERSITY OF TORONTO BE LIABLE FOR ANY 
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER 
# RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF 
# CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
######################################################################

######################################################################
#	This shell script sets shell variables necessary for Xerion
#	to function properly. It should be used in the following manner
#
#	In the .profile file insert the following lines:
#
#	set XERIONDIR=$HOME/xerion && export XERIONDIR
#	. $XERIONDIR/etc/setup.sh
#
#	Where $HOME/xerion should be changed to be the top
#	level diretory where xerion is installed.
######################################################################
checkPathFor() {
	NUM=`expr ":$1:" : ".*:$2:.*"`
	test $NUM -ne 0
}

checkPathFor "$XUSERFILESEARCHPATH" "${XERIONDIR}/config/%L/%N%C" \
 || XUSERFILESEARCHPATH="${XUSERFILESEARCHPATH}:${XERIONDIR}/config/%L/%N%C"
export XUSERFILESEARCHPATH

IMAKEINCLUDE="${IMAKEINCLUDE:+$IMAKEINCLUDE }-I$XERIONDIR/config"
export IMAKEINCLUDE

SH_FILE=$XERIONDIR/config/xerion${BINTYPE:+.}${BINTYPE}.sh

if [ -f $SH_FILE ] ; then
	. $SH_FILE
	checkPathFor $PATH $BINDIR ||  PATH="$PATH:$BINDIR"
	checkPathFor $PATH $ETCDIR ||  PATH="$PATH:$ETCDIR"
	export PATH
fi
######################################################################
