######################################################################
# $Id: setup.csh,v 1.2 93/01/15 11:20:06 drew Exp $
######################################################################

######################################################################
# Copyright 1990, 1991 by University of Toronto, Toronto, Ontario, Canada.
# 
#			 All Rights Reserved
# 
# Permission to use, copy, modify, distribute, and sell this software
# and its documentation for any purpose is hereby granted without fee, 
# provided that the above copyright notice appears in all copies and that 
# both the copyright notice and this permission notice appear in 
# supporting documentation, and that the name of University of Toronto 
# not be used in advertising or publicity pertaining to distribution 
# of the software without specific, written prior permission.  
# University of Toronto makes no representations about the suitability 
# of this software for any purpose. It is provided "as is" without 
# express or implied warranty. 
#
# UNIVERSITY OF TORONTO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND 
# FITNESS, IN NO EVENT SHALL UNIVERSITY OF TORONTO BE LIABLE FOR ANY 
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER 
# RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF 
# CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
######################################################################

######################################################################
#	This shell script sets shell variables necessary for Xerion
#	to function properly. It should be used in the following manner
#
#	In the .cshrc file insert the following lines:
#
#	setenv XERIONDIR $HOME/xerion
#	source $XERIONDIR/etc/setup.csh
#
#	Where $HOME/xerion should be changed to be the top
#	level diretory where xerion is installed.
######################################################################
alias checkPathFor	\
	'set NUM=`expr ":"\!:1":" : ".*:"\!:2":.*"` ; test $NUM -ne 0'

if $?XUSERFILESEARCHPATH == 0 then
	setenv TMP_PATH ""
else
	setenv TMP_PATH "$XUSERFILESEARCHPATH"
endif

checkPathFor "$TMP_PATH" "$XERIONDIR/config/%L/%N" \
 || setenv XUSERFILESEARCHPATH "${TMP_PATH}:$XERIONDIR/config/%L/%N"
unsetenv TMP_PATH

if $?IMAKEINCLUDE == 0 then
	setenv IMAKEINCLUDE "-I$XERIONDIR/config"
else
	setenv IMAKEINCLUDE "$IMAKEINCLUDE -I$XERIONDIR/config"
endif

if $?BINTYPE == 0 then
	set CSH_FILE=$XERIONDIR/config/xerion.csh
else
	set CSH_FILE=$XERIONDIR/config/xerion.${BINTYPE}.csh
endif

if  -f $CSH_FILE then
	source $CSH_FILE
	checkPathFor "$PATH" $BINDIR || setenv PATH "${PATH}:${BINDIR}"
	checkPathFor "$PATH" $ETCDIR || setenv PATH "${PATH}:${ETCDIR}"
endif

unalias checkForPath
######################################################################
