
/**********************************************************************
 * $Id: scl.h,v 1.3 92/11/30 12:02:06 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee, 
 * provided that the above copyright notice appears in all copies and that 
 * both the copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of University of Toronto 
 * not be used in advertising or publicity pertaining to distribution 
 * of the software without specific, written prior permission.  
 * University of Toronto makes no representations about the suitability 
 * of this software for any purpose. It is provided "as is" without 
 * express or implied warranty. 
 *
 * UNIVERSITY OF TORONTO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS, IN NO EVENT SHALL UNIVERSITY OF TORONTO BE LIABLE FOR ANY 
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER 
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF 
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 **********************************************************************/


#define MIN(x, y)	((x) < (y) ? (x) : (y))
#define MAX(x, y)	((x) > (y) ? (x) : (y))

#define PI 3.1415927

#define initialVarianceProportion 0.5
#define finalVarianceProportion 0.05

#ifndef SCL_H
#define SCL_H

/* The following structures must be defined, even if you don't
 * need them in you simulator
 */
typedef struct NetExtensionRec {	/* BIND */
  Real  variance ;                      /* netParam: */
  Real  aveVariance ; 
  Real  initialVariance ;               /* netParam: */
  Real  initialLearningRate ;           /* netParam: */
  Real  minVariance ;                   /* netParam: */
  Real  epochVarianceDecay ;            /* netParam: */
  int   learningRateDecayFunction ;     /* netParam: */
  Real  learningRateDecay ;             /* netParam: */
  Real  tau ;                           /* netParam: */
  int   unitCounter;                    /* default: 0 */
} NetExtensionRec ;

typedef struct GroupExtensionRec {	/* BIND */
  Real  sumExpInput ;
  Real  sumProbs    ;
} GroupExtensionRec ;

typedef struct UnitExtensionRec {	/* BIND */
  Real  sumProbs ;
  Real  expInput;
  Real  variance;
} UnitExtensionRec ;

typedef struct LinkExtensionRec {	/* BIND */
  int	foo ;
} LinkExtensionRec ;

typedef struct ExampleExtensionRec {	/* BIND */
  int	foo ;
} ExampleExtensionRec ;


#define simpleSigmoid(x) (1.0/(1.0+exp(-(double)(x))))
#define sigmoid(x)       ((x) > 30 ? 			\
			  (1.0) : ((x) < -30 ? (0.0) : simpleSigmoid(x)))

#define sigmoidDeriv(x)	((x)*(1.0 - (x)))

#define MIN(x, y)	((x) < (y) ? (x) : (y))
#define MAX(x, y)	((x) > (y) ? (x) : (y))

#define Mepsilon(net)		 ((net)->mz->epsilon)
#define Mmomentum(net)		 ((net)->mz->alpha)
#define Mvariance(net)		 ((net)->extension->variance)
#define MaveVariance(net)	 ((net)->extension->aveVariance)
#define MunitCounter(net)	 ((net)->extension->unitCounter)
#define MepochVarianceDecay(net) ((net)->extension->epochVarianceDecay)
#define MinitialVariance(net)	 ((net)->extension->initialVariance)
#define MminVariance(net)	 ((net)->extension->minVariance)
#define MinitialLearningRate(net)((net)->extension->initialLearningRate)
#define MlearningRateDecayFunction(net) ((net)->extension->learningRateDecayFunction)
#define MlearningRateDecay(net)  ((net)->extension->learningRateDecay)
#define Mtau(net)                ((net)->extension->tau)
#define MdirectionMethod(net)	 ((net)->mz->directionMethod)
#define MstepMethod(net)	 ((net)->mz->stepMethod)
#define McurrentEpoch(net)       ((net)->currentEpoch)
#define MbatchSize(net)		 ((net)->batchSize)


#endif				/* SCL_H */
