
/**********************************************************************
 * $Id: help.h,v 1.3 92/11/30 12:00:08 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/**********************************************************************
 * These help strings will be automatically registered 
 * and made available to the "whatis" command and "Help"
 * buttons on the GUI
 *
 * THIS FILE SHOULD ONLY BE INCLUDED BY THE FILE "mft.c"
 * ANY OTHER FILE INCLUDING IT WILL CAUSE NAME CONFLICTS
 *
 **********************************************************************/

#ifndef mft_help_h
#define mft_help_h

/*********************************************************************/
char	*helpString_anneal[] = {
  "Whether to run simulated annealing.  0 = don't, 1 = do anneal .",
  NULL } ;
/*********************************************************************/
char	*helpString_delayCount[] = {
  "Degree of relaxation slowdown used for viewing the details of",
  "network relaxation.  Basically, a trivial loop from 1 to",
  "delayCount*1000 is used between network relaxation sweeps.  This may",
  "be used while viewing the \"testing\" of cases (e.g. \"clicking\" on",
  "them in the \"Activations\" window) and only while the \"inRelaxation\"",
  "updating option is turned on in the Activations window. When",
  "viewing, try setting the var to 100 or 1000; performance and ease of",
  "viewing will vary depending on your machine's speed (\"raw\" CPU",
  "speed, memory access speed, screen update speed, etc.), of course.",
  NULL } ;
/*********************************************************************/
char	*helpString_maxDelta[] = {
  "Used in the equilibrium calculation.",
  NULL } ;
/*********************************************************************/
char	*helpString_relaxStepSize[] = {
  "What proportion of the \"desired\" step in activation space (during",
  "relaxation) to take.  Desired means what sigmoid(weighted sum of",
  "inputs) is computed to be.  The normal setting is relaxStepSize = 1,",
  "i.e. take the full step.  It might be reasonable, for certain",
  "desired network dynamics, to take smaller step sizes (e.g., .85) in",
  "some cases.",
  NULL } ;
/*********************************************************************/
char	*helpString_relaxSweepCountAve[] = {
  "The *average* number of relaxation sweeps per example per training",
  "loop.",
  NULL } ;
/*********************************************************************/
char	*helpString_relaxTolerance[] = {
  "Used in the calculation of whether \"equilibrium\" is reached at a",
  "given point in the relaxation. Basically, if largest change in the",
  "activation value of any unit, in the previous relaxation sweep, is",
  "smaller than relaxTolerance, then annealing will cease, as the",
  "network is \"at equilibrium.\"",
  NULL } ;
/*********************************************************************/
char	*helpString_synchronousUpdate[] = {
  "Whether to update the units synchronously (set var to 1) or",
  "asynchronously (set to 0) in the relaxation.  Asynch is considered",
  "much better in the vast majority of cases.  Also note that random",
  "order traversal is used in asynch case, and \"standard\" or \"row",
  "major\" order of traversing the units is used in the synch case.",
  NULL } ;
/*********************************************************************/
char	*helpString_tDecay[] = {
  "Factor by which to lower temperature at each annealing step.",
  "Something between .80 (fast annealing) and .99 (very slow annealing)",
  "is typical.",
  NULL } ;
/*********************************************************************/
char	*helpString_temperature[] = {
  "Current network temperature in annealing process.",
  NULL } ;
/*********************************************************************/
char	*helpString_tMax[] = {
  "Maximum temperature in annealing.  Usually something between 5 and",
  "30 is considered reasonable.",
  NULL } ;
/*********************************************************************/
char	*helpString_tMin[] = {
  "Minimum temperature in annealing.  Typically set to 1.0 .",
  NULL } ;
/*********************************************************************/
char	*helpString_unitFunction[] = {
  "If this field is set to 0, the total input to a unit is passed",
  "through a (0,1) sigmoid to produce its activation. If set to 1, the",
  "input is passed through the tanh function.",
  NULL } ;
/*********************************************************************/
char	*helpString_unitValueType[] = {
  "This field is unused in the current implementation.",
  NULL } ;
/*********************************************************************/
char	*helpString_weightCost[] = {
  "Cost associated with magnitude of weights.  It is sometimes useful",
  "to limit the absolute magnitude of weights in this way, in order to",
  "improve the trained net's \"generalization\" capabilities.",
  NULL } ;
/*********************************************************************/
char	*helpString_zeroErrorRadius[] = {
  "Interval of acceptance for agreement between desired output and",
  "target output of a unit.  The degree to which a \"near miss\" will",
  "count as a \"hit\".",
  NULL } ;
/*********************************************************************/

#endif				/* mft_help_h */
