
/**********************************************************************
 * $Id: hcl.h,v 1.3 92/11/30 11:56:54 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee, 
 * provided that the above copyright notice appears in all copies and that 
 * both the copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of University of Toronto 
 * not be used in advertising or publicity pertaining to distribution 
 * of the software without specific, written prior permission.  
 * University of Toronto makes no representations about the suitability 
 * of this software for any purpose. It is provided "as is" without 
 * express or implied warranty. 
 *
 * UNIVERSITY OF TORONTO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND 
 * FITNESS, IN NO EVENT SHALL UNIVERSITY OF TORONTO BE LIABLE FOR ANY 
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER 
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF 
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 **********************************************************************/


#define MIN(x, y)	((x) < (y) ? (x) : (y))
#define MAX(x, y)	((x) > (y) ? (x) : (y))

#ifndef HCL_H
#define HCL_H

/* The following structures must be defined, even if you don't
 * need them in you simulator
 */
typedef struct NetExtensionRec {	/* BIND */
  int   unitCounter;                    /* NOBIND */
  Real  radius;                         /* netParam: */
} NetExtensionRec ;

typedef struct GroupExtensionRec {	/* BIND */
  int   foo ;                           /* NOBIND */
} GroupExtensionRec ;

typedef struct UnitExtensionRec {	/* BIND */
  int   updateCounter ;                 /* NOBIND */
} UnitExtensionRec ;

typedef struct LinkExtensionRec {	/* BIND */
  int	foo ;                           /* NOBIND */
} LinkExtensionRec ;

typedef struct ExampleExtensionRec {	/* BIND */
  int	foo ;
} ExampleExtensionRec ;

#define MIN(x, y)	((x) < (y) ? (x) : (y))
#define MAX(x, y)	((x) > (y) ? (x) : (y))

#define Mepsilon(net)		((net)->mz->epsilon)
#define Mmomentum(net)		((net)->mz->alpha)
#define MdirectionMethod(net)	((net)->mz->directionMethod)
#define MstepMethod(net)	((net)->mz->stepMethod)
#define MbatchSize(net)		((net)->batchSize)
#define MunitCounter(net)	((net)->extension->unitCounter)
#define Mradius(net)        	((net)->extension->radius)

#endif				/* HCL_H */
