
/**********************************************************************
 * $Id: fem.h,v 1.3 92/11/30 11:55:37 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

 /*********************************************************************
 *
 *  MFT/FEM/Boltzmann Modules written by     Evan W. Steeg
 *                                           Dept. of Computer Science
 *  August 1991                              Univ. of Toronto
 *
 **********************************************************************/

#ifndef MFN_H
#define MFN_H

/* The following structures must be defined, even if you don't
 * need them in you simulator
 */
typedef struct NetExtensionRec {	/* BIND */
  Real	zeroErrorRadius ;	/* netParam: */
  Real	tMax ;			/* netParam: */
  Real	tMin ;			/* netParam: */
  Real	tDecay ;		/* netParam: */
  Real	temperature ;
  int   anneal;			/* netParam: */
  Real  relaxStepSize ;         /* netParam: */
  Real  relaxTolerance ;        /* netParam: */
  Real  maxDelta ;      
  int   unitFunction ;          /* netParam: */
  int   unitValueType ;         /* netParam: */
  
  Real  energy ;              
  Real  entropy ;            
  Real  freeEnergy ;        
  Real  probDesired ;      
  Real  probActual ;      

  Real  caseError ; 
  Real  averageError ; 

  Boolean	running ;
  int		delayCount  ;           /* netParam: */
  Real  	relaxSweepCountAve ;
} NetExtensionRec ;

typedef struct GroupExtensionRec {	/* BIND */
  int	foo ;
} GroupExtensionRec ;

typedef struct UnitExtensionRec {	/* BIND */
  int	foo ;
} UnitExtensionRec ;

typedef struct LinkExtensionRec {	/* BIND */
  Real	prod ;
} LinkExtensionRec ;

typedef struct ExampleExtensionRec {	/* BIND */
  int	foo ;
} ExampleExtensionRec ;


extern struct TRACE     inRelaxation ; /* BIND */


/* macros for getting at extension fields */
#define MzeroErrorRadius(net)	((net)->extension->zeroErrorRadius)

#define MtMax(net)		((net)->extension->tMax)
#define MtMin(net)		((net)->extension->tMin)
#define Mtemp(net)		((net)->extension->temperature)
#define MtDecay(net)		((net)->extension->tDecay)

#define Manneal(net)	        ((net)->extension->anneal)
#define MrelaxStepSize(net)     ((net)->extension->relaxStepSize)
#define MrelaxTolerance(net)    ((net)->extension->relaxTolerance)
#define MmaxDelta(net)		((net)->extension->maxDelta)
#define MunitFunction(net)      ((net)->extension->unitFunction)
#define MunitValueType(net)     ((net)->extension->unitValueType)

#define Mprod(link)		((link)->extension->prod)

#define Menergy(net)            ((net)->extension->energy)
#define Mentropy(net)           ((net)->extension->entropy)
#define MfreeEnergy(net)        ((net)->extension->freeEnergy)

#define MprobActual(net)        ((net)->extension->probActual)
#define MprobDesired(net)       ((net)->extension->probDesired)

#define Merror(net)             ((net)->error)
#define McaseError(net)         ((net)->extension->caseError)
#define MaverageError(net)      ((net)->extension->averageError)

#define MmaxDelta(net)		((net)->extension->maxDelta)

#define MdelayCount(net)	((net)->extension->delayCount)
#define Mrunning(net)		((net)->extension->running)
#define MrelaxSweepCountAve(net) ((net)->extension->relaxSweepCountAve)


/* useful macros */
#define T_MAX		5.0
#define T_MIN		1.0
#define T_DECAY		0.9

#define CLEAR           0
#define POSITIVE        1

#define MIN(x, y)	((x) < (y) ? (x) : (y))
#define MAX(x, y)	((x) > (y) ? (x) : (y))

extern	double fabs(), log();

/* Macros to calculate the sigmoid */
#define simpleSigmoid(x) (1.0/(1.0+exp(-(x))))
#define sigmoid(x)       ((x) > 30 ? 			\
			  (1.0) : ((x) < -30 ? (0.0) : simpleSigmoid(x)))
#define sigmoidDeriv(x)	((x)*(1.0 - (x)))

#define ENTROPY(x)    (((x) == 1.0) | ((x) == -1.0) | ((x) == 0.0)) ? \
  0.0 : ((x) * log(fabs((x))) + (1 - (x)) * log(fabs(1 - (x))))

#endif				/* MFN_H */
