
/**********************************************************************
 * $Id: unit.h,v 1.6 92/12/01 14:48:46 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef __bp_unit_h
#define __bp_unit_h

/***********************************************************************
 * Combin, Transfer, and Error Contribution functions
 **********************************************************************/
extern void	setDotProduct ARGS((Group	group)) ;
extern void	setMultiply   ARGS((Group	group)) ;
extern void	setDistance   ARGS((Group	group)) ;

extern void	setLogistic	  ARGS((Group	group)) ;
extern void	setLinear	  ARGS((Group	group)) ;
extern void	setTanh		  ARGS((Group	group)) ;
extern void	setSoftMax	  ARGS((Group	group)) ;
extern void	setExponential	  ARGS((Group	group)) ;
extern void	setNegExponential ARGS((Group	group)) ;
extern void	setGated	  ARGS((Group	group)) ;

extern void	setSumSquareError	   ARGS((Group	group)) ;
extern void	setAdaptiveSumSquareError  ARGS((Group	group)) ;
extern void	setCrossEntropyError	   ARGS((Group	group)) ;

/* set normal forward and backward 
 * (only use if you add new transfer functions)  */
extern void	setStandardForwardBackward ARGS((Group	group)) ;

/***********************************************************************
 * typedefs for the procedures
 **********************************************************************/
typedef void	(*CombInProc) 	ARGS((Unit)) ;
typedef void	(*TransferProc) ARGS((Unit)) ;
typedef void	(*ErrorProc)	ARGS((Unit)) ;

/***********************************************************************
 * Group extension record used by these procedures
 **********************************************************************/
typedef struct GroupExtensionRec {	/* BIND */
  CombInProc	combIn ;		/* calculate totalInput */
  CombInProc	combBack ;		/* fan derivatives back */

  TransferProc	transfer ; 		/* calculate output */
  TransferProc	transferBack ; 		/* backprop error   */

  ErrorProc	contributeError ; 	/* calculate output */
  ErrorProc	contributeErrorBack ; 	/* calculate output */

  Real		sum ;			/* miscellaneous sum */
  Variable	errorStdDev ;		/* nosave: used by adaptiveSumSquare*/

  /* stuff used by competing experts */
  Mixture	mixture ;	
  Group		gateGroup ;		/* nosave: */
} GroupExtensionRec ;
/***********************************************************************
 * Unit extension record
 **********************************************************************/
typedef struct UnitExtensionRec {	/* BIND */
  Variable	gain ;
  Group		expert ;
  Gaussian	gaussian ;
} UnitExtensionRec ;
/***********************************************************************
 * Net extension record
 **********************************************************************/
typedef struct NetExtensionRec {	/* BIND */
  Real		zeroErrorRadius ;	/* netParam: */
} NetExtensionRec ;
/**********************************************************************/


/***********************************************************************
 * macros for using the methods in the units and groups 
 **********************************************************************/
#define McombInProc(group)		((group)->extension->combIn)
#define McombBackProc(group)		((group)->extension->combBack)
#define MtransferProc(group)		((group)->extension->transfer)
#define MtransferBackProc(group)	((group)->extension->transferBack)
#define McontributeErrorProc(group)	((group)->extension->contributeError)
#define McontributeErrorBackProc(group)	((group)->extension->contributeErrorBack)

#define McombIn(unit)		McombInProc((unit)->group)	    (unit)
#define McombBack(unit)		McombBackProc((unit)->group)	    (unit)
#define Mtransfer(unit) 	MtransferProc((unit)->group)	    (unit)
#define MtransferBack(unit)	MtransferBackProc((unit)->group)    (unit)
#define McontributeError(unit)	McontributeErrorProc((unit)->group) (unit)
#define McontributeErrorBack(unit) 	\
  McontributeErrorBackProc((unit)->group) (unit)

#define MoutputSum(group)		((group)->extension->sum)
#define MerrorStdDevVar(group)		((group)->extension->errorStdDev)

#define MzeroErrorRadius(net)	((net)->extension->zeroErrorRadius)

#define Mgate(group)		 ((group)->extension->gateGroup)
#define Mgated(group)		 ((group)->extension->gateGroup)
#define Mmixture(group)		 ((group)->extension->mixture)
#define Mgaussian(unit)		 ((unit)->extension->gaussian)
#define Mexpert(unit)		 ((unit)->extension->expert)
/**********************************************************************/

#endif				/* __bp_unit_h */
