
/**********************************************************************
 * $Id: help.h,v 1.5 93/01/15 13:04:21 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/**********************************************************************
 * These help strings will be automatically registered 
 * and made available to the "whatis" command and "Help"
 * buttons on the GUI
 *
 * THIS FILE SHOULD ONLY BE INCLUDED BY THE FILE "bp.c"
 * ANY OTHER FILE INCLUDING IT WILL CAUSE NAME CONFLICTS
 *
 **********************************************************************/

#ifndef bp_help_h
#define bp_help_h

/*********************************************************************/
char	*helpString_weightCost[] = {
  "Cost associated with magnitude of weights.  It is sometimes useful",
  "to limit the absolute magnitude of weights in this way, in order to",
  "improve the trained net's \"generalization\" capabilities.",
  NULL } ;
/*********************************************************************/
char	*helpString_zeroErrorRadius[] = {
  "Interval of acceptance for agreement between desired output and",
  "actual output of a unit.  The degree to which a \"near miss\" will",
  "count as a \"hit\" (ignored by units that use cross entropy error).",
  NULL } ;
/*********************************************************************/
char	*helpString_outputSum[] = {
  "The sum of all unit ouputs in a group. This is used by soft max",
  "groups to normalize their outputs",
  NULL } ;
/*********************************************************************/
char	*helpString_addGroup[] = { 
  "Besides the standard type masks \"INPUT\" \"BIAS\" and \"OUTPUT\", this",
  "module recognizes several masks which affect the behaviour of the",
  "units in the group.",
  "",
  "You may specify one type from each of the following sets:",
  "",
  "DPROD - causes each unit's input to be the dot product of its",
  "	incoming weights and the previous units' outputs (default).",
  "DISTANCE - causes each unit's input to be the sum of the squares",
  "	of the difference between the previous unit's output and the",
  "	corresponding link's weight.",
  "PI - causes each unit's input to be the product of the weight on",
  "	its incoming connections (automatically constrained to be",
  "	equal) and the previous units' outputs.",
  "",
  "",
  "LOGISTIC - gives each unit a logistic (sigmoid) activation function",
  "	(default).",
  "LINEAR - gives each unit a linear activation function.",
  "TANH - gives each unit a hyperbolic tanh activation function.",
  "EXPONENTIAL - gives each unit an exponential activation function.",
  "NEGEXPONENTIAL - gives each unit an negative exponential activation",
  "	function (exp(-totalInput)).",
  "SOFTMAX - causes each unit a to use soft max. It also sets the",
  "	error function (and group mask) to CROSSENTROPY",
  "",
  "",
  "SUMSQUARE - an output unit's error contribution will be the sum of",
  "	the squared error. This error measure implies that the errors",
  "	of the units come from a gaussian distribution, with mean 0,",
  "	and a fixed variance. The sumsquare error is the log of the",
  "	probabilty that the observed errors come from this distribution.",
  "	(default)", 
  "ADAPTIVESUMSQUARE - the same as sumsquare, without the assumption that",
  "	the variance of the gaussian distribution is fixed. This adds",
  "	another term to the error measure, which may become negative",
  "	due to the log transform.",
  "CROSSENTROPY - an output unit's error contribution will be the cross-",
  "	entropy between the actual and desired output distributions.",
  "	Only use this error measure if the activation function gives",
  "	values on the range (0, 1).",
  "",
  "",
  "You may also specify:",
  "RBF - this makes all units in the group radial basis function units.",
  "	It is a shortcut for specifying DISTANCE and NEGEXPONENTIAL",
  "IPI - use this type for a group with all units immediately post input",
  "	(e.g. the first hidden layer). It causes derivatives to *not* be",
  "	propagated back to the inputs, and can cause a significant speedup",
  "	in the simulation.",
  "GATE - used with a mixture of experts. A GATE group is used to gate",
  "	(manage) the experts. Each unit in the group will be used to",
  "	control a single group (the expert group), and it therefore must",
  "	have the same number of units as there are expert groups. It must",
  "	be used in concert with the \"gate\" command. GATE forces the",
  "	SOFTMAX activation function.",
  "GATED - used to specify the output group with a mixture of experts.",
  "	It must also be type OUTPUT. The group should have no incoming",
  "	connections. It is used solely as a dummy group to store the",
  "	targets for the experts, and must be used in concert with the",
  "	\"gate\" command.",
  NULL } ;
/*********************************************************************/

#endif				/* bp_help_h */
