
/**********************************************************************
 * $Id: bp.h,v 1.6 92/12/01 14:48:42 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

#ifndef __bp_bp_h
#define __bp_bp_h

#define MIN(x, y)	((x) < (y) ? (x) : (y))
#define MAX(x, y)	((x) > (y) ? (x) : (y))

#define MbatchSize(net)		((net)->batchSize)

#define DISTANCE	((int)(1<<(HIGHEST_BIT_USED+1)))
#define DPROD		((int)(1<<(HIGHEST_BIT_USED+2)))
#define PI		((int)(1<<(HIGHEST_BIT_USED+3)))

#define LOGISTIC	((int)(1<<(HIGHEST_BIT_USED+4)))
#define LINEAR		((int)(1<<(HIGHEST_BIT_USED+5)))
#define TANH		((int)(1<<(HIGHEST_BIT_USED+6)))
#define HYPERBOLIC	TANH
#define SOFTMAX		((int)(1<<(HIGHEST_BIT_USED+7)))
#define EXPONENTIAL	((int)(1<<(HIGHEST_BIT_USED+8)))
#define NEGEXPONENTIAL	((int)(1<<(HIGHEST_BIT_USED+9)))

#define SUMSQUARE	((int)(1<<(HIGHEST_BIT_USED+10)))
#define ADAPTIVESUMSQUARE	((int)(1<<(HIGHEST_BIT_USED+11)))
#define CROSSENTROPY	((int)(1<<(HIGHEST_BIT_USED+12)))
#define GATED		((int)(1<<(HIGHEST_BIT_USED+13)))

#define RBF		((int)(1<<(HIGHEST_BIT_USED+14)))
#define IPI		((int)(1<<(HIGHEST_BIT_USED+15)))
#define GAIN		((int)(1<<(HIGHEST_BIT_USED+16)))

#define GATE		((int)(1<<(HIGHEST_BIT_USED+17)))

#define COMBIN_MASKS	(PI | DPROD | DISTANCE)
#define ERROR_MASKS 	(SUMSQUARE | CROSSENTROPY | ADAPTIVESUMSQUARE)
#define EXP_TRANSFERS	(EXPONENTIAL | NEGEXPONENTIAL)
#define TRANSFER_MASKS	(LOGISTIC | LINEAR | TANH | SOFTMAX | EXP_TRANSFERS)
#define MISC_MASKS 	(IPI | RBF | GAIN)
#define FIXED_MASKS 	(OUTPUT | INPUT | BIAS | GATE | GATED)

#endif				/* __bp_bp_h */
