#include "sofmdefs.h"

/*********************  main control ************************/

main(argc,argv)
int argc; char *argv[];
{
  init_params(argv);
  read_inputs();
#ifdef hp
  if (displaying) display_init();
#endif
  if (continuing) iterate_snapshots();
  else init_weights();
  training();
#ifdef hp
  if (displaying) gclose(fildes);
#endif
  exit(0);
}

iterate_snapshots()
/* go through the saved snapshots, displaying them on the screen */
{
  register int i;
  int oldt, oldtesting, readfun(), randfun();

  fp=fopen(simufile,"r");
  read_params(fp);
  oldtesting=testing;
  testing=1;				/* we don't want to change weights */
  oldt=0;
  iterate_weights(randfun); /* just to update rand */
  while (fscanf(fp,"%d",&t)!=EOF) /* read the t */
    {
      /* update rand and parameters */
      startt=t+1;
      for(i=0; i<startt-oldt; i++) shuffle();
      oldt=startt;
      
      /* read the current weights */
      iterate_weights(readfun);
      if (displaying)
	{
	  present_inputs();
	  while (getchar()!='\n');
	}
    }
  fclose(fp);
  for (nextsnapshot=0; t >= snapshots[nextsnapshot]; nextsnapshot++){}
  testing=oldtesting;
}

      
training()
{
  for(t=startt; t<=tend; t++)
    {
      present_inputs();
      if (t >= snapshots[nextsnapshot]) save_current();
      shuffle();
    }
}


present_inputs()
{
  register int i;
  float alpha();
  while (t>t_[phase]) phase++;
  init_units();
  for(i=0; i<nvectors; i++)
    {
      compute_responses(shuffletable[i]);
      if (!testing)
	modify_weights( nc(t), alpha(t), shuffletable[i]);
    }
  if (displaying) display_best();
}

/*********************  feature map ******************************/

compute_responses(inpv)
int inpv;
{
  register int i,j;
  float distance();
  float best=maxdistance;
  for(i=0; i<nx; i++)
    for(j=0; j<ny; j++)
      {
	units[i][j].value = distance(vectors[inpv].comp, units[i][j].comp,dim);
	/* check if this unit's response is best so far encountered */
	if (units[i][j].value < best)
	  {
	    besti=i; bestj=j; best=units[i][j].value;
	  }
	if (units[i][j].value < units[i][j].bestvalue){
	  units[i][j].bestvalue = units[i][j].value;
	  units[i][j].labels[0] = inpv;
	}
      }
/*  printf("%s : %f\n", vectors[inpv].label, best);*/
  units[besti][bestj].labelcount=units[besti][bestj].labelcount+1;
  units[besti][bestj].labels[ units[besti][bestj].labelcount ] = inpv;
}

modify_weights(nc, alpha, inpv)
int nc, inpv;
float alpha;
{
  register int i, j, k;
  int lowi, highi, lowj, highj;
  /* modify weighs toward the input in a neighborhood of the maximally 
     responding unit */
  lowi=besti-nc;  if (lowi<0) lowi=0;
  highi=besti+nc; if (highi>=nx) highi=nx-1;
  lowj=bestj-nc; if (lowj<0) lowj=0;
  highj=bestj+nc; if (highj>=ny) highj=ny-1;
  for(i=lowi; i<=highi; i++)
    for(j=lowj; j<=highj; j++)
      for(k=0; k<dim; k++)
	units[i][j].comp[k] +=
	  alpha*(vectors[inpv].comp[k]-units[i][j].comp[k]);
}

/*********************  initializations ******************************/

init_params(argv)
char *argv[1];
{
  int c;

  /* we want to use index -1 to refer to initial values */
  t_=t_array+1; nc_=nc_array+1; alpha_=alpha_array+1;
   
  sprintf(simufile, "%s", argv[1]);
  fp=fopen(simufile,"r");
  read_params(fp);
  if((c=getc(fp))==EOF) continuing=0;
  else continuing=1;
  fclose(fp);

  srand48(seed);		        /* start random number sequence */
  t=(-1);
  startt=phase=t_[-1]=0;
}

read_params(fp)
FILE *fp;
{
  char s[100];
  register int i,phase;
  int nphase;
  /* simulation parameters */
  fscanf(fp,"%s", vectorfile); fgets(s,99,fp);
  fscanf(fp,"%s", cmapfile); fgets(s,99,fp);
  fscanf(fp,"%s", sb_outdev); fgets(s,99,fp);
  fscanf(fp,"%s", sb_outdriver); fgets(s,99,fp);

  fscanf(fp,"%f %f %f %f", &left,&low,&right,&high); fgets(s,99,fp);
  fscanf(fp,"%d %d", &nx, &ny); fgets(s,99,fp);
  fscanf(fp,"%d %d", &displaying,&seed); fgets(s,99,fp);
  fscanf(fp,"%d %d %d %f", &tend, &nphase, &nc_[-1], &alpha_[-1]);
  fgets(s,99,fp);

  for(phase=0; phase<nphase; phase++)
    {
      fscanf(fp,"%d %d %f", &t_[phase], &nc_[phase],&alpha_[phase]);
      fgets(s,99,fp);
    }
  
  /* saving info */
  fscanf(fp,"%d", &snapshots[0]);
  for(i=0; i<maxsnaps && snapshots[i]<snapshotend; i++)
    fscanf(fp,"%d", &snapshots[i+1]);
  fgets(s,99,fp);
  nextsnapshot=0;
}


read_inputs()
{
  register int i,j;
  char s[100];

  fp=fopen(vectorfile,"r");

  /* read labelfilename and vector dimension */
  fscanf(fp,"%s", labelfile); fgets(s,99,fp);
  fscanf(fp,"%d", &dim); fgets(s,99,fp);

  /* read the labels */
  fp2=fopen(labelfile,"r");
  for(i=0; i<maxvectors && fscanf(fp2,"%s", vectors[i].label)!=EOF; i++);
  nvectors=i;
  fclose(fp2);

  /* read the vectors */
  for(i=0; i<nvectors; i++)
    for(j=0; j<dim; j++)
      fscanf(fp,"%f",&vectors[i].comp[j]);

  for(i=0; i<nvectors; i++)
    shuffletable[i]=i;
  shuffle();
}


init_weights()
{
  int randfun();
  iterate_weights(randfun);
  if (snapshots[0]==(-1))
    save_current();			/* save the initial state */
}


init_units()
{
  register int i,j;
  for(i=0; i<nx; i++)
    for(j=0; j<ny; j++) 
      {
	units[i][j].bestvalue = 999999999.9;
	units[i][j].labelcount= 0;
      }
}


/*********************** I/O etc functions *****************/ 

save_current()
{
  int writefun();
  fp=fopen(simufile,"a");
  fprintf(fp,"%d\n", t);
  iterate_weights(writefun);
  fclose(fp);
  nextsnapshot++;
}

iterate_weights(dofun)
int (*dofun)();
{
  register int i,j,k;

  for(i=0; i<nx; i++)
    for(j=0; j<ny; j++)
      for(k=0; k<dim; k++)
        (*dofun)(&units[i][j].comp[k]);

}  

shuffle()
{
  register int i;
  int temp1,temp2,temp3;
  for(i=0; i<nvectors; i++)
    {
      temp1=lrand48()%nvectors;
      temp2=lrand48()%nvectors;
      temp3=shuffletable[temp1];
      shuffletable[temp1]=shuffletable[temp2];
      shuffletable[temp2]=temp3;
    }
}

readfun(place)
float *place;
{
  fscanf(fp,"%f", place);
} 

writefun(place)
float *place;
{
  fprintf(fp,"%f\n", *place);
} 

randfun(place)
float *place;
{
  float f01rnd();
  *place = f01rnd();
} 

      
/***********************  math stuff **************************/

float distance(v1, v2, ncomp)
int ncomp;
float v1[],v2[];
{
  float sum=0.0;
  register int i;
  /* unit response is equal to the euclidian distance of input and weight */
  for(i=0; i<ncomp; i++)
    sum=sum+(v1[i]-v2[i])*(v1[i]-v2[i]);
  return(sqrt(sum));
}

float alpha(t)
int t;
{
  /* decrease gain linearly within the phase */
  return(alpha_[phase-1] +
	 (alpha_[phase]-alpha_[phase-1])*
	 (t-t_[phase-1])/(t_[phase]-t_[phase-1])
	 );
}

nc(t)
int t;
{
  /* decrease neighborhood size linearly within the phase */
  return(floor( nc_[phase-1] + 0.999999 +
	       ((float) nc_[phase]-nc_[phase-1]) *
	       (t-t_[phase-1])/(t_[phase]-t_[phase-1])
	       )
	 );
}
 
float f01rnd()
{
  /* random float between 0 and 1 */
  return (drand48());
}
