#include "sofmdefs.h"

/*********************  main control ************************/

main(argc,argv)
int argc; char *argv[];
{
  init_params(argv);
#ifdef hp
  if (displaying) display_init();
#endif
  if (continuing) iterate_snapshots();
  else init_weights();
  training();
#ifdef hp
  if (displaying) gclose(fildes);
#endif
  exit(0);
}

iterate_snapshots()
/* go through the saved snapshots, displaying them on the screen */
{
  register int i;
  int oldt, readfun(), randfun();
  float alpha();

  fp=fopen(simufile,"r");
  read_params(fp);
  oldt=0;
  iterate_weights(randfun); /* just to update rand */
  while (fscanf(fp,"%d",&t)!=EOF) /* read the t */
    {
      /* update rand and parameters */
      startt=t+1;
      for(i=0; i<startt-oldt; i++)
	{ 
	  generate_input();
#ifdef hp
	  if (displaying) display_input();
#endif
	}
      oldt=startt;
      
      /* read the current weights */
      iterate_weights(readfun);
      present_inputs();     /* we'll have to modify weights during last snap*/
#ifdef hp
      if (displaying) while (getchar()!='\n');
#endif
    }
  fclose(fp);
  for (nextsnapshot=0; t >= snapshots[nextsnapshot]; nextsnapshot++){}
}

      
training()
{
  for(t=startt; t<=tend; t++)
    {
      generate_input();
      if (t >= snapshots[nextsnapshot]) save_current();
      present_inputs();
    }
}


present_inputs()
{
  float alpha();
  while (t>t_[phase]) phase++;
#ifdef hp
  if (displaying) display_current(phase,t,nc(t),alpha(t));
  if (displaying) display_weights();
  if (displaying) display_input();
#endif
  compute_responses();
#ifdef hp
  if (displaying) display_responses();
#endif
  modify_weights( nc(t), alpha(t));
}

/*********************  feature map ******************************/

compute_responses()
{
  register int i,j;
  float distance();
  float best=maxdistance;
  for(i=0; i<nx; i++)
    for(j=0; j<ny; j++)
      {
	units[i][j].value = distance(vectors.comp, units[i][j].comp,dim);
	/* check if this unit's response is best so far encountered */
	if (units[i][j].value < best)
	  {
	    besti=i; bestj=j; best=units[i][j].value;
	  }
      }
}

modify_weights(nc,alpha)
int nc;
float alpha;
{
  register int i, j, k;
  int lowi, highi, lowj, highj;
  /* modify weighs toward the input in a neighborhood of the maximally 
     responding unit */
  lowi=besti-nc;  if (lowi<0) lowi=0;
  highi=besti+nc; if (highi>=nx) highi=nx-1;
  lowj=bestj-nc; if (lowj<0) lowj=0;
  highj=bestj+nc; if (highj>=ny) highj=ny-1;
  for(i=lowi; i<=highi; i++)
    for(j=lowj; j<=highj; j++)
      for(k=0; k<dim; k++)
	units[i][j].comp[k] += alpha*(vectors.comp[k]-units[i][j].comp[k]);
}

/*********************  initializations ******************************/

init_params(argv)
char *argv[1];
{
  register int i;
  int c;

  /* we want to use index -1 to refer to initial values */
  t_=t_array+1; nc_=nc_array+1; alpha_=alpha_array+1;
   
  sprintf(simufile, "%s", argv[1]);
  fp=fopen(simufile,"r");
  read_params(fp);
  if((c=getc(fp))==EOF) continuing=0;
  else continuing=1;
  fclose(fp);

  srand48(seed);		        /* start random number sequence */
  t=(-1);
  startt=phase=t_[-1]=0;
  dim=maxdim;
  for(i=0; i<dim; i++)
    vectors.comp[i]=maxdistance;	/* previous input outside the screen */
}

read_params(fp)
FILE *fp;
{
  char s[100];
  register int i, phase;
  int nphase;
  /* simulation parameters */
  fscanf(fp,"%s", cmapfile); fgets(s,99,fp);
  fscanf(fp,"%s", sb_outdev); fgets(s,99,fp);
  fscanf(fp,"%s", sb_outdriver); fgets(s,99,fp);

  fscanf(fp,"%f %f %f %f", &left,&low,&right,&high); fgets(s,99,fp);
  fscanf(fp,"%d %d", &nx, &ny); fgets(s,99,fp);
  fscanf(fp,"%d %d", &displaying,&seed); fgets(s,99,fp);
  fscanf(fp,"%d %d %d %f", &tend, &nphase, &nc_[-1], &alpha_[-1]);
  fgets(s,99,fp);

  for(phase=0; phase<nphase; phase++)
    {
      fscanf(fp,"%d %d %f", &t_[phase], &nc_[phase],&alpha_[phase]);
      fgets(s,99,fp);
    }
  
  /* saving info */
  fscanf(fp,"%d", &snapshots[0]);
  for(i=0; i<maxsnaps && snapshots[i]<snapshotend; i++)
    fscanf(fp,"%d", &snapshots[i+1]);
  fgets(s,99,fp);
  nextsnapshot=0;
}

init_weights()
{
  int randfun();
  iterate_weights(randfun);
}


/*********************** I/O etc functions *****************/ 

save_current()
{
  int writefun();
  fp=fopen(simufile,"a");
  fprintf(fp,"%d\n", t);
  iterate_weights(writefun);
  fclose(fp);
  nextsnapshot++;
}

iterate_weights(dofun)
int (*dofun)();
{
  register int i,j,k;

  for(i=0; i<nx; i++)
    for(j=0; j<ny; j++)
      for(k=0; k<dim; k++)
        (*dofun)(&units[i][j].comp[k]);

}  

readfun(place)
float *place;
{
  fscanf(fp,"%f", place);
} 

writefun(place)
float *place;
{
  fprintf(fp,"%f\n", *place);
} 

randfun(place)
float *place;
{
  float f01rnd();
  *place = f01rnd();
} 

      
/***********************  math stuff **************************/

float distance(v1, v2, ncomp)
int ncomp;
float v1[],v2[];
{
  float sum=0.0;
  register int i;
  /* unit response is equal to the euclidian distance of input and weight */
  for(i=0; i<ncomp; i++)
    sum=sum+(v1[i]-v2[i])*(v1[i]-v2[i]);
  return(sqrt(sum));
}

float alpha(t)
int t;
{
  /* decrease gain linearly within the phase */
  return(alpha_[phase-1] +
	 (alpha_[phase]-alpha_[phase-1])*
	 (t-t_[phase-1])/(t_[phase]-t_[phase-1])
	 );
}

nc(t)
int t;
{
  /* decrease neighborhood size linearly within the phase */
  return(floor( nc_[phase-1] + 0.999999 +
	       ((float) nc_[phase]-nc_[phase-1]) *
	       (t-t_[phase-1])/(t_[phase]-t_[phase-1])
	       )
	 );
}
 
float f01rnd()
{
  /* random float between 0 and 1 */
  return (drand48());
}
