#include "net.h"
#include "bp.h"


	   /**********************************************************/
	   /********  XOR learning Backpropagation Network  **********/
	   /**********************************************************/



#define NoFeatures	2
#define NoOutputs	1
#define NoPatterns	4
#define NoHidden	5
#define NoBias		1
#define momentum	0.9


int d;

		/****** Input pattern definitions ******/


float InputPatterns1 [NoPatterns][NoFeatures]=
      {
      {1,0},
      {0,1},
      {1,1},
      {0,0}
       };


			/**** Set definitions ****/


SetPtr InputSet,HiddenSet, OutputSet, BiasSet;




		   /******  Auxiliary functions *****/

void SetInputAndTargetPattern (int d)
  {
  int i,j;
  TraverseSet (OutputSet, ZeroFree2);
  for (i=0; i<NoFeatures; i++)
      SetMember(InputSet, i)->Output=(float)InputPatterns1[d][i];
  if (d==0 || d==1)
     OutputSet->Members[0]->Free2=1.0;
  else
     OutputSet->Members[0]->Free2=0.0;
  }


void reset()
 {
 SetLinksParamSetToSet (InputSet, HiddenSet, WEIGHT, 0.1, -0.1);
 SetLinksParamSetToSet (HiddenSet, OutputSet, WEIGHT, 0.1, -0.1);
 SetLinksParamSetToSet (BiasSet, HiddenSet, WEIGHT, 0.1, -0.1);
 SetLinksParamSetToSet (BiasSet, OutputSet, WEIGHT, 0.1, -0.1);

 SetLinksParamSetToSet (InputSet, HiddenSet, FREE1, 1.0, 1.0);
 SetLinksParamSetToSet (HiddenSet, OutputSet, FREE1, 1.0, 1.0);
 SetLinksParamSetToSet (BiasSet, HiddenSet, FREE1, 1.0, 1.0);
 SetLinksParamSetToSet (BiasSet, OutputSet, FREE1, 1.0, 1.0);
 }




		/**************  Build & Run  ****************/


void Build ()
	{
	Squaresize=100;
	lrate_bp=0.5;
	randomize();

	InstallParameter ("Tss", &Tss);
	InstallParameter ("Pss", &Pss);
	InstallParameter ("Gain", &gain);
	InstallParameter ("lrate", &lrate_bp);
	InstallCommand	 ("reset", reset);

	InputSet = MakeNamedSet ("Input", "A B", 1, NoFeatures);
	OutputSet = MakeNamedSet ("Output", "XOR(A,B)", 1, NoOutputs);
	HiddenSet = MakeSet ("Hidden", 1, NoHidden);
	BiasSet = MakeSet ("Bias", 1, NoBias);

	ConnectSets (InputSet, HiddenSet, 0.1, -0.1);
	ConnectSets (InputSet, OutputSet, 0.1, -0.1);
	ConnectSets (HiddenSet, OutputSet, 0.1, -0.1);
	ConnectSets (BiasSet, HiddenSet, 0.1, -0.1);
	ConnectSets (BiasSet, OutputSet, 0.1, -0.1);

	SetMember (BiasSet, 0)->Output= 1.0;
	}


void Run()
  {
  TraverseSet 		(HiddenSet, ZeroFree1);

  SetInputAndTargetPattern (d);

  TraverseSet 		(HiddenSet, UpdateOutput);
  TraverseSet 		(OutputSet, UpdateOutput);

  TraverseSet 		(OutputSet, SetOutputError);
  TraverseSetLinks 	(OutputSet, Backwards);
  TraverseSet 		(HiddenSet, SetHiddenError);
  TraverseSetLinks 	(HiddenSet, FromFirstHiddenBackwards);

  ComputeTss		(OutputSet, NoPatterns);
  ComputePss		(OutputSet);
  d++;
  if (d==4) d=0;
  }






