#include "net.h"


	/**********************************************************************/
	/*****************    Schnys's Clustering Network  ********************/
	/***** A network using a non-supervised, Kohonen-type learning rule ***/
	/* Schnys, P.G.:A modular neural network model of concept acquisition */
        /******************* Cognitive Science,15,461-508, 1991 ***************/
	/**********************************************************************/



#define NoFeatures	30
#define NoAnimals	14
#define NoOutput	100

float lrate=0.1, a=0.05;


		/****** Input pattern definitions ******/


// The patterns that follow define different animals described as vectors of the above features 

float InputPatterns [NoAnimals][NoFeatures]=
      {
      {-1,1, -1,1, -1,1, 1,1,-1, 1,-1, 1,-1, 1,1,-1,-1,-1, -1,-1,1, -1,-1,1, -1,-1,1, -1,1,-1},
      {1,-1, 1,-1, 1,-1, -1,1,-1, 1,-1, 1,-1, 1,-1,-1,-1,1, 1,-1,-1, -1,1,-1, -1,1,-1, -1,1,-1},
      {1,-1, 1,-1, 1,-1, -1,1,-1, -1,1, -1,1, 1,1,-1,-1,-1, 1,-1,-1, 1,-1,-1, 1,-1,-1, 1,-1,-1},
      {-1,1, -1,1, -1,1, -1,1,-1, -1,1, 1,-1, 1,1,-1,-1,-1, -1,-1,1, 1,-1,-1, 1,-1,-1, -1,1,-1},
      {-1,1, -1,1, -1,1, -1,1,1, 1,-1, 1,-1, 1,1,-1,-1,-1, -1,-1,1, -1,-1,1, -1,-1,1, -1,1,-1},
      {1,-1, 1,-1, 1,-1, -1,1,-1, 1,-1, 1,-1, 1,-1,-1,-1,1, -1,1,-1, -1,1,-1, -1,1,-1, -1,1,-1},
      {1,-1, 1,-1, 1,-1, -1,1,-1, -1,1, -1,1, 1,1,-1,-1,-1, -1,1,-1, -1,1,-1, -1,1,-1, -1,1,-1},
      {-1,1, -1,1, -1,1, 1,-1,-1, -1,1, 1,-1, -1,-1,-1,1,1, -1,-1,1, -1,-1,1, -1,-1,1, -1,-1,1},
      {1,-1, 1,-1, 1,-1, -1,1,-1, 1,-1, 1,-1, -1,-1,-1,1,-1, -1,-1,1, -1,1,-1, -1,1,-1, -1,1,-1},
      {1,-1, 1,-1, 1,-1, -1,1,-1, -1,1, -1,1, -1,-1,1,-1,-1, -1,-1,1, -1,-1,1, -1,1,-1, 1,-1,-1},
      {-1,1, -1,1, -1,1, -1,1,-1, -1,1, 1,-1, -1,1,-1,-1,-1, -1,-1,1, -1,1,-1, -1,1,-1, -1,-1,1},
      {-1,1, -1,1, -1,1, 1,-1,-1, 1,-1, 1,-1, -1,-1,1,-1,-1, -1,-1,1, -1,1,-1, -1,1,-1, -1,1,-1},
      {-1,1, 1,-1, 1,1, -1,1,1, -1,1, 1,-1, -1,-1,1,-1,-1, -1,-1,1, -1,-1,1, -1,-1,1, -1,-1,1},
      {1,-1, 1,-1, 1,-1, -1,1,1, -1,1, 1,-1, -1,-1,1,-1,-1, -1,-1,1, -1,-1,1, -1,-1,1, -1,-1,1}
      };


			/**** Set definitions ****/


SetPtr InputSet, OutputSet;




		   /******  Auxiliary functions *****/


void SetInputPattern(int d)
  {
  int i,j;
  for (i=0; i<NoFeatures; i++)
    InputSet->Members[i]->Output=(float)InputPatterns[d][i];
  }

void Input (int yy)
  {
  switch(yy)
    {
    case 0: SetInputPattern (0);break;
    case 1: SetInputPattern (1);break;
    case 2: SetInputPattern (2);break;
    case 3: SetInputPattern (3);break;
    case 4: SetInputPattern (4);break;
    case 5: SetInputPattern (5);break;
    case 6: SetInputPattern (6);break;
    case 7: SetInputPattern (7);break;
    case 8: SetInputPattern (8);break;
    case 9: SetInputPattern (9);break;
    case 10: SetInputPattern (10);break;
    case 11: SetInputPattern (11);break;
    case 12: SetInputPattern (12);break;
    case 13: SetInputPattern (13);break;
    }
  }


	  /******  'Traverse'  functions *****/



void UpdateOutput (UnitPtr unit)
  {
  unit->Output = WeightedSum(unit);
  }


void Learn (SetPtr set)
  {
  int i, j, c, mc, mr, Max;
  float distance, D, OutputOfMax;
  LinkPtr curlink;
  UnitPtr unit;

  Max=MaxOutput (set);
  OutputOfMax=fabs(SetMember(set,Max)->Output);
  c=set->Columns;
  mc= Max%c;
  mr= (Max-mc)/c;


  for (i=0; i<set->Length; i++)
      {
      unit=SetMember(set,i);

      distance=sqrt (pow (mc-unit->Column,2.0) +
		     pow (mr-unit->Row,2.0));
      D=exp(-a*pow (distance, 2.0));
      curlink=unit->Links;
      while (curlink)
	  {
	   curlink->Weight +=  lrate*curlink->From->Output*
				     (1.0 - OutputOfMax)*D;
	   curlink = curlink->Next;
	  }

      }

  }


	       /*******  Build & Run  *******/

void Build ()
	{
	int i;
	Squaresize=25;
	randomize();
	lrate=0.05;

	InstallParameter ("lrate", &lrate);

	InputSet= MakeNamedSet ("InputSet", "mouth beak hair feathers givesmilk layseggs flies walks swims eatsmeat eatsplants claw hoof black white gray red yellw spot stripe amorph longneck mediumneck shortneck longlegs mediumlegs shortlegs big medium small",
				 2, NoFeatures/2);
	OutputSet= MakeSet ("OutputSet", 10,10);

	ConnectSets (InputSet, OutputSet, 0.01, -0.01);
	}


void Run()
  {
  Input (random (NoAnimals));

  TraverseSet (OutputSet, UpdateOutput);

  Learn (OutputSet);
  }






