#include "net2.h"



#define ERRORS_ID	11511

int x=0,y=0;
	/******************* Getting units' and links' parameters *****************/
int setid;
void OutputSquares (SetPtr set, int v1, int v2)
  {
  set->ScreenMtrx [0]=v1;
  set->ScreenMtrx [1]=v2;
  set->ScreenMtrx [5]=2;
  }


float GetUnitParam (UnitPtr unit, int field)
  {
  if (!unit) return (0);
  switch(field)
    {
    case OUTPUT: return (unit->Output);
    case NETINPUT: return (unit->Netinput);
    case FREE1: return (unit->Free1);
    case FREE2: return (unit->Free2);
    case FREE3: return (unit->Free3);
    default: break;
    }
  return (NULL);
  }

float GetLinkParam (LinkPtr link, int field)
  {
  if (!link) return (0);
  switch(field)
    {
    case WEIGHT: return (link->Weight);
    case FREE1: return (link->Free1);
    case FREE2: return (link->Free2);
    case FREE3: return (link->Free3);
    default: break;
    }
  return (NULL);
  }

float *GetUnitParamPointer (UnitPtr unit, int field)
  {
  if (!unit) return(NULL);
  switch(field)
    {
    case OUTPUT: return (&(unit->Output));
    case NETINPUT: return (&(unit->Netinput));
    case FREE1: return (&(unit->Free1));
    case FREE2: return (&(unit->Free2));
    case FREE3: return (&(unit->Free3));
    default: break;
    }
  return (NULL);
  }

float *GetLinkParamPointer (LinkPtr link, int field)
  {
  if (!link) return (0);
  switch(field)
    {
    case WEIGHT: return (&(link->Weight));
    case FREE1: return (&(link->Free1));
    case FREE2: return (&(link->Free2));
    case FREE3: return (&(link->Free3));
    default: break;
    }
  return (NULL);
  }
	/***************  Putting and setting units' and links' parameters *****************/


void PutUnitParam (UnitPtr unit, int field, float value)
  {
  if (!unit) return;
  switch(field)
    {
    case OUTPUT: unit->Output=value; break;
    case NETINPUT: unit->Netinput=value; break;
    case FREE1: unit->Free1=value; break;
    case FREE2: unit->Free2=value; break;
    case FREE3: unit->Free3=value; break;
    default: break;
    }
  }

void PutLinkParam (LinkPtr link, int field, float value)
  {
  switch (field)
    {
    case WEIGHT: link->Weight=value; break;
    case FREE1:  link->Free1=value; break;
    case FREE2:  link->Free2=value; break;
    case FREE3:  link->Free3=value; break;
    default: break;
    }
  }

void PutLinksParam (SetPtr toset, int field, float value)
  {
  int i;
  UnitPtr to;
  LinkPtr curlink;

  for (i=0; i<toset->Length; i++)
      {
      to=toset->Members[i];
      curlink=to->Links;
      while (curlink)
	{
	PutLinkParam (curlink, field, value);
	curlink=curlink->Next;
	}
      }
  }

void SetUnitParam (UnitPtr unit, int field, float upper, float lower)
  {
  float value;
  time_t t;

  srand((unsigned) time(&t));
  if (upper > lower)
     value= myrandom (upper, lower);
  else value=lower;
  PutUnitParam (unit, field, value);
  }


void SetUnitsParam (SetPtr set, int field, float upper, float lower)
  {
  float value;
  int i;
  time_t t;
  int random=0;

  srand((unsigned) time(&t));
  if (!set) return;
  if (upper > lower)
     random=1;
  for (i=0; i<set->Length; i++)
      {
      if (set->Members[i])
	 {
	 if (random)
	    value= myrandom (upper, lower);
	 else value=lower;
	 }
      PutUnitParam (set->Members[i], field, value);
      }
  }


void SetLinkParam (UnitPtr fromUnit, UnitPtr toUnit, int field, float upper, float lower)
  {
     int random=0;
     float value;
     time_t t;
     LinkPtr curlink;

     srand((unsigned) time(&t));
     if (upper > lower)
	random=1;
      curlink=toUnit->Links;
      while (curlink)
	{
	    if (fromUnit == curlink->From)
		{
		if (random)
		    value=myrandom (upper, lower);
		 else value=lower;
		PutLinkParam (curlink, field, value);
		}
	 curlink=curlink->Next;
	}
  }

void SetDoubleLinkParam (UnitPtr fromUnit, UnitPtr toUnit, int field,
			 float upper1, float lower1, float upper2, float lower2)
  {
     int random=0;
     float value;
     time_t t;
     LinkPtr curlink;

     srand((unsigned) time(&t));
     if (upper1 > lower1)
	random=1;
      curlink=toUnit->Links;
      while (curlink)
	{
	    if (fromUnit == curlink->From)
		{
		if (random)
		    value=myrandom (upper1, lower1);
		 else value=lower1;
		PutLinkParam (curlink, field, value);
		}
	 curlink=curlink->Next;
	}
     if (upper2 > lower2)
	random=1;
      curlink=fromUnit->Links;
      while (curlink)
	{
	    if (toUnit == curlink->From)
		{
		if (random)
		    value=myrandom (upper2, lower2);
		 else value=lower2;
		PutLinkParam (curlink, field, value);
		}
	 curlink=curlink->Next;
	}
  }

void SetLinksParam (SetPtr toset, int field, float upper, float lower)
  {
  int i;
  UnitPtr to;
  LinkPtr curlink;
  time_t t;
  int random=0;
  float value;

  srand((unsigned) time(&t));
  if (upper > lower)
     random=1;
  for (i=0; i<toset->Length; i++)
      {
      to=toset->Members[i];
      curlink=to->Links;
      while (curlink)
	{
	if (random)
	    value=myrandom (upper, lower);
	else value=lower;
	PutLinkParam (curlink, field, value);
	curlink=curlink->Next;
	}
      }
  }

void SetLinksParamSetToSet (SetPtr fromset, SetPtr toset, int field, float upper, float lower)
  {
  int i,j;
  UnitPtr to, from;
  LinkPtr curlink;
  int random=0;
  time_t t;
  float value;

  srand((unsigned) time(&t));
  if (upper > lower)
     random=1;
  for (i=0; i<toset->Length; i++)
      {
      to=toset->Members[i];
      curlink=to->Links;
      while (curlink)
	{
	for (j=0; j<fromset->Length; j++)
	    {
	    from=fromset->Members[j];
	    if (from == curlink->From)
	       {
		if (random)
		    value=myrandom (upper, lower);
		 else value=lower;
		 PutLinkParam (curlink, field, value);
		}
	    }
	 curlink=curlink->Next;
	}
      }
  }

void SetDoubleLinksParam (SetPtr fromset, SetPtr toset, int field, float upper, float lower)
  {
  int i,j;
  UnitPtr to, from;
  LinkPtr curlink;
  int random=0;
  time_t t;
  float value;

  srand((unsigned) time(&t));
  if (upper > lower)
     random=1;
  for (i=0; i<toset->Length; i++)
      {
      to=toset->Members[i];
      curlink=to->Links;
      while (curlink)
	{
	for (j=0; j<fromset->Length; j++)
	    {
	    from=fromset->Members[j];
	    if (from == curlink->From)
	       {
		if (random)
		    value=myrandom (upper, lower);
		 else value=lower;
		 PutLinkParam (curlink, field, value);
		}
	    }
	 curlink=curlink->Next;
	}
      }
  for (i=0; i<fromset->Length; i++)
      {
      from=fromset->Members[i];
      curlink=from->Links;
      while (curlink)
	{
	for (j=0; j< toset->Length; j++)
	    {
	    to=toset->Members[j];
	    if (to == curlink->From)
	       {
		if (random)
		    value=myrandom (upper, lower);
		 else value=lower;
		 PutLinkParam (curlink, field, value);
		}
	    }
	 curlink=curlink->Next;
	}
      }
  }

  /******* Getting the indices of units with maximal or **********/
  /******************  minimal values in a set *******************/


int MaxOutput (SetPtr setname)
   {
   int zz, grn;
   float gr;
   grn=0;
   gr=SetMember (setname, 0)->Output;
   for (zz=1; zz<setname->Length; zz++)
       if (gr < setname->Members[zz]->Output)
	  {
	  gr=setname->Members[zz]->Output;
	  grn=zz;
	  }
   return (grn);
   }


int MaxNetinput (SetPtr setname)
   {
   int zz, grn;
   float gr;
   grn=0;
   gr=SetMember (setname, 0)->Netinput;
   for (zz=1; zz<setname->Length; zz++)
       if (gr < setname->Members[zz]->Netinput)
	  {
	  gr=setname->Members[zz]->Netinput;
	  grn=zz;
	  }
   return (grn);
   }

int MinOutput (SetPtr setname)
   {
   int zz, grn;
   float gr;
   grn=0;
   gr=SetMember (setname, 0)->Output;
   for (zz=1; zz<setname->Length; zz++)
       if (gr > setname->Members[zz]->Output)
	  {
	  gr=setname->Members[zz]->Output;
	  grn=zz;
	  }
   return (grn);
   }


int MinNetinput (SetPtr setname)
   {
   int zz, grn;
   float gr;
   grn=0;
   gr=SetMember (setname, 0)->Netinput;
   for (zz=1; zz<setname->Length; zz++)
       if (gr > setname->Members[zz]->Netinput)
	  {
	  gr=setname->Members[zz]->Netinput;
	  grn=zz;
	  }
   return (grn);
   }



int MaxFree1 (SetPtr setname)
   {
   int zz, grn;
   float gr;
   grn=0;
   gr=SetMember (setname, 0)->Free1;
   for (zz=1; zz<setname->Length; zz++)
       if (gr < setname->Members[zz]->Free1)
	  {
	  gr=setname->Members[zz]->Free1;
	  grn=zz;
	  }
   return (grn);
   }

int MaxFree2 (SetPtr setname)
   {
   int zz, grn;
   float gr;
   grn=0;
   gr=SetMember (setname, 0)->Free2;
   for (zz=1; zz<setname->Length; zz++)
       if (gr < setname->Members[zz]->Free2)
	  {
	  gr=setname->Members[zz]->Free2;
	  grn=zz;
	  }
   return (grn);
   }

int MaxFree3 (SetPtr setname)
   {
   int zz, grn;
   float gr;
   grn=0;
   gr=SetMember (setname, 0)->Free3;
   for (zz=1; zz<setname->Length; zz++)
       if (gr < setname->Members[zz]->Free3)
	  {
	  gr=setname->Members[zz]->Free3;
	  grn=zz;
	  }
   return (grn);
   }


int MinFree1 (SetPtr setname)
   {
   int zz, grn;
   float gr;
   grn=0;
   gr=SetMember (setname, 0)->Free1;
   for (zz=1; zz<setname->Length; zz++)
       if (gr > setname->Members[zz]->Free1)
	  {
	  gr=setname->Members[zz]->Free1;
	  grn=zz;
	  }
   return (grn);
   }

int MinFree2 (SetPtr setname)
   {
   int zz, grn;
   float gr;
   grn=0;
   gr=SetMember (setname, 0)->Free2;
   for (zz=1; zz<setname->Length; zz++)
       if (gr > setname->Members[zz]->Free2)
	  {
	  gr=setname->Members[zz]->Free2;
	  grn=zz;
	  }
   return (grn);
   }

int MinFree3 (SetPtr setname)
   {
   int zz, grn;
   float gr;
   grn=0;
   gr=SetMember (setname, 0)->Free3;
   for (zz=1; zz<setname->Length; zz++)
       if (gr > setname->Members[zz]->Free3)
	  {
	  gr=setname->Members[zz]->Free3;
	  grn=zz;
	  }
   return (grn);
   }

int MaxValue (SetPtr setname, int param)
  {
  int result;
  result=0;
  switch (param)
    {
    case OUTPUT: result=MaxOutput (setname); break;
    case NETINPUT: result=MaxNetinput (setname); break;
    case FREE1: result=MaxFree1 (setname); break;
    case FREE2: result=MaxFree2 (setname); break;
    case FREE3: result=MaxFree3 (setname); break;
    }
  return (result);
  }

int MinValue (SetPtr setname, int param)
  {
  int result;
  result=0;
  switch (param)
    {
    case OUTPUT: result=MinOutput (setname); break;
    case NETINPUT: result=MinNetinput (setname); break;
    case FREE1: result=MinFree1 (setname); break;
    case FREE2: result=MinFree2 (setname); break;
    case FREE3: result=MinFree3 (setname); break;
    }
  return (result);
  }



	/*****************  Zeroing unit and link parameters *****************/


void ZeroOutput (UnitPtr unit)
  {
  unit->Output=0.0;
  }

void ZeroNetinput (UnitPtr unit)
  {
  unit->Netinput=0.0;
  }

void ZeroFree1 (UnitPtr unit)
  {
  unit->Free1=0.0;
  }

void ZeroFree2 (UnitPtr unit)
  {
  unit->Free2=0.0;
  }

void ZeroFree3 (UnitPtr unit)
  {
  unit->Free3=0.0;
  }


void ZeroWeight (LinkPtr link)
  {
  link->Weight=0.0;
  }

void ZeroLinkFree1 (LinkPtr link)
  {
  link->Free1=0.0;
  }

void ZeroLinkFree2 (LinkPtr link)
  {
  link->Free2=0.0;
  }

void ZeroLinkFree3 (LinkPtr link)
  {
  link->Free3=0.0;
  }


  /******* Allowing only the first N units with maximal feature value **********/
  /******************  to have that value, while *******************************/
  /*************** all other units have a value of zero ************************/

void SelectNUnitsWithMaxValue (SetPtr set, int feature, int N)
  {
  int i, *u;
  float *o;
  u=(int *)malloc (N*sizeof(int));
  o=(float *)malloc (N*sizeof(float));
  for (i=0; i<N; i++)
      {
       u[i]=MaxValue (set, feature);
       o[i]=GetUnitParam (SetMember (set, u[i]), feature);
       PutUnitParam (SetMember (set, u[i]), feature, -100000.0);
      }
  SetUnitsParam (set, feature, 0.0, 0.0);
  for (i=0; i<N; i++)
    PutUnitParam (SetMember (set, u[i]), feature, o[i]);
  }

/*******************************/

float WeightedSum (UnitPtr unit)
	{
	float sum;
	LinkPtr curlink;
	curlink=unit->Links;
	sum=0.0;
	while (curlink)
	  {
	   sum += curlink->Weight * curlink->From->Output;
	   curlink = curlink->Next;
	  }
	return (sum);
	}


