#include "net1.h"

float myrandom (float hi, float lo)
  {
  float r;
  r= (random ((int)(100000.0*(hi - lo) + 1)) + 100000.0*lo)/100000.0;
  return (r);
  }


float Toggle (float x, float probability)
  {
  float r ,ret;
  ret=x;
  r= (float)random (1000);
  if (r < 1000.0*probability)
     {
     if (x > 0.5)
	ret=0.0;
     else
     if (x < 0.5)
	ret=1.0;
     }
  return (ret);
  }

float FloatRandom (float hi,float lo)
  {
  float r;
  r= (random ((int)(1000.0*(hi - lo) + 1)) + 1000.0*lo)/1000.0;
  return (r);
  }

void CreateLink (float HigherLimit, float LowerLimit, UnitPtr to, UnitPtr from, float r)
  			{
			   LinkPtr p;
			   int i;
                           if ((!from) || (!to))
			      printf ("CreateLink: From or To is not a unit!\n");
			   p=(LinkPtr)malloc (sizeof (Link));
//			   p=(LinkPtr) GlobalLock (GlobalAlloc
//					(GMEM_MOVEABLE | GMEM_DISCARDABLE, sizeof(Link)));
			   if (p==0)
			      {
			      error=1;
			      printf ("CreateLink: NOT ENOUGH MEMORY TO CREATE LINK!\n");
			      goto getout;
			      }
			   nr_all_links++;
			   p->From=from;
			   p->To=to;
			   p->Free1=0.0;
			   p->Free2=0.0;
			   p->Free3=1.0;
			   if (HigherLimit>LowerLimit)
			      p->Weight=r;
			   else
			      p->Weight=HigherLimit;
			   p->Next=to->Links;
			   to->Links=p;
                           getout: i++; 
                          }

void ConnectSets (SetPtr FromSet,SetPtr ToSet, float HigherLimit, float LowerLimit)
		{
		int i,j;
		UnitPtr to, from;
		LinkPtr p;
		time_t t;

  		srand((unsigned) time(&t));
		for (i=0; i<ToSet->Length; i++)
		    {
		    to=ToSet->Members[i];
		    for (j=0; j<FromSet->Length; j++)
			{
			from=FromSet->Members[j];
			if (to != from)
			   CreateLink (HigherLimit, LowerLimit, to, from, myrandom(HigherLimit, LowerLimit));
			}
		    }
		}

void DoubleConnectSets (SetPtr FromSet, SetPtr ToSet, float HigherLimit1, float LowerLimit1,
			float HigherLimit2, float LowerLimit2)
		{
		int i,j;
		UnitPtr to, from;
		LinkPtr p;
		time_t t;

//  		srand((unsigned) time(&t));
		for (i=0; i<ToSet->Length; i++)
		    {
		    to=ToSet->Members[i];
		    for (j=0; j<FromSet->Length; j++)
			{
			from=FromSet->Members[j];
			if (to != from)
                           {
			   CreateLink (HigherLimit1, LowerLimit1, to, from,
			   	myrandom(HigherLimit1, LowerLimit1));
			   CreateLink (HigherLimit2, LowerLimit2, from, to,
				myrandom(HigherLimit2, LowerLimit2));
			   }
			}
		    }
		}

void ConnectSetsRandomly (SetPtr FromSet,SetPtr ToSet, float probability, float HigherLimit, float LowerLimit)
		{
		int i,j;
                float r;
		UnitPtr to, from;
		LinkPtr p;
		time_t t;

  		srand((unsigned) time(&t));
		for (i=0; i<FromSet->Length; i++)
		    {
		    from=FromSet->Members[i];
		    for (j=0; j<ToSet->Length; j++)
			{
  			r= (float)random (1000);
			if (r < 1000.0*probability)
                        {
			to=ToSet->Members[j];
			if (to != from)
			   CreateLink (HigherLimit, LowerLimit, to, from, myrandom(HigherLimit, LowerLimit));
			}
			}
		    }
		}

void ConnectPercentageOfSetToSet (SetPtr FromSet,SetPtr ToSet, float percentage, float HigherLimit, float LowerLimit)
		{
		int i,j;
                float r;
		UnitPtr to, from;
		LinkPtr p;
		time_t t;

  		srand((unsigned) time(&t));

		for (i=0; i<ToSet->Length; i++)
		    {
		    to=ToSet->Members[i];
		    for (j=0; j<FromSet->Length; j++)
			{
  			r= (float)random (1000);
			if (r < 1000.0*percentage)
                        {
			from=FromSet->Members[j];
			if (to != from)
			   CreateLink (HigherLimit, LowerLimit, to, from, myrandom(HigherLimit, LowerLimit));
			}
			}
		    }
		}

void ConnectUnitToSet (UnitPtr unit, SetPtr ToSet, float HigherLimit,float LowerLimit)
		{
		int i;
		UnitPtr to, from;
		LinkPtr p;
		time_t t;

  		srand((unsigned) time(&t));

		from=unit;
		for (i=0; i<ToSet->Length; i++)
		    {
		    to=ToSet->Members[i];
			if (to != from)
			   CreateLink (HigherLimit, LowerLimit, to, from, myrandom(HigherLimit, LowerLimit));
			}
		}

void ConnectSetToUnit (SetPtr FromSet, UnitPtr unit, float HigherLimit, float LowerLimit)
		{
		int j;
		UnitPtr to, from;
		LinkPtr p;
		time_t t;

  		srand((unsigned) time(&t));

		    to=unit;
		    for (j=0; j<FromSet->Length; j++)
			{
			from=FromSet->Members[j];
			if (to != from)
			   CreateLink (HigherLimit, LowerLimit, to, from, myrandom(HigherLimit, LowerLimit));
			}
		}



void ConnectUnits (UnitPtr from, UnitPtr to, float HigherLimit, float LowerLimit)
		{
		LinkPtr p;
		time_t t;

  		srand((unsigned) time(&t));
		CreateLink (HigherLimit, LowerLimit, to, from, myrandom(HigherLimit, LowerLimit));
		}

void ConnectUnitsToUnits (SetPtr FromSet, int LowerIndex1, int HigherIndex1,
			SetPtr ToSet, int LowerIndex2, int HigherIndex2,
			float HigherLimit, float LowerLimit)
		{
		int j, i;
		for (j=LowerIndex2; j<=HigherIndex2; j++)
		   for (i=LowerIndex1; i<=HigherIndex1; i++)
		       {
		       if ((i<FromSet->Length) && (j<ToSet->Length))
			  ConnectUnits (FromSet->Members [i],
					ToSet->Members [j], HigherLimit,
							     LowerLimit);
		       }
		}

void DoubleConnectUnits (UnitPtr first, UnitPtr sec,
			float HigherLimit1, float LowerLimit1, float HigherLimit2,
			float LowerLimit2)
		{
		LinkPtr p;
		time_t t;

  		srand((unsigned) time(&t));
		CreateLink (HigherLimit1, LowerLimit1, sec, first, myrandom(HigherLimit1, LowerLimit1));
		CreateLink (HigherLimit2, LowerLimit2, first, sec, myrandom(HigherLimit2, LowerLimit2));
		}


void ConnectSetsOneByOne (SetPtr Fromset, SetPtr Toset, float upper, float lower)
   {
   int zz;
   for (zz=0; zz<Fromset->Length; zz++)
       ConnectUnits (Fromset->Members[zz], Toset->Members[zz], upper, lower);
   }


SetPtr MakeSet (char *name, int NrRows, int NrColumns)
		{
		int i, SetSize;
		SetPtr CurrentSet;
		UnitPtr p;
		CurrentSet=(SetPtr)malloc(sizeof(Set));
		CurrentSet->Name=name;
		CurrentSet->SquareSize=Squaresize;
		CurrentSet->Type=0;
		CurrentSet->Length=SetSize=NrRows*NrColumns;
		CurrentSet->ScreenMtrx[0]=NrColumns;
		CurrentSet->ScreenMtrx[1]=NrRows;
		CurrentSet->ScreenMtrx[2]=0;
		CurrentSet->ScreenMtrx[3]=0;
		CurrentSet->SetHD=NULL;
		CurrentSet->Rows=NrRows;
		CurrentSet->Columns=NrColumns;
		CurrentSet->Members=
			(UnitPtr*)malloc(sizeof(UnitPtr)*(SetSize+1));
//		CurrentSet->Members=
//			(UnitPtr*)GlobalLock (GlobalAlloc
//					      (GMEM_MOVEABLE | GMEM_DISCARDABLE,
//					       sizeof(UnitPtr)*(SetSize+1)));
		for (i=0;i<SetSize; i++)
		      {
//			p=(UnitPtr) GlobalLock (GlobalAlloc
//					(GMEM_MOVEABLE | GMEM_DISCARDABLE, sizeof (Unit)));
			p=(UnitPtr) malloc (sizeof (Unit));

			if (p==0)
			   {
			   unit_error=2;
			   goto getout;
			   }
			nr_all_units++;
			p->Output=0.0;
			p->Netinput=0.0;
			p->Free1=0.0;
			p->Free2=0.0;
			p->Free3=0.0;
			p->Links=NULL;
			p->Set=CurrentSet;
			p->Index=i;
			p->Name="";
			CurrentSet->Members[i]=p;
			p->Column= i%NrColumns;
			p->Row= (i-p->Column)/NrColumns;
		      }
		SetArray [currentset]=CurrentSet;
                CurrentSet->Index=currentset;
		currentset++;
		getout:
		return (CurrentSet);
		}

char *getword (char *str, int nr)
   {
   int i, j, wd_counter;
   char word[50];
   i=0;
   wd_counter=0;            
   for (;str [i]!='\0'; i++)
       if (str [i]!='\ ')
	  {
	  wd_counter++;
	  if (wd_counter >= nr) break;
	  for (i=i+1;str [i]!='\0'; i++)
	      {
	      if (str [i]=='\ ')
	          break;
	      }
	  }
   j=0;
   while (str [i]!='\0')
	 if (str [i]!='\ ') 
	    { 
	     word [j]=str[i];
	     i++; j++;
	     }
	  else break;
   word [j]='\0';
   if (word [0]=='\0')
      {
       return (NULL);
      }
    else
   return (word);
   }


void SetUnitName (UnitPtr unit, char *name)
  {
   int j, l;
   l=strlen (name)+1;
   unit->Name=(char*)malloc(sizeof(char)*l);
   for (j=0;j<l;j++)
      unit->Name[j]=name[j];
   }


SetPtr MakeNamedSet (char *name, char *names, int NrRows, int NrColumns)
		{
		int i, j, l, SetSize;
		SetPtr CurrentSet;
		char *s;
		UnitPtr p;
		CurrentSet=(SetPtr)malloc(sizeof(Set));
		CurrentSet->Name=name;
		CurrentSet->SquareSize=Squaresize;
		CurrentSet->Type=0;
		CurrentSet->Length=SetSize=NrRows*NrColumns;
		CurrentSet->ScreenMtrx[0]=NrColumns;
		CurrentSet->ScreenMtrx[1]=NrRows;
		CurrentSet->ScreenMtrx[2]=0;
		CurrentSet->ScreenMtrx[3]=0;
		CurrentSet->SetHD=NULL;
		CurrentSet->Rows=NrRows;
		CurrentSet->Columns=NrColumns;
		CurrentSet->Members=
			(UnitPtr*)malloc(sizeof(UnitPtr)*(SetSize+1));
		for (i=0;i<SetSize; i++)
		      {
			p=(UnitPtr) malloc (sizeof (Unit));
			if (p==0)
			   {
			   unit_error=2;
			   goto getout;
			   }
			nr_all_units++;
			p->Output=0.0;
			p->Netinput=0.0;
			p->Free1=0.0;
			p->Free2=0.0;
			p->Free3=0.0;
			p->Links=NULL;
			p->Set=CurrentSet;
			p->Index=i;
			l=strlen (getword (names, i+1))+1;
			p->Name=
			  (char*)malloc(sizeof(char)*(l));
			for (j=0;j<l;j++)
			   p->Name[j]=getword(names, i+1)[j];
			CurrentSet->Members[i]=p;
			p->Column= i%NrColumns;
			p->Row= (i-p->Column)/NrColumns;
		      }
		SetArray [currentset]=CurrentSet;
                CurrentSet->Index=currentset;
		currentset++;
		getout:
		return (CurrentSet);
		}

/*******************  Accessing sets' and matrices' parameters *****************/


UnitPtr SetMember (SetPtr set, int indx)
  {
     if (set && indx < set->Length && indx >=0)
	return (set->Members[indx]);
     else
	{
	return (NULL);
	}
  }

UnitPtr SetMemberByName (SetPtr set, char *name)
  {
     int i;
     for (i=0;i<set->Length;i++)
	if (!strcmp(name,set->Members[i]->Name))
	   return (set->Members[i]);
     return (NULL);
  }

UnitPtr MatrixMember (SetPtr matrix, int row, int col)
  {
  register int index;
  index=matrix->Columns*row + col;
  if (matrix && index < matrix->Length && index >=0)
     return (matrix->Members[index]);
  else
    {
    return (NULL);
    }
  }


int SetLength(SetPtr set)
  {
     return (set->Length);
  }



	/******************* 'Getting' a link *****************/

LinkPtr GetLink (UnitPtr Fromunit, UnitPtr Tounit)
  {
  LinkPtr curlink,p;
  curlink=Tounit->Links;
  while (curlink)
    {
    if (curlink->From==Fromunit)
       {
       p=curlink;
       break;
       }
    else curlink=curlink->Next;
    }
  return (p);
  }


  


		/***************  Traverse and Process  ****************/

void TraverseSet (SetPtr set, void (*proc)(UnitPtr))
	{
	int i, setlength;
	UnitPtr unit;

	if (!set)
	   {
	   return;
	   }
	setlength=set->Length;
	for (i=0; i<setlength; i++)
	    {
	    unit=set->Members[i];
	    (*proc)(unit);
	    }
	}

void TraverseSetLinks (SetPtr set, void (*proc)(LinkPtr))
  {
  int i, setlength;
  UnitPtr unit;
  LinkPtr curlink;

  setlength=set->Length;
  if (!set)
     {
     return;
     }
  for (i=0; i<setlength; i++)
      {
      unit=set->Members[i];
      if (unit)
	 {
	 curlink=unit->Links;
	 while (curlink)
	     {
	     (*proc)(curlink);
	     curlink=curlink->Next;
	     }
	 }
      }
  }

void TraverseSetToSetLinks (SetPtr fromset, SetPtr toset, void (*proc)(LinkPtr))
  {
  int i,tosetlength;
  UnitPtr unit;
  LinkPtr curlink;

  tosetlength=toset->Length;
  if ((!fromset)||(!toset))
     {
     return;
     }
  for (i=0; i<tosetlength; i++)
      {
      unit=toset->Members[i];
      if (unit)
	 {
	 curlink=unit->Links;
	 while (curlink)
	     {
	     if (curlink->From->Set==fromset)
		(*proc)(curlink);
	     curlink=curlink->Next;
	     }
	 }
      }
  }

void TraverseUnitLinks (UnitPtr unit, void (*proc)(LinkPtr))
  {
      LinkPtr curlink;
      if (unit)
	 {
	 curlink=unit->Links;
	 while (curlink)
	     {
	     (*proc)(curlink);
	     curlink=curlink->Next;
	     }
	 }
      }

void TraverseUnitLinksToSet (UnitPtr unit, SetPtr set, void (*proc)(LinkPtr))
  {
  int i;
  UnitPtr tounit;
  LinkPtr curlink;
  if (!set) return;
  for (i=0; i<set->Length; i++)
      {
      tounit=set->Members[i];
      if (tounit)
	 {
	 curlink=tounit->Links;
	 while (curlink)
	     {
	     if (curlink->From == unit)
		(*proc)(curlink);
	     curlink=curlink->Next;
	     }
	 }
      }
  }


void ProcessUnit (UnitPtr unit, void (*proc)(UnitPtr))
	{
	(*proc)(unit);
	}

void ProcessLink (LinkPtr link, void (*proc)(LinkPtr))
	{
	(*proc)(link);
	}


void InstallParameter (char *str, float *par)
   {
   up[up_index]= par;
   up_installed [up_index]=1;
   up_names[up_index]=str;
   
   up_index++;
   }


void InstallCommand (char *name, void (*command)())
   {
   uc_names [uc_index] = name;
   uc [uc_index] = command;
   uc_index++;
   }



