#include "net.h"


//   	Interactive Activation Network for 4 letter words  
// 	This is a network - without learning - for the recognition of 150 4-letter words
//      The words are stored in the file iac_4.d that has to be in the same directory as
//	this file.
//	Based on: McClelland, J.L. and Runelhart, D.: An interactive activation model of
//	context effects in letter perception, Part1, Psychological Review, 88, 375-407, 1981.





#define NoOutputs       	150
#define NoLetters_per_position	26
#define NoFeatures_per_position	14



float act_rate=1.0, 
      decay_rate=0.0, 
      act_rate_inh=0.008, 
      noise_SD=0.00,
      bias_multiplier=1.0,
      exc_feature_letter=0.008,
      inh_feature_letter=-0.15,
      letter_letter=-0.00,
      inh_letter_word=-0.04,
      inh_word_letter=-0.0,
      exc_letter_word=0.07,
      exc_word_letter=0.30,
      latexc=5.0, latinh=-2.0,
      fgain_tmp=0.05; 

int index1,index2,index3;
char alphabet[]="ABCDEFGHIJKLMNOPQRSTUVWXYZ";


// The definition of the letters based on 14 features:

/*         0  1  2  3  4  5  6  7  8  9  10 11 12 13  */
int A[14]={1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1};
int B[14]={0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0};
int C[14]={1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
int D[14]={0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0};
int E[14]={1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1};
int F[14]={1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1};
int G[14]={1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0};
int H[14]={1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1};

/*         0  1  2  3  4  5  6  7  8  9  10 11 12 13  */
int I[14]={0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0};
int J[14]={0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
int K[14]={1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1};
int L[14]={1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
int M[14]={1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0};
int N[14]={1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0};
int O[14]={1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
int P[14]={1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1};

/*         0  1  2  3  4  5  6  7  8  9  10 11 12 13  */
int Q[14]={1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0};
int R[14]={1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1};
int S[14]={1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1};
int T[14]={1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0};
int U[14]={1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
int V[14]={1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0};
int W[14]={1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0};
int X[14]={0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0};
int Y[14]={0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0};
int Z[14]={0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0};


int Letters[26][14]=
{
{1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1},
{0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0},
{1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0},
{0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0},
{1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1},
{1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1},
{1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0},
{1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1},

{0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0},
{0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1},
{1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0},
{1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0},
{1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1},

{1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0},
{1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1},
{1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1},
{1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0},
{1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0},
{1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0},
{1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0},
{0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0},
{0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0},
{0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0}
};


/* A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
   0 1 2 3 4 5 6 7 8 9 10111213141516171819202122232425   */


			/**** Set definitions ****/


SetPtr 
	PFeatureSet_Pos1, PFeatureSet_Pos2, PFeatureSet_Pos3, PFeatureSet_Pos4, 	
	AFeatureSet_Pos1, AFeatureSet_Pos2, AFeatureSet_Pos3, AFeatureSet_Pos4, 	
	LetterSet_Pos1, LetterSet_Pos2, LetterSet_Pos3, LetterSet_Pos4, 
	OutputSet, InhibitorSet;


                    /******  Update functions *******/


float GaussianNoise ()
   {
   int i=0;
   float sum=0.0, R=0.0, X=0.0;
   while (i<12)
      {
      R=myrandom (1.0, 0.0);
      sum += R;
      i++;
      }
    X=noise_SD*(sum-6.0);
    return (X);
    }

void CollectActivation (UnitPtr unit)
  {
   unit->Netinput=WeightedSum(unit);
  }

void UpdateActivation (UnitPtr unit)
  {
   float netinput, output;
   netinput=unit->Netinput + bias_multiplier*unit->Free1 + GaussianNoise();
   if (netinput > 0.0)
      output	=	unit->Output + act_rate*(1.0 - unit->Output)*netinput 
                      	- decay_rate*unit->Output;
   else
   if (netinput <= 0.0)
      output	=	unit->Output + act_rate*unit->Output*netinput
			- decay_rate*unit->Output;

   if (output > 1.0)
      unit->Output=1.0;
   else   
   if (output < 0.0)
      unit->Output=0.0;
   else
      unit->Output=output;
  }

void UpdateActivationInh (UnitPtr unit)
  {
   float netinput;
   netinput=unit->Netinput;
   unit->Output = act_rate_inh*netinput;
  }



		   /******  Auxiliary functions *****/


void ConnectFeaturesToLetter1(int l)
  {
  int i;
  UnitPtr Letter;
  Letter=SetMember (LetterSet_Pos1, l);

  for (i=0; i<14; i++)
      if (Letters[l][i] == 1)
         {
         ConnectUnits (SetMember (PFeatureSet_Pos1, i), Letter, 	
			exc_feature_letter, exc_feature_letter);
         ConnectUnits (SetMember (AFeatureSet_Pos1, i), Letter,
 			inh_feature_letter,inh_feature_letter);
         }
      else
      if (Letters[l][i] == 0)
         {
         ConnectUnits (SetMember (AFeatureSet_Pos1, i), Letter, 	
			exc_feature_letter,exc_feature_letter);
         ConnectUnits (SetMember (PFeatureSet_Pos1, i), Letter,
 			inh_feature_letter,inh_feature_letter);
         }
 }

void ConnectFeaturesToLetter2(int l)
  {
  int i;
  UnitPtr Letter;
  Letter=SetMember (LetterSet_Pos2, l);

  for (i=0; i<14; i++)
      if (Letters[l][i] == 1)
         {
         ConnectUnits (SetMember (PFeatureSet_Pos2, i), Letter, 	
			exc_feature_letter,exc_feature_letter);
         ConnectUnits (SetMember (AFeatureSet_Pos2, i), Letter,
 			inh_feature_letter,inh_feature_letter);
         }
      else
      if (Letters[l][i] == 0)
         {
         ConnectUnits (SetMember (AFeatureSet_Pos2, i), Letter, 	
			exc_feature_letter,exc_feature_letter);
         ConnectUnits (SetMember (PFeatureSet_Pos2, i), Letter,
 			inh_feature_letter,inh_feature_letter);
         }
 }


void ConnectFeaturesToLetter3(int l)
  {
  int i;
  UnitPtr Letter;
  Letter=SetMember (LetterSet_Pos3, l);

  for (i=0; i<14; i++)
      if (Letters[l][i] == 1)
         {
         ConnectUnits (SetMember (PFeatureSet_Pos3, i), Letter, 	
			exc_feature_letter,exc_feature_letter);
         ConnectUnits (SetMember (AFeatureSet_Pos3, i), Letter,
 			inh_feature_letter,inh_feature_letter);
         }
      else
      if (Letters[l][i] == 0)
         {
         ConnectUnits (SetMember (AFeatureSet_Pos3, i), Letter, 	
			exc_feature_letter,exc_feature_letter);
         ConnectUnits (SetMember (PFeatureSet_Pos3, i), Letter,
 			inh_feature_letter,inh_feature_letter);
         }
 }

void ConnectFeaturesToLetter4(int l)
  {
  int i;
  UnitPtr Letter;
  Letter=SetMember (LetterSet_Pos4, l);

  for (i=0; i<14; i++)
      if (Letters[l][i] == 1)
         {
         ConnectUnits (SetMember (PFeatureSet_Pos4, i), Letter, 	
			exc_feature_letter,exc_feature_letter);
         ConnectUnits (SetMember (AFeatureSet_Pos4, i), Letter,
 			inh_feature_letter,inh_feature_letter);
         }
      else
      if (Letters[l][i] == 0)
         {
         ConnectUnits (SetMember (AFeatureSet_Pos4, i), Letter, 	
			exc_feature_letter,exc_feature_letter);
         ConnectUnits (SetMember (PFeatureSet_Pos4, i), Letter,
 			inh_feature_letter,inh_feature_letter);
         }
 }


void ConnectFeaturesToLetters()
  {
  int i;
  for (i=0; i<26; i++)
      ConnectFeaturesToLetter1(i);
  for (i=0; i<26; i++)
      ConnectFeaturesToLetter2(i);
  for (i=0; i<26; i++)
      ConnectFeaturesToLetter3(i);
  for (i=0; i<26; i++)
      ConnectFeaturesToLetter4(i);
  }


void NameLetters()
  {
  int i;
  for (i=0; i<NoLetters_per_position; i++)
      {
       SetMember (LetterSet_Pos1, i)->Name=(char*)malloc(sizeof(char)*2);
       SetMember (LetterSet_Pos1, i)->Name[0]=alphabet[i];
       SetMember (LetterSet_Pos1, i)->Name[1]='\0';
       }
  for (i=0; i<NoLetters_per_position; i++)
      {
       SetMember (LetterSet_Pos2, i)->Name=(char*)malloc(sizeof(char)*2);
       SetMember (LetterSet_Pos2, i)->Name[0]=alphabet[i];
       SetMember (LetterSet_Pos2, i)->Name[1]='\0';
       }
  for (i=0; i<NoLetters_per_position; i++)
      {
       SetMember (LetterSet_Pos3, i)->Name=(char*)malloc(sizeof(char)*2);
       SetMember (LetterSet_Pos3, i)->Name[0]=alphabet[i];
       SetMember (LetterSet_Pos3, i)->Name[1]='\0';
       }
  for (i=0; i<NoLetters_per_position; i++)
      {
       SetMember (LetterSet_Pos4, i)->Name=(char*)malloc(sizeof(char)*2);
       SetMember (LetterSet_Pos4, i)->Name[0]=alphabet[i];
       SetMember (LetterSet_Pos4, i)->Name[1]='\0';
       }
  }


int ScanAlphabet (char c)
  {
   int i;
   for (i=0; i<NoLetters_per_position; i++)
        if (c==alphabet[i])
	    return (i);
   return 0;
   }


void ConnectLettersToWord (int j, char *w)
  {
   UnitPtr word_unit, 
           letter_unit1, letter_unit2, letter_unit3, 
	   letter_unit4;

   word_unit=SetMember (OutputSet, j);
 
   letter_unit1=SetMember (LetterSet_Pos1, ScanAlphabet (w[0]));
   letter_unit2=SetMember (LetterSet_Pos2, ScanAlphabet (w[1]));
   letter_unit3=SetMember (LetterSet_Pos3, ScanAlphabet (w[2]));
   letter_unit4=SetMember (LetterSet_Pos4, ScanAlphabet (w[3]));
   

   SetLinkParam (letter_unit1, word_unit, WEIGHT, exc_letter_word, 		
	exc_letter_word);
   SetLinkParam (letter_unit2, word_unit, WEIGHT, exc_letter_word, 
	exc_letter_word);
   SetLinkParam (letter_unit3, word_unit, WEIGHT, exc_letter_word, 
	exc_letter_word);
   SetLinkParam (letter_unit4, word_unit, WEIGHT, exc_letter_word, 
	exc_letter_word);

   SetLinkParam (word_unit, letter_unit1, WEIGHT, exc_word_letter, 
	exc_word_letter);
   SetLinkParam (word_unit, letter_unit2, WEIGHT, exc_word_letter, 
	exc_word_letter);
   SetLinkParam (word_unit, letter_unit3, WEIGHT, exc_word_letter, 
	exc_word_letter);
   SetLinkParam (word_unit, letter_unit4, WEIGHT, exc_word_letter, 
	exc_word_letter);
   }
    


void SetWeightsLettersToWords()
  {
  int i,j,k,h;
  char wd[15];
  float F;
  FILE *in;

  in = fopen ("iac_4.d", "r");
  h=0;
  for (j=1, k=0; j<=2*NoOutputs; j++)
       {
	fscanf (in, "%s", wd);
	if (j%2)
           {
	    ConnectLettersToWord (h, wd);
	    SetUnitName (SetMember(OutputSet, h), wd);
	    h++;
           }
        else
	if (!(j%2))
           {
            F=atof(wd);
	    SetMember (OutputSet, k)->Free1= ((log10(F)-4.0251)/4.0251)*fgain_tmp;
            k++;
	   }
      }
  fclose (in);
  }



void InputLetter1 (int k)
  {
   int i;
   for (i=0; i<14; i++)
     if (Letters[k][i]==1)
        SetMember (PFeatureSet_Pos1, i)->Output=1.0;
     else
     if (Letters[k][i]==0)
        SetMember (AFeatureSet_Pos1, i)->Output=1.0;
  }    

void InputLetter2 (int k)
  {
   int i;
   for (i=0; i<14; i++)
     if (Letters[k][i]==1)
        SetMember (PFeatureSet_Pos2, i)->Output=1.0;
     else
     if (Letters[k][i]==0)
        SetMember (AFeatureSet_Pos2, i)->Output=1.0;
  }    

void InputLetter3 (int k)
  {
   int i;
   for (i=0; i<14; i++)
     if (Letters[k][i]==1)
        SetMember (PFeatureSet_Pos3, i)->Output=1.0;
     else
     if (Letters[k][i]==0)
        SetMember (AFeatureSet_Pos3, i)->Output=1.0;
  }    

void InputLetter4 (int k)
  {
   int i;
   for (i=0; i<14; i++)
     if (Letters[k][i]==1)
        SetMember (PFeatureSet_Pos4, i)->Output=1.0;
     else
     if (Letters[k][i]==0)
        SetMember (AFeatureSet_Pos4, i)->Output=1.0;
  }    



void lweight(LinkPtr link)
  {
   if (link->From->Set==link->To->Set)
      link->Weight=letter_letter;
   else
   if ((link->From->Set==OutputSet) && (link->Weight > 0.0))
      link->Weight=exc_word_letter;
   else
   if ((link->From->Set==OutputSet) && (link->Weight < 0.0))
      link->Weight=inh_word_letter;
   else
   if (link->Weight > 0.0)
      link->Weight=exc_feature_letter;
   else
   if (link->Weight < 0.0)
      link->Weight=inh_feature_letter;
   }

void oweight(LinkPtr link)
  {
   if (link->From->Set==InhibitorSet)
      link->Weight=latinh;
   else
   if (link->Weight > 0.0)
      link->Weight=exc_letter_word;
   else
   if (link->Weight < 0.0)
      link->Weight=inh_letter_word;
   }


void SetWeightsInLetterSets()
  {
   TraverseSetLinks (LetterSet_Pos1, lweight);
   TraverseSetLinks (LetterSet_Pos2, lweight);
   TraverseSetLinks (LetterSet_Pos3, lweight);
   TraverseSetLinks (LetterSet_Pos4, lweight);
   }

void SetWeightsInOutputSet()
  {
   TraverseSetLinks (OutputSet, oweight);
   }


void reset ()
   {
   TraverseSet (PFeatureSet_Pos1, ZeroOutput);
   TraverseSet (PFeatureSet_Pos2, ZeroOutput);
   TraverseSet (PFeatureSet_Pos3, ZeroOutput);
   TraverseSet (PFeatureSet_Pos4, ZeroOutput);

   TraverseSet (AFeatureSet_Pos1, ZeroOutput);
   TraverseSet (AFeatureSet_Pos2, ZeroOutput);
   TraverseSet (AFeatureSet_Pos3, ZeroOutput);
   TraverseSet (AFeatureSet_Pos4, ZeroOutput);

   TraverseSet (LetterSet_Pos1, ZeroOutput);
   TraverseSet (LetterSet_Pos2, ZeroOutput);
   TraverseSet (LetterSet_Pos3, ZeroOutput);
   TraverseSet (LetterSet_Pos4, ZeroOutput);

   TraverseSet (LetterSet_Pos1, ZeroNetinput);
   TraverseSet (LetterSet_Pos2, ZeroNetinput);
   TraverseSet (LetterSet_Pos3, ZeroNetinput);
   TraverseSet (LetterSet_Pos4, ZeroNetinput);

   TraverseSet (OutputSet, ZeroOutput);
   TraverseSet (OutputSet, ZeroNetinput);

   TraverseSet (InhibitorSet, ZeroOutput);
   TraverseSet (InhibitorSet, ZeroNetinput);
   SetWeightsInLetterSets();
   SetWeightsInOutputSet();
  }

void input_word ()
  {
   int index0, index1, index2, index3, index4;
   
   reset();

   index0=ScanAlphabet (toupper(Parameter(1)[0]));
   index1=ScanAlphabet (toupper(Parameter(1)[1]));
   index2=ScanAlphabet (toupper(Parameter(1)[2]));
   index3=ScanAlphabet (toupper(Parameter(1)[3]));

   if (index0 < 26)
      InputLetter1(index0);
   if (index1 < 26)
      InputLetter2(index1);
   if (index2 < 26)
      InputLetter3(index2);
   if (index3 < 26)
      InputLetter4(index3);
   }

//SetFree1 sets the Free1 parameter of the word units using the bias
//values in iac_4.d.

void SetFree1()
  {
  int j,k;
  char wd[15];
  float F;
  FILE *in;

  in = fopen ("iac_4.d", "r");
  for (j=1, k=0; j<=2*NoOutputs; j++)
       { 
	fscanf (in, "%s", wd);
        if (!(j%2))  
           {
            F=atof(wd);
	    SetMember (OutputSet, k)->Free1= ((log10(F)-4.0251)/4.0251)*fgain_tmp;
            k++;
           } 
      }
  fclose (in);
  }

void cover()
  {
  int feature, position;
  position=atoi(Parameter(1));
  feature=atoi(Parameter(2));
  switch (position)
   {
    case 1:
	ZeroOutput (SetMember (PFeatureSet_Pos1, feature));
	ZeroOutput (SetMember (AFeatureSet_Pos1, feature));
        break;
    case 2:
	ZeroOutput (SetMember (PFeatureSet_Pos2, feature));
	ZeroOutput (SetMember (AFeatureSet_Pos2, feature));
        break;
    case 3:
	ZeroOutput (SetMember (PFeatureSet_Pos3, feature));
	ZeroOutput (SetMember (AFeatureSet_Pos3, feature));
        break;
    case 4:
	ZeroOutput (SetMember (PFeatureSet_Pos4, feature));
	ZeroOutput (SetMember (AFeatureSet_Pos4, feature));
	break;
    }
  }

	       /*******  Build & Run  *******/

void Build ()
	{
	Cycles=0;
	Squaresize=15;

	PFeatureSet_Pos1=MakeSet ("PFeatureSet_Pos1", 1, NoFeatures_per_position);
	PFeatureSet_Pos2=MakeSet ("PFeatureSet_Pos2", 1, NoFeatures_per_position);
	PFeatureSet_Pos3=MakeSet ("PFeatureSet_Pos3", 1, NoFeatures_per_position);
	PFeatureSet_Pos4=MakeSet ("PFeatureSet_Pos4", 1, NoFeatures_per_position);

	AFeatureSet_Pos1=MakeSet ("AFeatureSet_Pos1", 1, NoFeatures_per_position);
	AFeatureSet_Pos2=MakeSet ("AFeatureSet_Pos2", 1, NoFeatures_per_position);
	AFeatureSet_Pos3=MakeSet ("AFeatureSet_Pos3", 1, NoFeatures_per_position);
	AFeatureSet_Pos4=MakeSet ("AFeatureSet_Pos4", 1, NoFeatures_per_position);

	LetterSet_Pos1=MakeSet ("LetterSet_Pos1", 1, NoLetters_per_position);
	LetterSet_Pos2=MakeSet ("LetterSet_Pos2", 1, NoLetters_per_position);
	LetterSet_Pos3=MakeSet ("LetterSet_Pos3", 1, NoLetters_per_position);
	LetterSet_Pos4=MakeSet ("LetterSet_Pos4", 1, NoLetters_per_position);

	OutputSet=MakeSet ("OutputSet", NoOutputs/30, 30);
	InhibitorSet=MakeSet ("Inhibitor", 1,1);

        ConnectFeaturesToLetters();
        ConnectSets 
             (LetterSet_Pos1, LetterSet_Pos1, letter_letter, letter_letter);
        ConnectSets 
             (LetterSet_Pos2, LetterSet_Pos2, letter_letter, letter_letter);
        ConnectSets 
             (LetterSet_Pos3, LetterSet_Pos3, letter_letter, letter_letter);
        ConnectSets 
             (LetterSet_Pos4, LetterSet_Pos4, letter_letter, letter_letter);

        DoubleConnectSets (LetterSet_Pos1, OutputSet,
                           inh_letter_word, inh_letter_word,
                           inh_word_letter, inh_word_letter);
        DoubleConnectSets (LetterSet_Pos2, OutputSet,
                           inh_letter_word, inh_letter_word,
                           inh_word_letter, inh_word_letter);
        DoubleConnectSets (LetterSet_Pos3, OutputSet,
                           inh_letter_word, inh_letter_word,
                           inh_word_letter, inh_word_letter);
        DoubleConnectSets (LetterSet_Pos4, OutputSet,
                           inh_letter_word, inh_letter_word,
                           inh_word_letter, inh_word_letter);
        SetWeightsLettersToWords();
        ConnectSets (OutputSet, InhibitorSet, latexc, latexc);
        ConnectSets (InhibitorSet, OutputSet, latinh, latinh);

        NameLetters();
            
        InstallParameter ("SD/noise", &noise_SD);    // the Standard Deviation for Gaussian noise
	InstallParameter ("Act. rate", &act_rate);
        InstallParameter ("Decay rate", &decay_rate);
	InstallParameter ("Act. rate(I)", &act_rate_inh);
        InstallParameter ("I.unit/wrds", &latinh);
        InstallParameter ("I.lttrs/wrds", &inh_letter_word);
        InstallParameter ("E.lttrs/wrds", &exc_letter_word);
        InstallParameter ("I.wrds/ltters", &inh_word_letter);
        InstallParameter ("E.wrds/ltters", &exc_word_letter);
        InstallParameter ("I.lttrs/lttrs", &letter_letter);
        InstallParameter ("I.ftrs/lttrs", &inh_feature_letter);
        InstallParameter ("E.ftrs/lttrs", &exc_feature_letter);

	InstallCommand ("input", input_word);
	InstallCommand ("reset", reset);
	InstallCommand ("setFree1", SetFree1);
	InstallCommand ("cover", cover);
	}



void Run()
  {
   TraverseSet (LetterSet_Pos1, CollectActivation);
   TraverseSet (LetterSet_Pos2, CollectActivation);
   TraverseSet (LetterSet_Pos3, CollectActivation);
   TraverseSet (LetterSet_Pos4, CollectActivation);
   TraverseSet (OutputSet, CollectActivation);
   TraverseSet (InhibitorSet, CollectActivation);

   TraverseSet (LetterSet_Pos1, UpdateActivation);
   TraverseSet (LetterSet_Pos2, UpdateActivation);
   TraverseSet (LetterSet_Pos3, UpdateActivation);
   TraverseSet (LetterSet_Pos4, UpdateActivation);
   TraverseSet (OutputSet, UpdateActivation);
   TraverseSet (InhibitorSet, UpdateActivationInh);
  }





