float momentum=0.9, gain=1.0, lrate_bp=0.1, Tss=0.0, Pss=0.0, Tss_aux=0.0;


	 /*******  Functions for updating the Output *******/



float WeightedSum2 (UnitPtr unit)
	{
	float sum;
	LinkPtr curlink;
	curlink=unit->Links;
	sum=0.0;
	while (curlink)
	  {
	   sum += curlink->Weight * curlink->From->Output;
	   curlink->To->Free1 += curlink->From->Output;
	   curlink = curlink->Next;
	  }
	return (sum);
	}

void UpdateOutput(UnitPtr unit)
   {
   float expo, ws;
   ws = WeightedSum(unit);
   if (ws > 4.0)
     ws = 4.0;
   else if (ws < -4.0)
     ws = -4.0;
   expo=exp(gain * ws);
   unit->Output=1.0/(1.0 + 1.0/expo);
   }

void SetOutput (UnitPtr unit, float n)
   {
   unit->Output=n;
   }

	  /******  Learning  functions *****/

void SetOutputError(UnitPtr unit)
  {
  unit->Free1 = (unit->Free2 - unit->Output)*
		unit->Output*
		(1.0 - unit->Output);
  }

void Backwards (LinkPtr link)
  {
  link->From->Free1 += link->To->Free1*link->Weight;
  link->Free1 = lrate_bp*link->To->Free1*link->From->Output +
		momentum*link->Free1;
  link->Weight += link->Free3*link->Free1;
  }

void FromFirstHiddenBackwards (LinkPtr link)
  {
  link->Free1 = lrate_bp*link->To->Free1*link->From->Output +
		momentum*link->Free1;
  link->Weight += link->Free3*link->Free1;
  }

void SetHiddenError (UnitPtr unit)
  {
  unit->Free1 *= unit->Output*(1.0 - unit->Output);
  }


void ComputeTss(SetPtr set, int no_of_patterns)
  {
  int i;
  for (i=0; i<set->Length; i++)
   Tss_aux +=
	(SetMember (set,i)->Free2-SetMember(set, i)->Output)*
	(SetMember (set,i)->Free2-SetMember(set, i)->Output);
  if (0==cycle%no_of_patterns)
     {
     Tss=Tss_aux;
     Tss_aux=0.0;
     }
  }

void ComputeTss2(SetPtr set, int no_of_patterns, int var)
  {
  int i;
  for (i=0; i<set->Length; i++)
   Tss_aux +=
	(SetMember (set,i)->Free2-SetMember(set, i)->Output)*
	(SetMember (set,i)->Free2-SetMember(set, i)->Output);
  if (0==var%no_of_patterns)
     {
     Tss=Tss_aux;
     Tss_aux=0.0;
     }
  }

void ComputePss(SetPtr set)
  {
   int i;
   Pss=0.0;
   for (i=0; i<set->Length; i++)
     Pss +=
	(SetMember (set,i)->Free2-SetMember(set, i)->Output)*
	(SetMember (set,i)->Free2-SetMember(set, i)->Output);
   }

