#include <bool.h>
#include <fstream.h>
#include <signal.h>
#include <GetOpt.h>
#include "simulate.h"

int main (int argc, char **argv) {
  double	decay	 =    -7.0;		// lg(decaying rate = epsilon0)
  double	fudge	 =    -6.0;		// lg(fudge factor)
  double	learn	 =   -42.0;		// lg(learning rate = eta)
  int		sample	 =     0;		// sample interval
  int		trials	 =  3048;		// number of trials
  int		update	 =   127;		// update interval
  int		verbose  = FALSE;		// verbose report
  GetOpt	getopt (argc, argv, "-d:f:l:s:t:u:v");// don't permute argv
  getopt.opterr	 = 0;				// don't report errors

  int option;					// option flags
  while ((option = getopt()) != EOF)
    switch (option) {
      case 'd':					// lg(decaying rate)
	decay	= atof(getopt.optarg);
	break;
      case 'f':					// lg(fudge factor)
	fudge	= atof(getopt.optarg);
	break;
      case 'l':					// lg(learning rate)
	learn	= atof(getopt.optarg);
	break;
      case 's':					// sample interval
	sample	= atoi(getopt.optarg);
	break;
      case 't':					// number of trials
	trials	= atoi(getopt.optarg);
	break;
      case 'u':					// update interval
	update	= atoi(getopt.optarg);
	break;
      case 'v':					// verbose report
	verbose	= TRUE;
	break;
      case '?':					// unrecognized option
	break;					// but don't complain
      };

  if (verbose)					// report options
    cerr	<< decay	<< " = decay, "
		<< fudge	<< " = fudge, "
		<< learn	<< " = learn, "
		<< sample	<< " = sample, "
		<< trials	<< " = trials, "
		<< update	<< " = update\n";

  initialize(argc, argv);			// initialize aircraft model

/*
  Create storage for the network and read it into memory.
*/
  ifstream	sin("network.old");		// open   input stream
  int		layers;		sin >> layers;	// number of layers
#ifdef	__GNUC__
  matrix       lv[layers];			// stack 1 on top of v
   array	v[layers];			// network I/O vectors
  matrix	P[layers];			// parameter matrices
#ifdef	LEARNING
   array	b[layers];			// threshold  biases
   array	W[layers];			// connection weights
  matrix	D[layers];			// "equivalent errors"
  matrix	G[layers];			// Total Partial Derivatives
#endif
#else
  matrix *const	lv	 = new matrix[layers];	// stack 1 on top of v
   array *const  v	 = new  array[layers];	// network I/O vectors
  matrix *const  P	 = new matrix[layers];	// parameter matrices
#ifdef	LEARNING
   array *const  b	 = new  array[layers];	// threshold  biases
   array *const  W	 = new  array[layers];	// connection weights
  matrix *const  D	 = new matrix[layers];	// "equivalent errors"
  matrix *const  G	 = new matrix[layers];	// Total Partial Derivatives
#endif
#endif
  int		inputs;	sin >> inputs;		// number of  inputs
  int		outputs	 = inputs;		// number of outputs
  if (verbose)					// report network nodes
    cerr << "N(" << inputs;

  for (int layer = 0; layer < layers; layer++) {
    int inputs = outputs;	sin >> outputs;
    if (verbose)
      cerr << ", " << outputs;
   lv[layer].resize(1+inputs, 1, 1.0);
    v[layer].resize(lv[layer].s(1, inputs));
    P[layer].resize(outputs, 1+inputs);
#ifdef  LEARNING
    b[layer].resize(P[layer].s(0, outputs, 0, 1));
    W[layer].resize(P[layer].s(0, outputs, 1, inputs));
    D[layer].resize(n, outputs);
    G[layer].resize(outputs*(1+inputs), n, 0.0);
#endif
    sin >> P[layer];
    };
  if (verbose)
    cerr << ")\n";

#ifdef  LEARNING
  matrix	v0( inputs, 1), dv( inputs, 1);	// inputs
  sin >> v0 >> dv;
  matrix	u0(outputs, 1), du(outputs, 1);	// outputs
  sin >> u0 >> du;
  matrix	w(n, 1);			// error weights
  sin >> w;
  sin.close();					// close  input stream

  if (verbose) {
    format("%9.2e", 8, " ");
    cerr << row(v0) << row(dv) << row(u0) << row(du) << row(w);
    cerr.flush();
    }

   array	X(W[0].s(0, W[0].m(), 0, n));	// state     input weights
   array	R(W[0].s(0, W[0].m(), n));	// reference input weights
  dv			*= pow(2.0, fudge);
  b[ 0]			+= W[0]%row(v0);	//   normalize
  X.s(0, X.m(), 8, 1)	+= row_sum(R);
  W[0]			*= row(dv);

  diag(I)	 = 1.0;				// initialize derivatives
  matrix	d(n, 1, 0.0);			// desired state
  matrix	e(n, 1);			// weighted state errors
  double	eta	 = pow(2.0, learn);		// learning rate
  double	epsilon0 = pow(2.0, decay);		// decaying rate
  format("%6.0e", 11, " ");			// matrix output format
#endif
/*
  If display updates are required,
  get the clear and home cursor control sequences and clear the display.
*/
  char	buffer[16];				// cursor control sequences
  char*	clear;					// clear  control sequence
  char*	home;					// home   control sequence
  if (0 < update) {
    char	bp[1024];			// termcap entry buffer
    if (tgetent(bp, getenv("TERM")) == 1) {
      char*	next = buffer;			// next   control sequence
      clear	= tgetstr("cl", &next);
      home	= tgetstr("ho", &next);
      cout << clear;
      display(home);				// initialize display
      }
    else
      cerr << "Can't get termcap entry!\n";
    };

  if (0 < sample) {
    cerr << trials/sample << "\n";		// number of samples
    }
#ifdef	__GNUC__
  signal(SIGINT , user_signal2_handler);	// ^C
  signal(SIGQUIT, user_signal3_handler);	// ^|
#endif
   array	x0(v[0].s(0, n));		// state     inputs
   array	r0(v[0].s(n, v[0].m()-n));	// reference inputs
				// REAL TIME SIMULATION LOOP
  int		trial	 = 0;			// trial number
  while (patient && trial++ < trials) {
    x		 = f;				// x <-- f(x, u)
    x0		 = x;				// input system state
    reference(r0);				// input reference signals
#ifdef  LEARNING
    v[0]	 -= v0;				//   normalize  inputs
    r0		 -= x[8][0];
    v[0]	 /= dv;
#endif
    int	layer;			// Feed Forward
    for (layer = 0; layer < layers-1; layer++)
      v[layer+1] = tanh(P[layer]%row(lv[layer]));
    u		 = P[layer]%row(lv[layer]);

    emulate();					// f(x, u)
#ifdef  LEARNING
    if (permitted()) {				// state within bounds
				// Back Propagate
      D[layers-1]	 = B;
      for (layer = layers-1; 0 < layer; layer--)
        D[layer-1] = D[layer]%((1.0 - v[layer]*v[layer])*W[layer].t());

				// Update
      double	epsilon	 = epsilon0 + 1.0/trial;
      desired(d);				// input desired state
      e		 = eta*w*(d - f);		// weighted incremental errors
      for (layer = 0; layer < layers; layer++) {
        G[layer]	 = G[layer]%((1.0 - epsilon)*(A + D[0]%X.t()))
		 + kronecker(D[layer].t(), epsilon*lv[layer]);
        row(P[layer])	+= row(e)%G[layer];
        }
      }
    else {					// state out of bounds
      trial	 = 0;
      reset();
      for (layer = 0; layer < layers; layer++) {
        G[layer]	 = 0.0;
        }
      }
#endif
    if (0 < update && trial%update == 0) {
      if (corrupt) {
	cout << clear;
	corrupt = FALSE;
	}
      display(home);				// update display
      };
    if (0 < sample && trial%sample == 0) {
      };
    };

#ifdef  LEARNING
  W[0]			/= row(dv);		// denormalize
  X.s(0, X.m(), 8, 1)	-= row_sum(R);
  b[0]			-= W[0]%row(v0);
  dv			/= pow(2.0, fudge);

  format("%19.12e", 4, " ");			// matrix output format
  ofstream	sout("network.new");		// open  output stream
  sout << layers << "\n";			// number of  layers
  sout << P[0].n() - 1 << "\n";			// number of  inputs
  for (layer = 0; layer < layers; layer++) {
    sout << P[layer].m() << "\n";		// number of outputs
    sout << P[layer] << "\n";
    };
  sout << row(v0) << row(dv);
  sout << row(u0) << row(du);
  sout << row(w);
  sout.close();					// close output stream
#endif
  }
