#include "variables.h"
#include "<C>.real.h"

<C>&	<C>::operator  = (const <C&> y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	 = y[i];
  return *this;
  }
<C>&	<C>::operator *= (const <C&> y) {
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = X[i]*y[0] + y[i]*X[0];
  X[0]		*= y[0];
  return *this;
  }
<C>&	<C>::operator /= (const <C&> y) {
  X[0]		*= (1.0/y[0]);
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 =(X[i] - y[i]*X[0])*(1.0/y[0]);
  return *this;
  }
<C>&	<C>::operator += (const <C&> y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	+= y[i];
  return *this;
  }
<C>&	<C>::operator -= (const <C&> y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	-= y[i];
  return *this;
  }
<C>&	<C>::operator  = (const <T&> y) {
  X[0]	 = y;
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = 0.0;
  return *this;
  }
<C>&	<C>::operator *= (const <T&> y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	*= y;
  return *this;
  }
<C>&	<C>::operator /= (const <T&> y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	*= (1.0/y);
  return *this;
  }
<C>&	<C>::neg(const <C&> y) {
  for(int i = 0; i <= VARIABLES; i++)
    X[i]	 = -y[i];
  return *this;
  }

<C>&	<C>::mul(const <C&> x, const <C&> y) {
  X[0]	 = x[0]*y[0];
  for (int i = 1; i <= VARIABLES; i++)
    X[i] = x[i]*y[0] + y[i]*x[0];
  return *this;
  }
<C>&	<C>::div(const <C&> x, const <C&> y) {
  X[0]	 = x[0]*(1.0/y[0]);
  for (int i = 1; i <= VARIABLES; i++)
    X[i] =(x[i] - y[i]*X[0])*(1.0/y[0]);
  return *this;
  }
<C>&	<C>::add(const <C&> x, const <C&> y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	 = x[i] + y[i];
  return *this;
  }
<C>&	<C>::sub(const <C&> x, const <C&> y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	 = x[i] - y[i];
  return *this;
  }
<C>&	<C>::mul(const <C&> x, const <T&> y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	 = x[i]*y;
  return *this;
  }
<C>&	<C>::div(const <C&> x, const <T&> y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	 = x[i]*(1.0/y);
  return *this;
  }
<C>&	<C>::add(const <C&> x, const <T&> y) {
  X[0]	 = x[0] + y;
  for (int i = 1; i <= VARIABLES; i++)
    X[i] = x[i];
  return *this;
  }
<C>&	<C>::sub(const <C&> x, const <T&> y) {
  X[0]	 = x[0] - y;
  for (int i = 1; i <= VARIABLES; i++)
    X[i] = x[i];
  return *this;
  }
<C>&	<C>::mul(const <T&> x, const <C&> y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	 = x*y[i];
  return *this;
  }
<C>&	<C>::div(const <T&> x, const <C&> y) {
  X[0]	 = x/y[0];
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = y[i]*(-X[0]/y[0]);
  return *this;
  }
<C>&	<C>::add(const <T&> x, const <C&> y) {
  X[0]	 = x + y[0];
  for (int i = 1; i <= VARIABLES; i++)
    X[i] = y[i];
  return *this;
  }
<C>&	<C>::sub(const <T&> x, const <C&> y) {
  X[0]	 = x - y[0];
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = -y[i];
  return *this;
  }
<C>&	<C>::pow(const <C&> x, const <T&> y) {
  if (0.0 < x) {
    X[0]	 = ::pow(x[0], y);
    for (int i = 1; i <= VARIABLES; i++)
      X[i]	 = x[i]*X[0]*y/x[0];
    }
  else
    *this	 = 0.0;
  return *this;
  }
<C>&	<C>::sgn(const <C&> x, const <C&> y) {
  if (0.0 < x && y < 0.0 || 0.0 < y && x < 0.0)
    *this	 =-x;
  else
    *this	 = x;
  return *this;
  }
<C>&	<C>::sgn(const <T&> x, const <C&> y) {
  if (0.0 < x && y < 0.0 || 0.0 < y && x < 0.0)
    *this	 =-x;
  else
    *this	 = x;
  return *this;
  }
<C>&	<C>::abs(const <C&> x) {
  if (x < 0.0)
    *this	 = -x;
  else
    *this	 =  x;
  return *this;
  }
<C>&	<C>::cos(const <C&> x) {
  X[0]	 = ::cos(x[0]);
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = x[i]*::sin(-x[0]);
  return *this;
  }
<C>&	<C>::sin(const <C&> x) {
  X[0]	 = ::sin(x[0]);
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = x[i]*::cos( x[0]);
  return *this;
  }
<C>&	<C>::sqrt(const <C&> x) {
  X[0]	 = ::sqrt(x[0]);
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = x[i]*(0.5/::sqrt(x[0]));
  return *this;
  }
<C>&	<C>::asin(const <C&> x) {
  X[0]	 = ::asin(x[0]);
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = x[i]*(1.0/::sqrt(1.0 - x[0]*x[0]));
  return *this;
  }
