C
      SUBROUTINE TLU
C                                                            
C.... ROUTINE TO DO TABLE LOOK-UP FOR AEROMODEL.
C                                
C.... WRITTEN JUNE 1, 1978.
C     LEE DUKE NASA/DFRC
C.... MODIFIED OCTOBER 1990
C     RANDY BRUMBAUGH  PRC
C                  
C
      INTEGER  I, IDXAA1, IDXAB1, IDXBA1, IDXBB1, IDXBC1, IDXBD1
      INTEGER  IDXCL1, IDXDH1, IDXDR1, IDXMB1, IDXMA1, IDXMA2, IDXMC1
      INTEGER  INDXA1, INDXA2, INDXA3, INDXA4, INDXA5, INDXA6,
     .         INDXA7, INDXA8
      INTEGER  INDXB1, INDXB2, INDXB3, INDXB4
      INTEGER  INDXC1, INDXC2, INDXC3, INDXC4
      INTEGER  INDXD1, INDXD2, INDXD3, INDXD4, INDXD5, INDXD6,
     .         INDXD7, INDXD8
      INTEGER  INDXE1, INDXE2, INDXE3, INDXE4, INDXE5, INDXE6,
     .         INDXE7, INDXE8
      INTEGER  INDXF1, INDXF2, INDXF3, INDXF4, INDXF5, INDXF6,
     .         INDXF7, INDXF8
      INTEGER  INDXG1, INDXG2, INDXG3, INDXG4, INDXG5, INDXG6,
     .         INDXG7, INDXG8
      INTEGER  INDXH1, INDXH2, INDXH3, INDXH4, INDXH5, INDXH6,
     .         INDXH7, INDXH8
C
      REAL  F101A1, F101A2, F101A3, F101A4, F101B1, F101B2
      REAL  F201A1, F201A2
      REAL  F301A1, F301A2, F301A3, F301A4, F301B1, F301B2, F301
      REAL  F302A1, F302A2, F302A3, F302A4, F302B1, F302B2
      REAL  F313A1, F313A2
      REAL  F314A1, F314A2
      REAL  F315A1, F315A2, F315A3, F315A4, F315B1, F315B2, F315
      REAL  F401A1, F401A2, F401A3, F401A4, F401B1, F401B2, F401
      REAL  F402A1, F402A2, F402A3, F402A4, F402B1, F402B2
      REAL  F411A1, F411A2
      REAL  F412A1, F412A2
      REAL  F413A1, F413A2
      REAL  F414A1, F414A2
      REAL  F415A1, F415A2, F415A3, F415A4, F415B1, F415B2, F415
      REAL  F418A1, F418A2, F418A3, F418A4, F418B1, F418B2
      REAL  F501A1, F501A2, F501A3, F501A4, F501B1, F501B2
      REAL  F513A1, F513A2
      REAL  F514A1, F514A2
      REAL  F601A1, F601A2, F601A3, F601A4, F601B1, F601B2, F601
      REAL  F602A1, F602A2, F602A3, F602A4, F602B1, F602B2
      REAL  F611A1, F611A2
      REAL  F612A1, F612A2
      REAL  F613A1, F613A2
      REAL  F614A1, F614A2
      REAL  F615A1, F615A2, F615A3, F615A4, F615B1, F615B2
      REAL  F617A1, F617A2
      REAL  F618A1, F618A2, F618A3, F618A4, F618B1, F618B2
C
      REAL  RATOAA, RATOAB, RATOBA, RATOBB, RATOBC, RATAA1, 
     .      RATAB1, RATBA1, RATBB1, RATBC1, RATCL1
      REAL  RATOBD, RATODH, RATODR, RATDH1, RATDR1, RATOCL
      REAL  RATOMA, RATOMB, RATOMC, RATMA1, RATBD1, RATMC1
      REAL  ALPHAA, ALPHAB, AMCHA, AMCHB
      REAL  BETAA, BETAB, BETAC, BETAD
      REAL  DR, DH, DRX1, DHX, CLX
      REAL  ALPD, BTAD, ABSBTA, ADR
      REAL  XDXAA1, XDXAB1, XDXBA1, XDXBB1, XDXCL1, XDXDH1,
     .      XDXDR1, XDXMB1
      REAL T,      P,      Q,      R,    V,    ALP,    BTA, 
     .     THA,    PSI,    PHI,    H,    X,    Y,
     .     TDOT,   PDOT,   QDOT,   RDOT, VDOT, ALPDOT, BTADOT, 
     .     THADOT, PSIDOT, PHIDOT, HDOT, XDOT, YDOT
C                 
      DIMENSION AMCHA  (10)                                                     
      DIMENSION AMCHB  ( 8)                                                     
      DIMENSION ALPHAA (19)                                                     
      DIMENSION ALPHAB ( 8)                                                     
      DIMENSION DHX    ( 5)                                                     
      DIMENSION CLX    (14)                                                     
      DIMENSION BETAA  ( 8)                                                     
      DIMENSION BETAB  ( 5)                                                     
      DIMENSION BETAC  ( 5)                                                     
      DIMENSION BETAD  ( 3)                                                     
      DIMENSION DRX1   ( 4)                                                     
C                                                                               
c     INCLUDE 'zzcom.h'
      INCLUDE 'arodat.h'
      INCLUDE 'fmcoef.h'
C
c     INCLUDE 'include.h'
      INCLUDE 'contrl.h'
      INCLUDE 'drvout.h'
      INCLUDE 'simout.h'
      INCLUDE 'parameter.h'
C
      EQUIVALENCE (DR,  DC( 9) ), (DH,    DC( 5) )
C
      EQUIVALENCE(T     , F( 1)),                                               
     .           (P     , F( 2)),(Q     , F( 3)),(R     , F( 4)),               
     .           (V     , F( 5)),(ALP   , F( 6)),(BTA   , F( 7)),               
     .           (THA   , F( 8)),(PSI   , F( 9)),(PHI   , F(10)),               
     .           (H     , F(11)),(X     , F(12)),(Y     , F(13)),               
     .           (TDOT  ,DF( 1)),                                               
     .           (PDOT  ,DF( 2)),(QDOT  ,DF( 3)),(RDOT  ,DF( 4)),               
     .           (VDOT  ,DF( 5)),(ALPDOT,DF( 6)),(BTADOT,DF( 7)),               
     .           (THADOT,DF( 8)),(PSIDOT,DF( 9)),(PHIDOT,DF(10)),               
     .           (HDOT  ,DF(11)),(XDOT  ,DF(12)),(YDOT  ,DF(13))                
C                                                                               
      DATA AMCHA  /  0.2,  0.4,  0.6,  0.8,  0.9,  1.0,  1.1,  1.2,             
     .               1.4,  1.6/                                                 
      DATA AMCHB  /  0.2,  0.4,  0.6,  0.8,  1.0,  1.2,  1.4,  1.6/             
      DATA ALPHAA /-12.0, -8.0, -4.0,  0.0,  4.0,  8.0, 12.0, 16.0,             
     .              20.0, 24.0, 28.0, 32.0, 36.0, 40.0, 44.0, 48.0,             
     .              52.0, 56.0, 60.0/                                           
      DATA ALPHAB / 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 55.0, 60.0/             
      DATA DHX    /-25.0,-15.0, -5.0,  5.0, 15.0/                               
      DATA CLX    / -1.0, -0.8, -0.6, -0.4, -0.2,  0.0,  0.2,  0.4,             
     .               0.6,  0.8,  1.0,  1.2,  1.4,  1.6/                         
      DATA BETAA  /  0.0,  4.0,  8.0, 12.0, 16.0, 20.0, 24.0, 28.0/             
      DATA BETAB  /-10.0, -5.0,  0.0,  5.0, 10.0/                               
      DATA BETAC  /  0.0,  4.0,  8.0, 12.0, 16.0/                               
      DATA BETAD  / 10.0, 20.0, 30.0/                                           
      DATA DRX1    /  0.0, 10.0, 20.0, 30.0/                                     
C                                                                               
      ADR   =ABS(DR)                                                            
C                                                                               
C.... CONVERT TO DEGREES.                                                       
C                                                                               
      ALPD  =ALP*DGR                                                            
      BTAD  =BTA*DGR                                                            
      ABSBTA=ABS(BTAD)                                                          
C                                                                               
C.... CALCULATE INDICES INTO ARRAYS.                                            
C                                                                               
      IDXMA1=1                                                                  
      DO 1 I=2,9                                                                
      IF(AMCH.GE.AMCHA(I)) IDXMA1=I                                             
    1 CONTINUE                                                                  
      IDXMA2=IDXMA1+1                                                           
C                                                                               
      XDXMB1=AMCH/0.2+0.01                                                      
      IDXMB1=XDXMB1                                                             
      IF(IDXMB1.LT.1) IDXMB1=1                                                  
      IF(IDXMB1.GT.7) IDXMB1=7                                                  
C                                                                               
      IDXMC1=1                                                                  
C                                                                               
      XDXAA1=(ALPD+12.0)/4.0+1.01                                               
      IDXAA1=XDXAA1                                                             
      IF(IDXAA1.LT.1) IDXAA1=1                                                  
      IF(IDXAA1.GT.18) IDXAA1=18                                                
C                                                                               
      XDXAB1=(ALPD-25.0)/5.0+1.01                                               
      IDXAB1=XDXAB1                                                             
      IF(IDXAB1.LT.1) IDXAB1=1                                                  
      IF(IDXAB1.GT.7) IDXAB1=7                                                  
C                                                                               
      XDXDH1=(DH+25.0)/10.0+1.01                                                
      IDXDH1=XDXDH1                                                             
      IF(IDXDH1.LT.1) IDXDH1=1                                                  
      IF(IDXDH1.GT.4) IDXDH1=4                                                  
C                                                                               
      XDXBA1=ABSBTA/4.0+1.01                                                    
      IDXBA1=XDXBA1                                                             
      IF(IDXBA1.LT.1) IDXBA1=1                                                  
      IF(IDXBA1.GT.7) IDXBA1=7                                                  
C                                                                               
      XDXBB1=(BTAD+10.0)/5.0+1.01                                               
      IDXBB1=XDXBB1                                                             
      IF(IDXBB1.LT.1) IDXBB1=1                                                  
      IF(IDXBB1.GT.4) IDXBB1=4                                                  
C                                                                               
      IDXBC1=IDXBA1                                                             
      IF(IDXBC1.LT.1) IDXBC1=1                                                  
      IF(IDXBC1.GT.4) IDXBC1=4                                                  
C                                                                               
      IDXBD1=1                                                                  
      IF(ABSBTA.GT.10.0) IDXBD1=2                                               
C                                                                               
      XDXDR1=ADR/10.0+1.01                                                      
      IDXDR1=XDXDR1                                                             
      IF(IDXDR1.LT.1) IDXDR1=1                                                  
      IF(IDXDR1.GT.3) IDXDR1=3                                                  
C                                                                               
C                                                                               
      INDXA1=IDXMA1+10*(IDXAA1-1+19*(IDXDH1-1))                                 
      INDXA2=INDXA1+1                                                           
      INDXA3=INDXA1+10                                                          
      INDXA4=INDXA2+10                                                          
      INDXA5=INDXA1+190                                                         
      INDXA6=INDXA2+190                                                         
      INDXA7=INDXA3+190                                                         
      INDXA8=INDXA4+190                                                         
C                                                                               
      INDXC1=IDXMA1+10*(IDXAA1-1)                                               
      INDXC2=INDXC1+1                                                           
      INDXC3=INDXC1+10                                                          
      INDXC4=INDXC2+10                                                          
C                                                                               
      INDXD1=IDXMA1+10*(IDXAA1-1+19*(IDXBA1-1))                                 
      INDXD2=INDXD1+1                                                           
      INDXD3=INDXD1+10                                                          
      INDXD4=INDXD2+10                                                          
      INDXD5=INDXD1+190                                                         
      INDXD6=INDXD2+190                                                         
      INDXD7=INDXD3+190                                                         
      INDXD8=INDXD4+190                                                         
C                                                                               
      INDXE1=IDXMC1+2*(IDXAB1-1+8*(IDXBB1-1))                                   
      INDXE2=INDXE1+1                                                           
      INDXE3=INDXE1+2                                                           
      INDXE4=INDXE2+2                                                           
      INDXE5=INDXE1+16                                                          
      INDXE6=INDXE2+16                                                          
      INDXE7=INDXE3+16                                                          
      INDXE8=INDXE4+16                                                          
C                                                                               
      INDXF1=IDXMA1+10*(IDXAA1-1+19*(IDXDR1-1))                                 
      INDXF2=INDXF1+1                                                           
      INDXF3=INDXF1+10                                                          
      INDXF4=INDXF2+10                                                          
      INDXF5=INDXF1+190                                                         
      INDXF6=INDXF2+190                                                         
      INDXF7=INDXF3+190                                                         
      INDXF8=INDXF4+190                                                         
C                                                                               
      INDXG1=IDXMA1+10*(IDXAA1-1+19*(IDXBC1-1))                                 
      INDXG2=INDXG1+1                                                           
      INDXG3=INDXG1+10                                                          
      INDXG4=INDXG2+10                                                          
      INDXG5=INDXG1+190                                                         
      INDXG6=INDXG2+190                                                         
      INDXG7=INDXG3+190                                                         
      INDXG8=INDXG4+190                                                         
C                                                                               
      INDXH1=IDXMA1+10*(IDXAA1-1+19*(IDXBD1-1))                                 
      INDXH2=INDXH1+1                                                           
      INDXH3=INDXH1+10                                                          
      INDXH4=INDXH2+10                                                          
      INDXH5=INDXH1+190                                                         
      INDXH6=INDXH2+190                                                         
      INDXH7=INDXH3+190                                                         
      INDXH8=INDXH4+190                                                         
C                                                                               
C                                                                               
C.... COMPUTE INTERPOLATION RATIOS.                                             
C                                                                               
      RATOMA=(AMCH  -AMCHA (IDXMA1))/(AMCHA (IDXMA2)-AMCHA (IDXMA1))            
      RATOMB=(AMCH  -AMCHB (IDXMB1))/0.2                                        
      RATOMC=(AMCH  -0.2)/0.4                                                   
      RATOAA=(ALPD  -ALPHAA(IDXAA1))/4.0                                        
      RATOAB=(ALPD  -ALPHAB(IDXAB1))/5.0                                        
      RATODH=(DH *0.8   -DHX   (IDXDH1))/10.0                                       
      RATOBA=(ABSBTA-BETAA (IDXBA1))/4.0                                        
      RATOBB=(BTAD  -BETAB (IDXBB1))/5.0                                        
      RATOBC=(ABSBTA-BETAC (IDXBC1))/4.0                                        
      RATOBD=(ABSBTA-BETAD (IDXBD1))/10.0                                       
      IF(ABSBTA.LT.10.0) RATOBD=0.0                                             
      RATODR=(ADR   -DRX1   (IDXDR1))/10.0                                       
C                                                                               
      IF(AMCH  .GT.   1.6) RATOMA=1.0                                           
      IF(AMCH  .GT.   1.6) RATOMB=1.0                                           
      IF(AMCH  .LT.   0.2) RATOMC=0.0                                           
      IF(AMCH  .GT.   0.6) RATOMC=1.0                                           
      IF(ALPD  .LT. -12.0) RATOAA=0.0                                           
      IF(ALPD  .GT.  60.0) RATOAA=1.0                                           
      IF(ALPD  .LT. 25.0) RATOAB=0.0                                            
      IF(ALPD  .GT.  60.0) RATOAB=1.0                                           
      IF(ABSBTA.GT.  28.0) RATOBA=1.0                                           
      IF(BTAD  .LT.  -10.0) RATOBB=0.0                                          
      IF(BTAD  .GT.  10.0) RATOBB=1.0                                           
      IF(ABSBTA.GT.  16.0) RATOBC=1.0                                           
      IF(ABSBTA.GT.  30.0) RATOBD=1.0                                           
C                                                                               
      RATMA1=1.0-RATOMA                                                         
      RATMC1=1.0-RATOMC                                                         
      RATAA1=1.0-RATOAA                                                         
      RATAB1=1.0-RATOAB                                                         
      RATDH1=1.0-RATODH                                                         
      RATBA1=1.0-RATOBA                                                         
      RATBB1=1.0-RATOBB                                                         
      RATBC1=1.0-RATOBC                                                         
      RATBD1=1.0-RATOBD                                                         
      RATDR1=1.0-RATODR                                                         
C                                                                               
C                                                                               
C.... TABLE LOOK UP.                                                            
C                                                                               
      F101A1=RATOMA*F101A (INDXA2)+F101A (INDXA1)*RATMA1                        
      F101A2=RATOMA*F101A (INDXA4)+F101A (INDXA3)*RATMA1                        
      F101A3=RATOMA*F101A (INDXA6)+F101A (INDXA5)*RATMA1                        
      F101A4=RATOMA*F101A (INDXA8)+F101A (INDXA7)*RATMA1                        
      F101B1=RATOAA*F101A2        +F101A1        *RATAA1                        
      F101B2=RATOAA*F101A4        +F101A3        *RATAA1                        
      F101B1=RATOAA*F101A2        +F101A1        *RATAA1                        
      CLFTB =RATODH*F101B2        +F101B1        *RATDH1
C                                                                               
      DCLNZ =RATOMA*F105A (IDXMA2)+F105A (IDXMA1)*RATMA1                        
C                                                                               
      DCL0  =RATOMA*F106A (IDXMA2)+F106A (IDXMA1)*RATMA1                        
C                                                                               
      DCLA1 =RATOMA*F107A (IDXMA2)+F107A (IDXMA1)*RATMA1                        
C                                                                               
      DCLA2 =RATOMA*F108A (IDXMA2)+F108A (IDXMA1)*RATMA1                        
C                                                                               
      DCDNOZ=RATOMA*F203A (IDXMA2)+F203A (IDXMA1)*RATMA1                        
C                                                                               
      DCDSB =RATOMA*F206A (IDXMA2)+F206A (IDXMA1)*RATMA1                        
C                                                                               
      F301A1=RATOMA*F301A (INDXD2)+F301A (INDXD1)*RATMA1                        
      F301A2=RATOMA*F301A (INDXD4)+F301A (INDXD3)*RATMA1                        
      F301A3=RATOMA*F301A (INDXD6)+F301A (INDXD5)*RATMA1                        
      F301A4=RATOMA*F301A (INDXD8)+F301A (INDXD7)*RATMA1                        
      F301B1=RATOAA*F301A2        +F301A1        *RATAA1                        
      F301B2=RATOAA*F301A4        +F301A3        *RATAA1                        
      F301  =RATOBA*F301B2        +F301B1        *RATBA1                        
      CYB1  =F301*SIGN(1.0,BTA)                                                 
C                                                                               
      F302A1=RATOMC*F302A (INDXE2)+F302A (INDXE1)*RATMC1                        
      F302A2=RATOMC*F302A (INDXE4)+F302A (INDXE3)*RATMC1                        
      F302A3=RATOMC*F302A (INDXE6)+F302A (INDXE5)*RATMC1                        
      F302A4=RATOMC*F302A (INDXE8)+F302A (INDXE7)*RATMC1                        
      F302B1=RATOAB*F302A2        +F302A1        *RATAB1                        
      F302B2=RATOAB*F302A4        +F302A3        *RATAB1                        
      CYB2  =RATOBB*F302B2        +F302B1        *RATBB1                        
C                                                                               
      F313A1=RATOMA*F313A (INDXC2)+F313A (INDXC1)*RATMA1                        
      F313A2=RATOMA*F313A (INDXC4)+F313A (INDXC3)*RATMA1                        
      CYDA  =RATOAA*F313A2        +F313A1        *RATAA1                        
C                                                                               
      F314A1=RATOMA*F314A (INDXC2)+F314A (INDXC1)*RATMA1                        
      F314A2=RATOMA*F314A (INDXC4)+F314A (INDXC3)*RATMA1                        
      CYDD  =RATOAA*F314A2        +F314A1        *RATAA1                        
C                                                                               
      F315A1=RATOMA*F315A (INDXF2)+F315A (INDXF1)*RATMA1                        
      F315A2=RATOMA*F315A (INDXF4)+F315A (INDXF3)*RATMA1                        
      F315A3=RATOMA*F315A (INDXF6)+F315A (INDXF5)*RATMA1                        
      F315A4=RATOMA*F315A (INDXF8)+F315A (INDXF7)*RATMA1                        
      F315B1=RATOAA*F315A2        +F315A1        *RATAA1                        
      F315B2=RATOAA*F315A4        +F315A3        *RATAA1                        
      F315  =RATODR*F315B2        +F315B1        *RATDR1                        
      DCYDR =SIGN(F315,DR)                                                      
C                                                                               
      DRYK  =RATOMA*F316A (IDXMA2)+F316A (IDXMA1)*RATMA1                        
C                                                                               
      F401A1=RATOMA*F401A (INDXD2)+F401A (INDXD1)*RATMA1                        
      F401A2=RATOMA*F401A (INDXD4)+F401A (INDXD3)*RATMA1                        
      F401A3=RATOMA*F401A (INDXD6)+F401A (INDXD5)*RATMA1                        
      F401A4=RATOMA*F401A (INDXD8)+F401A (INDXD7)*RATMA1                        
      F401B1=RATOAA*F401A2        +F401A1        *RATAA1                        
      F401B2=RATOAA*F401A4        +F401A3        *RATAA1                        
      F401  =RATOBA*F401B2        +F401B1        *RATBA1                        
      CLB1  =F401*SIGN(1.0,BTA)                                                 
C                                                                               
      F402A1=RATOMC*F402A (INDXE2)+F402A (INDXE1)*RATMC1                        
      F402A2=RATOMC*F402A (INDXE4)+F402A (INDXE3)*RATMC1                        
      F402A3=RATOMC*F402A (INDXE6)+F402A (INDXE5)*RATMC1                        
      F402A4=RATOMC*F402A (INDXE8)+F402A (INDXE7)*RATMC1                        
      F402B1=RATOAB*F402A2        +F402A1        *RATAB1                        
      F402B2=RATOAB*F402A4        +F402A3        *RATAB1                        
      CLB2  =RATOBB*F402B2        +F402B1        *RATBB1                        
C                                                                               
      F411A1=RATOMA*F411A (INDXC2)+F411A (INDXC1)*RATMA1                        
      F411A2=RATOMA*F411A (INDXC4)+F411A (INDXC3)*RATMA1                        
      CLP  =RATOAA*F411A2        +F411A1        *RATAA1                        
C                                                                               
      F412A1=RATOMA*F412A (INDXC2)+F412A (INDXC1)*RATMA1                        
      F412A2=RATOMA*F412A (INDXC4)+F412A (INDXC3)*RATMA1                        
      CLR   =RATOAA*F412A2        +F412A1        *RATAA1                        
C                                                                               
      F413A1=RATOMA*F413A (INDXC2)+F413A (INDXC1)*RATMA1                        
      F413A2=RATOMA*F413A (INDXC4)+F413A (INDXC3)*RATMA1                        
      CLDA  =RATOAA*F413A2        +F413A1        *RATAA1                        
C                                                                               
      F414A1=RATOMA*F414A (INDXC2)+F414A (INDXC1)*RATMA1                        
      F414A2=RATOMA*F414A (INDXC4)+F414A (INDXC3)*RATMA1                        
      CLDD  =RATOAA*F414A2        +F414A1        *RATAA1                        
C                                                                               
      F415A1=RATOMA*F415A (INDXF2)+F415A (INDXF1)*RATMA1                        
      F415A2=RATOMA*F415A (INDXF4)+F415A (INDXF3)*RATMA1                        
      F415A3=RATOMA*F415A (INDXF6)+F415A (INDXF5)*RATMA1                        
      F415A4=RATOMA*F415A (INDXF8)+F415A (INDXF7)*RATMA1                        
      F415B1=RATOAA*F415A2        +F415A1        *RATAA1                        
      F415B2=RATOAA*F415A4        +F415A3        *RATAA1                        
      F415  =RATODR*F415B2        +F415B1        *RATDR1                        
      DCLDR =SIGN(F415,DR)                                                      
C                                                                               
      DRLK  =RATOMA*F416A (IDXMA2)+F416A (IDXMA1)*RATMA1                        
C                                                                               
      F418A1=RATOMA*F418A (INDXG2)+F418A (INDXG1)*RATMA1                        
      F418A2=RATOMA*F418A (INDXG4)+F418A (INDXG3)*RATMA1                        
      F418A3=RATOMA*F418A (INDXG6)+F418A (INDXG5)*RATMA1                        
      F418A4=RATOMA*F418A (INDXG8)+F418A (INDXG7)*RATMA1                        
      F418B1=RATOAA*F418A2        +F418A1        *RATAA1                        
      F418B2=RATOAA*F418A4        +F418A3        *RATAA1                        
      DCLSB =RATOBC*F418B2        +F418B1        *RATBC1                        
C                                                                               
      F501A1=RATOMA*F501A (INDXA2)+F501A (INDXA1)*RATMA1                        
      F501A2=RATOMA*F501A (INDXA4)+F501A (INDXA3)*RATMA1                        
      F501A3=RATOMA*F501A (INDXA6)+F501A (INDXA5)*RATMA1                        
      F501A4=RATOMA*F501A (INDXA8)+F501A (INDXA7)*RATMA1                        
      F501B1=RATOAA*F501A2        +F501A1        *RATAA1                        
      F501B2=RATOAA*F501A4        +F501A3        *RATAA1                        
      F501B1=RATOAA*F501A2        +F501A1        *RATAA1                        
      CMB   =RATODH*F501B2        +F501B1        *RATDH1                        
C                                                                               
      DCMNZ =RATOMA*F505A (IDXMA2)+F505A (IDXMA1)*RATMA1                        
C                                                                               
      DCM0  =RATOMA*F506A (IDXMA2)+F506A (IDXMA1)*RATMA1                        
C                                                                               
      DN0SB =RATOMA*F507A (IDXMA2)+F507A (IDXMA1)*RATMA1                        
C                                                                               
      DN0   =RATOMA*F509A (IDXMA2)+F509A (IDXMA1)*RATMA1                        
C                                                                               
      F513A1=RATOMA*F513A (INDXC2)+F513A (INDXC1)*RATMA1                        
      F513A2=RATOMA*F513A (INDXC4)+F513A (INDXC3)*RATMA1                        
      CMQ   =RATOAA*F513A2        +F513A1        *RATAA1                        
C                                                                               
      F514A1=RATOMA*F514A (INDXC2)+F514A (INDXC1)*RATMA1                        
      F514A2=RATOMA*F514A (INDXC4)+F514A (INDXC3)*RATMA1                        
      CMAD  =RATOAA*F514A2        +F514A1        *RATAA1                        
C                                                                               
      F601A1=RATOMA*F601A (INDXD2)+F601A (INDXD1)*RATMA1                        
      F601A2=RATOMA*F601A (INDXD4)+F601A (INDXD3)*RATMA1                        
      F601A3=RATOMA*F601A (INDXD6)+F601A (INDXD5)*RATMA1                        
      F601A4=RATOMA*F601A (INDXD8)+F601A (INDXD7)*RATMA1                        
      F601B1=RATOAA*F601A2        +F601A1        *RATAA1                        
      F601B2=RATOAA*F601A4        +F601A3        *RATAA1                        
      F601  =RATOBA*F601B2        +F601B1        *RATBA1                        
      CNB1  =F601*SIGN(1.0,BTA)                                                 
C                                                                               
      F602A1=RATOMC*F602A (INDXE2)+F602A (INDXE1)*RATMC1                        
      F602A2=RATOMC*F602A (INDXE4)+F602A (INDXE3)*RATMC1                        
      F602A3=RATOMC*F602A (INDXE6)+F602A (INDXE5)*RATMC1                        
      F602A4=RATOMC*F602A (INDXE8)+F602A (INDXE7)*RATMC1                        
      F602B1=RATOAB*F602A2        +F602A1        *RATAB1                        
      F602B2=RATOAB*F602A4        +F602A3        *RATAB1                        
      CNB2  =RATOBB*F602B2        +F602B1        *RATBB1                        
C                                                                               
      F611A1=RATOMA*F611A (INDXC2)+F611A (INDXC1)*RATMA1                        
      F611A2=RATOMA*F611A (INDXC4)+F611A (INDXC3)*RATMA1                        
      CNP   =RATOAA*F611A2        +F611A1        *RATAA1                        
C                                                                               
      F612A1=RATOMA*F612A (INDXC2)+F612A (INDXC1)*RATMA1                        
      F612A2=RATOMA*F612A (INDXC4)+F612A (INDXC3)*RATMA1                        
      CNR   =RATOAA*F612A2        +F612A1        *RATAA1                        
C                                                                               
      F613A1=RATOMA*F613A (INDXC2)+F613A (INDXC1)*RATMA1                        
      F613A2=RATOMA*F613A (INDXC4)+F613A (INDXC3)*RATMA1                        
      CNDA  =RATOAA*F613A2        +F613A1        *RATAA1                        
C                                                                               
      F614A1=RATOMA*F614A (INDXC2)+F614A (INDXC1)*RATMA1                        
      F614A2=RATOMA*F614A (INDXC4)+F614A (INDXC3)*RATMA1                        
      CNDD  =RATOAA*F614A2        +F614A1        *RATAA1                        
C                                                                               
      F615A1=RATOMA*F615A (INDXH2)+F615A (INDXH1)*RATMA1                        
      F615A2=RATOMA*F615A (INDXH4)+F615A (INDXH3)*RATMA1                        
      F615A3=RATOMA*F615A (INDXH6)+F615A (INDXH5)*RATMA1                        
      F615A4=RATOMA*F615A (INDXH8)+F615A (INDXH7)*RATMA1                        
      F615B1=RATOMA*F615A2        +F615A1        *RATMA1                        
      F615B2=RATOMA*F615A4        +F615A3        *RATMA1                        
      CNDR  =RATOBD*F615B2        +F615B1        *RATBD1                        
C                                                                               
      F617A1=RATOMA*F617A (INDXC2)+F617A (INDXC1)*RATMA1                        
      F617A2=RATOMA*F617A (INDXC4)+F617A (INDXC3)*RATMA1                        
      DRNK  =RATOAA*F617A2        +F617A1        *RATAA1                        
C                                                                               
      F618A1=RATOMA*F618A (INDXG2)+F618A (INDXG1)*RATMA1                        
      F618A2=RATOMA*F618A (INDXG4)+F618A (INDXG3)*RATMA1                        
      F618A3=RATOMA*F618A (INDXG6)+F618A (INDXG5)*RATMA1                        
      F618A4=RATOMA*F618A (INDXG8)+F618A (INDXG7)*RATMA1                        
      F618B1=RATOAA*F618A2        +F618A1        *RATAA1                        
      F618B2=RATOAA*F618A4        +F618A3        *RATAA1                        
      DCNSB =RATOBC*F618B2        +F618B1        *RATBC1                        
C                                                                               
C                                                                               
C.... LOOK UP CD AS A FUNCTION OF CLFT BASIC (F101).                            
C                                                                               
      XDXCL1=(CLFTB+1.0)/0.2+1.01                                                
      IDXCL1=XDXCL1                                                             
      IF(IDXCL1.LT.1) IDXCL1=1                                                  
      IF(IDXCL1.GT.13) IDXCL1=13                                                
C                                                                               
      INDXB1=IDXMA1+10*(IDXCL1-1)                                               
      INDXB2=INDXB1+1                                                           
      INDXB3=INDXB1+10                                                          
      INDXB4=INDXB2+10                                                          
C                                                                               
      RATOCL=(CLFTB  -CLX   (IDXCL1))/0.2                                        
      RATCL1=1.0-RATOCL                                                         
C                                                                               
      F201A1=RATOMA*F201A (INDXB2)+F201A (INDXB1)*RATMA1                        
      F201A2=RATOMA*F201A (INDXB4)+F201A (INDXB3)*RATMA1                        
      CDB   =(RATOCL*F201A2 +F201A1        *RATCL1)
C                                                                               
      RETURN                                                                    
      END                                                                       
