      REAL FUNCTION ENGSDL(ARG)
C
C.... ROUTINE TO COMPUTE ENGINE MODEL SCHEDULES.
C
C.... WRITTEN AUG. 3, 1978
C     LEE DUKE NASA/DFRC
C
      INTEGER I
      REAL ARG
C
      REAL FGIAA, ANCA
      REAL C03DAT,FGIA,B03DAT,ANCFA,FIDLAX,FMILAX,FMAXAX,
     .     TIDLA,TMILA,TMAXA,FIDLA,FMILA,FMAXA
      INTEGER IDXMC1,IDXMC2,IDXHB1,IDXHB2
      REAL RATOMC,RATMC1,RATOHB,RATHB1,RATOFG,RATFG1
      REAL B07SDL, C07SDL
C
      INTEGER IDXFG1,IDXFG2
      INTEGER INDXD1,INDXD2,INDXD3,INDXD4,INDXD5,INDXD6,
     .        INDXD7,INDXD8
      REAL GAINA1,GAINA2,GAINA3,GAINA4,GAINB1,GAINB2
C
      INTEGER IDXNC1,IDXNC2
      REAL RATONC,RATNC1
      INTEGER INDXE1,INDXE2,INDXE3,INDXE4,INDXE5,INDXE6,INDXE7,INDXE8
      REAL ANCFA1,ANCFA2,ANCFA3,ANCFA4,ANCFB1,ANCFB2
C
      DIMENSION FGIAA ( 6)
C
      DIMENSION ANCA  ( 9)
      COMMON /ENGTAB/ C03DAT(8),FGIA(24),B03DAT(8),ANCFA(36),
     .                FIDLAX(108),FMILAX(168),FMAXAX(168),
     .                TIDLA(108),TMILA(168),TMAXA(168),
     .                FIDLA(108),FMILA(168),FMAXA(168)
      COMMON /ENGIDX/ IDXMC1,IDXMC2,RATOMC,RATMC1,
     .                IDXHB1,IDXHB2,RATOHB,RATHB1
      DATA FGIAA  / 0.0  ,0.3  ,0.5  ,0.7  ,0.9  ,1.0  /
      DATA ANCA   / 0.0  ,0.168,0.170,0.277,0.362,0.545,0.787,0.936,
     .              1.0  /
C
      ENTRY C07SDL(ARG)
C
C.... ENTRY TO COMPUTE CORE ENGINE GAIN.
C
      IDXFG1=1
      DO 1 I=2,5
      IF(ARG   .GE.FGIAA (I)) IDXFG1=I
    1 CONTINUE
      IDXFG2=IDXFG1+1
C
      RATOFG=(ARG   -FGIAA (IDXFG1))/(FGIAA (IDXFG2)-FGIAA (IDXFG1))
      RATFG1=1.0-RATOFG
C
      INDXD1=IDXFG1+ 6*((IDXHB1-1)+ 2*(IDXMC1-1))
      INDXD2=INDXD1+ 1
      INDXD3=INDXD1+ 6
      INDXD4=INDXD2+ 6
      INDXD5=INDXD1+12
      INDXD6=INDXD2+12
      INDXD7=INDXD3+12
      INDXD8=INDXD4+12
C
      GAINA1=RATOFG*FGIA  (INDXD2)+FGIA  (INDXD1)*RATFG1
      GAINA2=RATOFG*FGIA  (INDXD4)+FGIA  (INDXD3)*RATFG1
      GAINA3=RATOFG*FGIA  (INDXD6)+FGIA  (INDXD5)*RATFG1
      GAINA4=RATOFG*FGIA  (INDXD8)+FGIA  (INDXD7)*RATFG1
      GAINB1=RATOHB*GAINA2        +GAINA1        *RATHB1
      GAINB2=RATOHB*GAINA4        +GAINA3        *RATHB1
      ENGSDL=RATOMC*GAINB2        +GAINB1        *RATMC1
      RETURN
C
      ENTRY B07SDL(ARG)
C
C.... ENTRY TO COMPUTE AUGMENTOR MODEL NORMALIZED CHARACTERISTICS.
C
      IDXNC1=1
      DO 2 I=2,8
      IF(ARG   .GE.ANCA  (I)) IDXNC1=I
    2 CONTINUE
      IDXNC2=IDXNC1+1
C
      RATONC=(ARG   -ANCA  (IDXNC1))/(ANCA  (IDXNC2)-ANCA  (IDXNC1))
      RATNC1=1.0-RATONC
C
      INDXE1=IDXNC1+ 9*((IDXHB1-1)+ 2*(IDXMC1-1))
      INDXE2=INDXE1+ 1
      INDXE3=INDXE1+ 9
      INDXE4=INDXE2+ 9
      INDXE5=INDXE1+18
      INDXE6=INDXE2+18
      INDXE7=INDXE3+18
      INDXE8=INDXE4+18
      ANCFA1=RATONC*ANCFA (INDXE2)+ANCFA (INDXE1)*RATNC1
      ANCFA2=RATONC*ANCFA (INDXE4)+ANCFA (INDXE3)*RATNC1
      ANCFA3=RATONC*ANCFA (INDXE6)+ANCFA (INDXE5)*RATNC1
      ANCFA4=RATONC*ANCFA (INDXE8)+ANCFA (INDXE7)*RATNC1
      ANCFB1=RATOHB*ANCFA2        +ANCFA1        *RATHB1
      ANCFB2=RATOHB*ANCFA4        +ANCFA3        *RATHB1
      ENGSDL=RATOMC*ANCFB2        +ANCFB1        *RATMC1
C
      RETURN
      END
