C
      SUBROUTINE ENGDIN
C
C.... ROUTINE TO READ IN ENGINE DATA FOR ENGINE MODEL.
C
C.... WRITTEN AUG. 1, 1978
C     LEE DUKE NASA DFRC
C
c     INCLUDE 'include.h'
      INCLUDE 'ingdat.h'
      REAL  C03RTN,C03RTP,C05F1K,C06LMN,C06LMP,B02LMN,B02LMP,
     .      B03RTN,B03RTP,B04F1K,B06F1E,B06F1K
      REAL  C03DAT(8),C07DAT(24),B03DAT(8),B07DAT(36),
     .      FIDLAX(108),FMILAX(168),FMAXAX(168),
     .      TIDLA(108),TMILA(168),TMAXA(168),
     .      FIDLA(108),FMILA(168),FMAXA(168)
      REAL  FUEL,FLOW,D,SINETA,COSETA
      LOGICAL FOUT,NOWC
      REAL G060
      REAL C05F1C, B04F1C, B06F1C
      INTEGER I
C
      COMMON /ENGVAR/ C03RTN,C03RTP,C05F1K,C06LMN,C06LMP,B02LMN,B02LMP,
     .                B03RTN,B03RTP,B04F1K,B06F1E,B06F1K
      COMMON /ENGTAB/ C03DAT(8),C07DAT(24),B03DAT(8),B07DAT(36),
     .                FIDLAX(108),FMILAX(168),FMAXAX(168),
     .                TIDLA(108),TMILA(168),TMAXA(168),
     .                FIDLA(108),FMILA(168),FMAXA(168)
      COMMON /ENGINF/ FUEL,FLOW,D,FOUT,NOWC,SINETA,COSETA
C
      DATA G060   /115826.4/
C
C
      SINETA=0.0
      COSETA=1.0
      FOUT = .FALSE.
      NOWC = .TRUE.
C
C.... READ ENGINE DATA
C
      OPEN (1, FILE='ENGINE.DAT', STATUS='OLD')
C                                  
C.... CORE ENGINE MODEL PARAMETERS.
C                                  
  101 FORMAT(20A4)                 
  102 FORMAT(7F10.0)               
      READ(1,101)                  
      READ(1,101)                  
      READ(1,102) C03DAT           
      READ(1,101)                  
      READ(1,105) C07DAT           
  105 FORMAT(6F10.0)               
C                                  
C.... AUGMENTOR MODEL PARAMETERS.  
C                                  
      READ(1,101)                  
      READ(1,102) B03DAT           
      READ(1,101)                  
      READ(1,201) B07DAT           
  201 FORMAT(7F10.0,/,2F10.0)      
C                                  
C.... THRUST AND FUEL FLOW PARAMETERS. 
C                                      
      READ(1,101)                      
      READ(1,201) TIDLA                
      READ(1,101)                      
      READ(1,201) FIDLAX               
C                                      
      READ(1,101)                      
      READ(1,401) TMILA                
  401 FORMAT(7F10.0)                   
      READ(1,101)                      
      READ(1,401) FMILAX               
      READ(1,101)                      
      READ(1,401) TMAXA                
      READ(1,101)                      
      READ(1,401) FMAXAX               
C                                      
      DO 1 I=1,108                     
      FIDLAX(I) = FIDLAX(I)/G060       
    1 CONTINUE                         
      DO 2 I=1,168                     
      FMILAX(I)=FMILAX(I)/G060         
      FMAXAX(I)=FMAXAX(I)/G060         
    2 CONTINUE                         
C
      CLOSE (1)
C
C.... DEFINE CONSTANTS.
C
      C05F1C=        1.0
      C06LMN=        0.0
      C06LMP=        1.0
      B02LMN=       -0.02
      B02LMP=        0.02
      B04F1C=        1.0
      B06F1C=       20.0
C
                    ENTRY ENGDN1
C
C
C.... CALCULATIONS DEPENDENT ON FRAME TIME.
C
      C05F1K=(C05F1C*HI)/2.0
      B04F1K=(B04F1C*HI)/2.0
      B06F1E=EXP(-B06F1C*HI)
      B06F1K=(1.0-B06F1E)/2.0
C
      DO 4 I=1,108
      FIDLA(I)=FIDLAX(I)
    4 CONTINUE
C
      DO 5 I=1,168
      FMILA(I)=FMILAX(I)
      FMAXA(I)=FMAXAX(I)
    5 CONTINUE
C
      RETURN
      END
