C
      SUBROUTINE DERIVC                                                         
C                                                                               
C.... THIS ROUTINE CALCULATES THE EQUATIONS OF MOTION, AND                      
C                                                                               
C.... THE VALUES OF LIFT, DRAG, QBAR, MOMENTS AND THE                           
C                                                                               
C.... VALUES OF THE INERTIA TENSOR                                              
C                                                                               
C.... WRITTEN SEPT. 15,1981                                                     
C     FRANK JONES NASA/DFRC                                                     
C                                                                               
C
      REAL T,      P,      Q,      R,    V,    ALP,    BTA, 
     .     THA,    PSI,    PHI,    H,    X,    Y,
     .     TDOT,   PDOT,   QDOT,   RDOT, VDOT, ALPDOT, BTADOT, 
     .     THADOT, PSIDOT, PHIDOT, HDOT, XDOT, YDOT

C
      REAL TANBTA, TANTHA
C
c     INCLUDE 'include.h'
      INCLUDE 'altfun.h'
      INCLUDE 'datain.h'
      INCLUDE 'drvout.h'
      INCLUDE 'simout.h'
      INCLUDE 'trigfn.h'
      INCLUDE 'lll003.h'
      INCLUDE 'lll015.h'
      INCLUDE 'lll019.h'
C
      EQUIVALENCE (T      , F( 1)),                                             
     .            (P      , F( 2)),(Q     , F( 3)),(R     , F( 4)),             
     .            (V      , F( 5)),(ALP   , F( 6)),(BTA   , F( 7)),             
     .            (THA    , F( 8)),(PSI   , F( 9)),(PHI   , F(10)),             
     .            (H      , F(11)),(X     , F(12)),(Y     , F(13)),             
     .            (TDOT   ,DF( 1)),                                             
     .            (PDOT   ,DF( 2)),(QDOT  ,DF( 3)),(RDOT  ,DF( 4)),             
     .            (VDOT   ,DF( 5)),(ALPDOT,DF( 6)),(BTADOT,DF( 7)),             
     .            (THADOT ,DF( 8)),(PSIDOT,DF( 9)),(PHIDOT,DF(10)),             
     .            (HDOT   ,DF(11)),(XDOT  ,DF(12)),(YDOT  ,DF(13))              
C                                                                               
C.... COMPUTE NECESSARY TRIG RELATIONSHIPS.                                     
C                                                                               
      SINALP=SIN(ALP)                                                          
      COSALP=COS(ALP)                                                          
      SINBTA=SIN(BTA)                                                          
      COSBTA=COS(BTA)                                                          
      SINPHI=SIN(PHI)                                                          
      COSPHI=COS(PHI)                                                          
      SINPSI=SIN(PSI)                                                          
      COSPSI=COS(PSI)                                                          
      SINTHA=SIN(THA)                                                          
      COSTHA=COS(THA)                                                          
C                                                                               
      TANBTA=SINBTA/COSBTA                                                      
      TANTHA=SINTHA/COSTHA                                                      
C
C.... SET TDOT
C
      TDOT  = 1.0
C                                                                               
C.... COMPUTE THE TRANSLATIONAL EQUATIONS OF MOTION                             
C                                                                               
      ALPDOT = ( 1.0 / ( AMSS * V * COSBTA ) ) *                                
     .         (-TLFT -                                                         
     .          FPX * SINALP +                                                  
     .          FPZ * COSALP +                                                  
     .          AMSS * G *                                                      
     .           (COSALP * COSTHA * COSPHI +                                    
     .            SINTHA * SINALP                           ) ) +               
     .       Q -                                                                
     .       TANBTA *                                                           
     .       ( P * COSALP +                                                     
     .         R * SINALP                                   )                   
C                                                                               
      BTADOT = ( 1.0 / ( AMSS * V ) ) *                                         
     .         ( DRAG * SINBTA +                                                
     .           SIDFOR  * COSBTA -                                             
     .           FPX * COSALP * SINBTA +                                        
     .           FPY * COSBTA -                                                 
     .           FPZ * SINALP * SINBTA +                                        
     .           AMSS * G *                                                     
     .           ( SINTHA * SINBTA * COSALP +                                   
     .             COSTHA * SINPHI * COSBTA -                                   
     .             COSTHA * COSPHI * SINALP * SINBTA       ) ) +                
     .       P * SINALP -                                                       
     .       R * COSALP                                                         
C                                                                               
      VDOT  =(1.0/AMSS)*                                                        
     .         ( -DRAG * COSBTA +                                               
     .           SIDFOR  * SINBTA +                                             
     .           FPX * COSALP * COSBTA +                                        
     .           FPY * SINBTA +                                                 
     .           FPZ * COSBTA * SINALP +                                        
     .           AMSS * G *                                                     
     .           ( -SINTHA * COSALP * COSBTA +                                  
     .             SINBTA * COSTHA * SINPHI +                                   
     .             COSPHI * SINALP * COSTHA * COSBTA               ))           
C                                                                               
C.... COMPUTE BODY AXIS VELOCITIES.                                             
C                                                                               
      UB    =V     *COSALP*COSBTA                                               
      VB    =V     *SINBTA                                                      
      WB    =V     *SINALP*COSBTA                                               
C                                                                               
C.... COMPUTE EARTH AXIS VELOCITIES.                                            
C                                                                               
      XDOT  =UB    * COSTHA*COSPSI                                              
     .      +VB    *(SINPHI*SINTHA*COSPSI-COSPHI*SINPSI)                        
     .      +WB    *(COSPHI*SINTHA*COSPSI+SINPHI*SINPSI)                        
C                                                                               
      YDOT  =UB    * COSTHA*SINPSI                                              
     .      +VB    *(SINPHI*SINTHA*SINPSI+COSPHI*COSPSI)                        
     .      +WB    *(COSPHI*SINTHA*SINPSI-SINPHI*COSPSI)                        
C                                                                               
      HDOT  =UB    * SINTHA                                                     
     .      -VB    * SINPHI*COSTHA                                              
     .      -WB    * COSPHI*COSTHA                                              
C                                                                               
C**** ROTATIONAL EQUATIONS.                                                     
C                                                                               
C                                                                               
C.... THIS SECTION CALCULATES THE VALUES OF THE J MATRIX                        
C                                                                               
      AJ1   =AIY*AIZ-AIYZ**2                                                    
      AJ2   =AIXY*AIZ+AIYZ*AIXZ                                                 
      AJ3   =AIXY*AIYZ+AIY *AIXZ                                                
      AJ4   =AIX *AIZ -AIXZ**2                                                  
      AJ5   =AIX *AIYZ+AIXY*AIXZ                                                
      AJ6   =AIX *AIY -AIXY**2                                                  
C                                                                               
      DX    =AIZ -AIY                                                           
      DY    =AIX -AIZ                                                           
      DZ    =AIY -AIX                                                           
C                                                                               
C.... THE DETERMINANT OF THE J MATRIX                                           
C                                                                               
      AJ    =AIX*AIY*AIZ-AIX*AIYZ**2-AIXY**2*AIZ-AIXZ**2                        
     .      *AIY-2.0*AIXY*AIXZ*AIYZ                                             
C                                                                               
C.... INCLUDE ENGINE ROTATIONAL EFFECTS                                         
C                                                                               
      ALM = ALM + DCL                                                           
      AMM = AMM + DCM                                                           
      ANM = ANM + DCN                                                           
C                                                                               
C.... CALCULATE QDOT, PDOT, AND RDOT                                            
C                                                                               
      QDOT  =(1.0/AJ)*                                                          
     .         ( ALM * AJ2 +                                                    
     .           AMM * AJ4 +                                                    
     .           ANM * AJ5 +                                                    
     .           P * * 2 *                                                      
     .           ( -AIXZ * AJ4 + AIXY * AJ5                 ) +                 
     .           P * Q *                                                        
     .           ( AIXZ * AJ2 - AIYZ * AJ4 - DZ * AJ5       ) +                 
     .           P * R *                                                        
     .           ( -AIXY * AJ2 - DY * AJ4 + AIYZ * AJ5      ) +                 
     .           Q * * 2 *                                                      
     .           ( AIYZ * AJ2 - AIXY * AJ5                  ) +                 
     .           Q * R *                                                        
     .           ( -DX * AJ2 + AIXY * AJ4 - AIXZ * AJ5      ) +                 
     .           R * * 2 *                                                      
     .           ( -AIYZ * AJ2 + AIXZ * AJ4                 ) )                 
C                                                                               
      RDOT  =(1.0/AJ)*                                                          
     .         ( ALM * AJ3 +                                                    
     .           AMM * AJ5 +                                                    
     .           ANM * AJ6 +                                                    
     .           P * * 2 *                                                      
     .           ( -AIXZ * AJ5 + AIXY * AJ6                 ) +                 
     .           P * Q *                                                        
     .           ( AIXZ * AJ3 - AIYZ * AJ5 - DZ * AJ6       ) +                 
     .           P * R *                                                        
     .           ( -AIXY * AJ3 - DY * AJ5 + AIYZ * AJ6      ) +                 
     .           Q * * 2 *                                                      
     .           ( AIYZ * AJ3 - AIXY * AJ6                  ) +                 
     .           Q * R *                                                        
     .           ( -DX * AJ3 + AIXY * AJ5 - AIXZ * AJ6      ) +                 
     .           R * * 2 *                                                      
     .           ( -AIYZ * AJ3 + AIXZ * AJ5                 ) )                 
C                                                                               
      PDOT  =(1.0/AJ)*                                                          
     .         ( ALM * AJ1 +                                                    
     .           AMM * AJ2 +                                                    
     .           ANM * AJ3 +                                                    
     .           P * * 2 *                                                      
     .           ( -AIXZ * AJ2 + AIXY * AJ3                 ) +                 
     .           P * Q *                                                        
     .           ( AIXZ * AJ1 - AIYZ * AJ2 - DZ * AJ3       ) +                 
     .           P * R *                                                        
     .           ( -AIXY * AJ1 - DY * AJ2 + AIYZ * AJ3      ) +                 
     .           Q * * 2 *                                                      
     .           ( AIYZ * AJ1 - AIXY * AJ3                  ) +                 
     .           Q * R *                                                        
     .           ( -DX * AJ1 + AIXY * AJ2 - AIXZ * AJ3      ) +                 
     .           R * * 2 *                                                      
     .           ( -AIYZ * AJ1 + AIXZ * AJ2                 ) )                 
C                                                                               
C.... DERIVATIVES OF EULER ANGLES.                                              
C                                                                               
      PHIDOT= P     +Q     *SINPHI*TANTHA+R     *COSPHI*TANTHA                  
C                                                                               
      THADOT= Q     *COSPHI-R     *SINPHI                                       
C                                                                               
      PSIDOT=(Q     *SINPHI+R     *COSPHI)      /COSTHA                         
C
C                                                                               
      RETURN                                                                    
      END                                                                       
