C
      SUBROUTINE CCALC                                                          
C                                                                               
C.... ROUTINE TO COMPUTE AERODYNAMIC FORCE AND MOMENT COEFFICIENTS              
C                                                                               
C.... WRITTEN JUNE 16,1978                                                      
C     LEE DUKE NASA/DFRC                                                        
C.... MODIFIED OCTOBER, 1990  (CLEAN-UP, ADD VAR DECL)
C     RANDY BRUMBAUGH  PRC
C.... BUG FIXES 12/21/90  RWB
C                                                                               
      LOGICAL LATEST                                                            
C
      REAL T,      P,      Q,      R,    V,    ALP,    BTA, 
     .     THA,    PSI,    PHI,    H,    X,    Y,
     .     TDOT,   PDOT,   QDOT,   RDOT, VDOT, ALPDOT, BTADOT, 
     .     THADOT, PSIDOT, PHIDOT, HDOT, XDOT, YDOT
      REAL PLA, ANZC
      REAL CDNOZK, CDX
      REAL CLB
      REAL CNB
      REAL CYB
      REAL DCDALT
      REAL DA, DH, DT, DR, DSB
      REAL B2V, CB2V
      REAL ALP1, ALP2, ALPD, BTAD
      REAL WBDOT, DSB45
C
c     INCLUDE 'zzcom.h'
      INCLUDE 'fmcoef.h'
C
c     INCLUDE 'include.h'
      INCLUDE 'altfun.h'
      INCLUDE 'datain.h'
      INCLUDE 'clcout.h'
      INCLUDE 'contrl.h'
      INCLUDE 'ctparm.h'
      INCLUDE 'drvout.h'
      INCLUDE 'simout.h'
      INCLUDE 'trigfn.h'
      INCLUDE 'parameter.h'
C
C  DELETED (PLA, DC(12) ), 12/21/90  RWB
      EQUIVALENCE (DA,  DC( 1) ), (DH,    DC( 5) ), (DT,    DC( 8) ), 
     .            (DR,  DC( 9) ), (DSB, DC(10) )
C
      EQUIVALENCE(T     , F( 1)),                                               
     .           (P     , F( 2)),(Q     , F( 3)),(R     , F( 4)),               
     .           (V     , F( 5)),(ALP   , F( 6)),(BTA   , F( 7)),               
     .           (THA   , F( 8)),(PSI   , F( 9)),(PHI   , F(10)),               
     .           (H     , F(11)),(X     , F(12)),(Y     , F(13)),               
     .           (TDOT  ,DF( 1)),                                               
     .           (PDOT  ,DF( 2)),(QDOT  ,DF( 3)),(RDOT  ,DF( 4)),               
     .           (VDOT  ,DF( 5)),(ALPDOT,DF( 6)),(BTADOT,DF( 7)),               
     .           (THADOT,DF( 8)),(PSIDOT,DF( 9)),(PHIDOT,DF(10)),               
     .           (HDOT  ,DF(11)),(XDOT  ,DF(12)),(YDOT  ,DF(13))                
      DATA ANZC    /-1.00000/                                                   
C                                                                               
C                                                                               
C.... TEMPORARY FIX FOR SURFACES IN RADIANS.                                    
C                                                                               
      DA    =DA    *DGR                                                         
      DH    =DH    *DGR                                                         
      DT    =DT    *DGR                                                         
      DR    =DR    *DGR                                                         
      DSB   =DSB   *DGR
C
C  ADDED DSB45 AND PLA INITS, 12/21/90 RWB
      DSB45 = 0.0
C  PLA IS AVERAGE OF ENGINE THROTTLE SETTINGS
      PLA = ( THRSTX(1) + THRSTX(2) )/2
C
      ALPD  =ALP*DGR                                                            
      BTAD  =BTA*DGR 
C
      B2V   =B/(2.0*V)                                                          
      CB2V  =CBAR/(2.0*V)                                                       
      COSBTA=COS(BTA)
      SINBTA=SIN(BTA)
C                                                                               
      ALP1  =ALPD                                                               
      IF(ALP1.LT. 0.0) ALP1= 0.0                                                
      IF(ALP1.GT.10.0) ALP1=10.0                                                
      ALP2  =ALPD                                                               
      IF(ALPD.LT.10.0) ALP2=10.0                                                
      LATEST=.FALSE.                                                            
      IF((ALPD.GE.25.0) .AND.                                                   
     .   (ABS(BTAD).LE.10.0).AND.                                               
     .   (AMCH.LE.0.6)) LATEST=.TRUE.                                           
      DCDALT=0.0005/10000.0*(30000.0-H)                                         
      CDNOZK=1.0                                                                
      IF(PLA.GT.83.0) CDNOZK=0.0                                                
C                                                                               
C                                                                               
C.... DO TABLE LOOK-UP.                                                         
C                                                                               
      CALL TLU                                                                  
C                                                                               
C.... DETERMINE TERMS TO BE USED IN FORCE AND MOMENT EQUATIONS.                 
C                                                                               
      CYB   =CYB1                                                               
      IF(LATEST) CYB=CYB2                                                       
      CLB   =CLB1                                                               
      IF(LATEST.AND.(PLA.LT.35.0)) CLB=CLB2                                     
      CNB   =CNB1                                                               
      IF(LATEST) CNB=CNB2                                                       
C                                                                               
C.... ESTIMATE ANZ FOR AERODYNAMIC EQUATIONS.                                   
C                                                                               
      UB    =V     *COSALP*COSBTA                                               
      VB    =V     *SINBTA                                                      
C                                                                               
      WBDOT =VDOT  *SINALP*COSBTA                                               
     .      +V     *COSALP*COSBTA*ALPDOT                                        
     .      -V     *SINALP*SINBTA*BTADOT                                        
C                                                                               
      ANZC   =(WBDOT -Q *UB +P *VB -G *COSTHA*COSPHI)/G0                        
C                                                                               
C.... COMPUTE AERODYNAMIC FORCE AND MOMENT COEFFICIENTS.                        
C                
C.. RWB ADDED 0.95                                                              
      CLFT  =0.95*CLFTB+DCLNZ*ANZC+
     .       DSB45*(DCL0+DCLA1*ALP1+DCLA2*(ALP2-10.0))
      CY    =CYB+CYDA*DA+CYDD*DT-DCYDR*DRYK                                     
      CL    =CLB+CLDA*DA+CLDD*DT-DCLDR*DRLK+B2V*(CLP*P+CLR*R)                   
     .      +DCLSB*DSB45                                                        
C                                                                               
      CDX   =CDB                                                                
      IF(ALPD.GT.32.0) CDX=CLFTB*SINALP/COSALP                                  
      IF((ALPD.LT.40.0).AND.(ALPD.GT.32.0))                                     
     .              CDX=(CDX-CDB)/8.0*(ALPD-32.0)+CDB                           
C.. RWB ADDED 1.02
      CD    =1.02*CDX+DCDALT+DCDNOZ*CDNOZK+DSB45*DCDSB                               
C                                                                               
C.... CALCULATES ALPHADOT FOR PITCHING MOMENT                                   
C                                                                               
C                                                                               
      CM    =CMB+DCMNZ*ANZC+CB2V*(CMQ*Q+CMAD*ALPDOT)+CLFTB*DN0                  
     .      +DSB45*(DCM0+DN0SB*CLFTB)                                           
C                                                                               
      CN    =CNB+CNDA*DA+CNDD*DT+CNDR*DR*DRNK+B2V*(CNP*P+CNR*R)                 
     .      +DCNSB*DSB45                                                        
C                                                                               
C.... TEMPORARY FIX FOR SURFACES IN RADIANS.                                    
C                                                                               
      DA    =DA    /DGR                                                         
      DH    =DH    /DGR                                                         
      DT    =DT    /DGR                                                         
      DR    =DR    /DGR                                                         
      DSB   =DSB   /DGR                                                         
C                                                                               
      RETURN                                                                    
      END                                                                       
