#include "arithmetic.h"
#include <double.Matrix.h>
#define matrix doubleMatrix
#define array  doubleArray

inline	double limit(double x) {
  return (x < -1.0) ? -1.0 : (x < +1.0) ? x : +1.0;
  }

extern	struct	{ double	hi, hi2; }			ingdat_;
#define	HI     ingdat_.hi
#define	HI2    ingdat_.hi2
const	double	DGR	= 180.0/M_PI;

//		ALTITUDE AUTOPILOT
const	double	KH	= 200.0;
const	double	KHDOT	=  50.0;
const	double	KH1	=   5.0*KHDOT/KH;
const	double	KH2	=   0.008*KH/20.0;
const	double	KH3	=   0.002*KH/20.0;
const	double	KH4	=   1.0*20.0/DGR;
const	double	IHSTA0	=   5.0/20.0;

inline	double	nodeh2(double H, double HSET, double HDOT) {
  return limit(limit((H - HSET)/KH) + KH1*limit(HDOT/KHDOT));
  }

inline	double	de(double NH2OLD, double NODEH2, double DE) {
  return - KH4*IHSTA0 + KH4*KH2*NODEH2
	 + KH4*limit(IHSTA0 + KH3*HI2*NODEH2
	 + (KH3*HI2 - KH2)*NH2OLD + DE/KH4);
  }

//		AIRSPEED AUTOPILOT
const	double	KV	= 250.0;
const	double	KVD	=   0.00500*KV*2.0;
const	double	KVI	=   0.00008*KV*2.0;
const	double	KV3	=   0.0/KV;
const	double	KV4	=   107.0/2.0;
const	double	IVSTA0	=  -1.0;

inline	double	nodev2(double V, double VSET, double VDOT) {
  return limit((VSET - V)/KV) - KV3*VDOT;
  }
inline	double	thrstx(double NV2OLD, double NODEV2, double THRSTX) {
  return   20.0 - KV4*IVSTA0 + KV4*KVD*NODEV2
		+ KV4*limit(IVSTA0 - 20.0/KV4 + KVI*HI2*NODEV2
		+ (KVI*HI2 - KVD)*NV2OLD + THRSTX/KV4);
  }

//		BANK ANGLE AUTOPILOT
const	double	KPHI1	= 1.8;
const	double	KPHI2	= 0.2;
const	double	KPHI3	= 1.0;
const	double	KPHI4	= 0.6;

inline	double	nodep1(double PHI, double PHISET, double P) {
  return -KPHI2*(PHI - PHISET + KPHI1*P);
  }

inline	double	dt(double NODEP1) {
  return  KPHI3*NODEP1;
  }

inline	double	da(double NODEP1) {
  return  KPHI4*NODEP1;
  }

//		SIDE SLIP  AUTOPILOT
const	double	KR1	= -5.0;
const	double	KR2	= 0.05;

inline	double	dr(double BTA, double R) {
  return  KR2*(BTA - KR1*R);
  }

extern	struct	{ doublereal	f[13], df[13], u[5]; }		drvinp_;
extern	struct	{ double	fic[13], dfic[13]; }		setics_;

doublereal	*const	F	= drvinp_.f     -1;
doublereal	*const	DF	= drvinp_.df    -1;
double    	*const	FIC	= setics_.fic   -1;

#define   T     F[ 1][0]
#define   P     F[ 2][0]
#define   R     F[ 4][0]
#define   V     F[ 5][0]
#define BTA     F[ 7][0]
#define PHI     F[10][0]
#define   H     F[11][0]

#define   VDOT DF[ 5][0]
#define   HDOT DF[11][0]

static	double	NH2OLD	 = 0.0;
static	double	NV2OLD	 = 0.0;
extern	array	u;
void control(void) {
//double PHISET	 = FIC[10];
  double PHISET	 = FIC[10] +    0.1*sin(0.020*T*M_PI);
  double NODEP1	 = nodep1(PHI, PHISET, P);
  u[0][0]	 = da(NODEP1);
//double   HSET	 = FIC[11];
  double   HSET	 = FIC[11] + 1250.0*sin(0.010*T*M_PI);
  double NODEH2	 = nodeh2(H, HSET, HDOT);
  u[1][0]	 = de(NH2OLD, NODEH2, u[1][0]);
  NH2OLD	 = NODEH2;
  u[2][0]	 = dt(NODEP1);
  u[3][0]	 = dr(BTA, R);
//double   VSET	 = FIC[ 5];
  double   VSET	 = FIC[ 5] +  125.0*sin(0.005*T*M_PI);
  double NODEV2	 = nodev2(V, VSET, VDOT);
  u[4][0]	 = thrstx(NV2OLD, NODEV2, u[4][0]);
  NV2OLD	 = NODEV2;
  return;
  }
