/* cgcalc.f -- translated by f2c (version of 22 July 1992  22:54:52).
   You must link the resulting object file with the libraries:
	-lF77 -lI77 -lm -lc   (in that order)
*/

#ifdef __cplusplus
//extern "C" {
#endif
#include "f2c.h"

/* Common Block Declarations */

Extern struct {
    doublereal f[13], df[13];
} drvout_;

#define drvout_1 drvout_

Extern struct {
    doublereal amch, qbar, gma, del, ub, vb, wb, veas, vcas;
} simout_;

#define simout_1 simout_

Extern struct {
    double s, b, cbar, amss, aix, aiy, aiz, aixz, aixy, aiyz, aixe;
} datain_;

#define datain_1 datain_

Extern struct {
    doublereal cl, cm, cn, cd, clft, cy;
} clcout_;

#define clcout_1 clcout_

Extern struct {
    doublereal sinalp, cosalp, sinbta, cosbta, sinphi, cosphi, sinpsi, cospsi,
	     sintha, costha;
} trigfn_;

#define trigfn_1 trigfn_

Extern struct {
    double delx, dely, delz;
} cgshft_;

#define cgshft_1 cgshft_

Extern struct {
    logical cgset;
} lll006_;

#define lll006_1 lll006_

Extern struct {
    doublereal tlft, drag, sidfor, alm, amm, anm;
} lll019_;

#define lll019_1 lll019_

/* Subroutine */ int cgcalc_()
{
    extern /* Subroutine */ int ccalc_();

    /* Local variables */
    static doublereal fx, fy, fz, qs;
#define alp ((doublereal *)&drvout_1 + 5)
    static doublereal deltl, deltm, deltn;


/* .... ROUTINE TO CORRECT FORCE AND MOMENT COEFFICIENTS FROM THE */
/*     REFERENCE POINT OF THE BASIC AERODYNAMIC MODEL TO THE */
/*     VEHICLE CENTER OF GRAVITY AND TO COMPUTE THE AERODYNAMIC */
/*     FORCES AND MOMENTS. */

/* .... WRITTEN MAY 12, 1981 */
/*     LEE DUKE NASA/DFRC */


/*     INCLUDE 'include.h' */
/*     cgcalc and datinp only */
/*     ccalc, cgcalc, datinp, derivc and instrm only */
/*     cgcalc and datinp only */


/* .... COMPUTE TRIGONOMETRIC FUNCTIONS FOR AXIS TRANSFORMATION. */


    trigfn_1.cosalp = cos(*alp);
    trigfn_1.sinalp = sin(*alp);

/* .... COMPUTE THE AERODYNAMIC FORCE AND MOMENT COEFFICIENTS */

    ccalc_();

/* .... CALCULATE MOMENT TERMS */

    lll019_1.alm = simout_1.qbar * datain_1.s * datain_1.b * clcout_1.cl;
    lll019_1.amm = simout_1.qbar * datain_1.s * datain_1.cbar * clcout_1.cm;
    lll019_1.anm = simout_1.qbar * datain_1.s * datain_1.b * clcout_1.cn;

/* .... COMPUTE FORCES */

    qs = simout_1.qbar * datain_1.s;

    lll019_1.tlft = qs * clcout_1.clft;
    lll019_1.drag = qs * clcout_1.cd;
    lll019_1.sidfor = qs * clcout_1.cy;

/* .... DETERMINES WHETHER TO CALCULATE FORCE AND MOMENT */
/*     CORRECTIONS */

    if (! lll006_1.cgset) {
	return 0;
    }

/* .... COMPUTE BODY AXIS FORCE COEFFICIENTS. */

    fx = -clcout_1.cd * trigfn_1.cosalp + clcout_1.clft * trigfn_1.sinalp;
    fy = clcout_1.cy;
    fz = -clcout_1.cd * trigfn_1.sinalp - clcout_1.clft * trigfn_1.cosalp;

/* .... COMPUTE MOMENTS INDUCED BY CHANGE OF REFERENCE. */

    deltl = (fz * cgshft_1.dely - fy * cgshft_1.delz) / datain_1.b;
    deltm = (fx * cgshft_1.delz - fz * cgshft_1.delx) / datain_1.cbar;
    deltn = (fy * cgshft_1.delx - fx * cgshft_1.dely) / datain_1.b;

/* .... CORRECT MOMENT COEFFICIENTS. */

    clcout_1.cl += deltl;
    clcout_1.cm += deltm;
    clcout_1.cn += deltn;

/* .... CALCULATE MOMENT TERMS */

    lll019_1.alm = simout_1.qbar * datain_1.s * datain_1.b * clcout_1.cl;
    lll019_1.amm = simout_1.qbar * datain_1.s * datain_1.cbar * clcout_1.cm;
    lll019_1.anm = simout_1.qbar * datain_1.s * datain_1.b * clcout_1.cn;

    return 0;
} /* cgcalc_ */

#undef alp


#ifdef __cplusplus
//	}
#endif
