C
      SUBROUTINE UCNTRL(HSET, VSET, PHISET)
      REAL HSET, VSET, PHISET
C
C..  INCLUDE COMMON BLOCKS
c     INCLUDE 'include.h'
      INCLUDE 'contrl.h'
      INCLUDE 'ctparm.h'
      INCLUDE 'drvout.h'
      INCLUDE 'ingdat.h'
      INCLUDE 'parameter.h'
C
C..  GAINS FOR H AUTOPILOT
      REAL KH1, KH2, KH3, KH4
C..  GAINS FOR V AP
      REAL KVD, KVI, KV3
C..  GAINS FOR PHI AP
      REAL KPHI1, KPHI2, KPHI3, KPHI4
C..  GAINS FOR ROLL DIR AP
      REAL KR1, KR2
C
C..  INTG STATE AND LIMITS FOR H AP
      REAL IHSTA, IHTOP, IHBOT
C..  INTG STATE AND LIMITS FOR V AP
      REAL IVSTA, IVTOP, IVBOT
C..  NODE VARS
      REAL NODEH1, NODEH2, NODEH3, NODEV1, NODEV2
      REAL NODEP1, NODER1
      REAL NH2OLD, NV2OLD
C..  HDOT IN LIMIT
      REAL HDOTIN
C
C..  SET K'S
      KH1 = 5.0
      KH2 = 0.008
      KH3 = 0.002
      KH4 = 1.0
      KVD = 0.005
      KVI = 0.00008
      KV3 = 0.0
      KPHI1 = 1.8
      KPHI2 = 0.2
      KPHI3 = 1.0
      KPHI4 = 0.6
      KR1 = -5.0
      KR2 = 0.05
C
C..  SET INTEGRATOR LIMITS
      IHTOP = 15.0
      IHBOT = -25.0
C
      IVTOP = 1.0
      IVBOT = 0.0
C
C..  DO THE AP FOR H
      NODEH1 = F(11) - HSET
C
C..  LIMIT ERROR OUT
      IF (NODEH1 .GT.  200.0) NODEH1 =  200.0
      IF (NODEH1 .LT. -200.0) NODEH1 = -200.0
C
C..  LIMIT HDOT INPUT
      HDOTIN = DF(11)
      IF (HDOTIN .GT.  50.0) HDOTIN =  50.0
      IF (HDOTIN .LT. -50.0) HDOTIN = -50.0
C
C..  SAVE FOR INTG UPDATE
      NH2OLD = NODEH2
      NODEH2 = NODEH1 + KH1* HDOTIN
C
C..  LIMITER
c     IF (NODEH2 .GT.  200.0) HDOTIN =  200.0
c     IF (NODEH2 .LT. -200.0) HDOTIN = -200.0
      IF (NODEH2 .GT.  200.0) NODEH2 =  200.0
      IF (NODEH2 .LT. -200.0) NODEH2 = -200.0
C
C..  UPDATE H INTEGRATOR
      IHSTA = IHSTA + KH3 * HI2 * (NODEH2 + NH2OLD)
      IF (IHSTA .GT. IHTOP) IHSTA = IHTOP
      IF (IHSTA .LT. IHBOT) IHSTA = IHBOT
C
      NODEH3 = KH2*NODEH2 + IHSTA
      DC(5) = (KH4 * NODEH3) / DGR
C
C*************************************************
C
C..  DO THE AP FOR V
      NODEV1 = VSET - F(5)
      IF (NODEV1 .GT. 250.0) NODEV1 = 250.0
      IF (NODEV1 .LT. -250.0) NODEV1 = -250.0
C
C..  SUM IN VDOT
      NV2OLD = NODEV2
      NODEV2 = NODEV1 - KV3 * DF(5)
C
C..  UPDATE V INTEGRATOR
      IVSTA = IVSTA + KVI * HI2 * (NODEV2 + NV2OLD)
      IF (IVSTA .GT. IVTOP) IVSTA = IVTOP
      IF (IVSTA .LT. IVBOT) IVSTA = IVBOT
C
      THRSTX(1) = (107.0 * (NODEV2 * KVD + IVSTA)) + 20.0
      THRSTX(2) = (107.0 * (NODEV2 * KVD + IVSTA)) + 20.0
C
C**************************************************
C
C.. DO THE ROLL AP
      NODEP1 = F(10) - PHISET + KPHI1 * F(2)
      DC(8) = -1.0 * (KPHI2 * KPHI3 * NODEP1)
      DC(1) = -1.0 * (KPHI2 * KPHI4 * NODEP1)
C
C
C**************************************************
C
C..  DO THE BETA AP
      NODER1 = F(7) - KR1 * F(4)
      DC(9) = KR2 * NODER1
C
      RETURN
C
      END


