C
      SUBROUTINE INSTRM                                                         
C                                                                               
C.... ROUTINE TO COMPUTE PARAMETERS NORMAL SENSED BY ONBOARD                    
C     INSTRUMENTATION                                                           
C                                                                               
C.... WRITTEN MARCH 18, 1982                                                    
C     LEE DUKE NASA/DFRF                                                        
C                                                                               
C
      INTEGER I
C
      REAL T,      P,      Q,      R,    V,    ALP,    BTA, 
     .     THA,    PSI,    PHI,    H,    X,    Y,
     .     TDOT,   PDOT,   QDOT,   RDOT, VDOT, ALPDOT, BTADOT, 
     .     THADOT, PSIDOT, PHIDOT, HDOT, XDOT, YDOT
      REAL GM, G0M, HDOTDT ,D180, D360
      REAL XB, YB, ZB, UBDOT, VBDOT, WBDOT
C     
c     INCLUDE 'include.h'
      INCLUDE 'altfun.h'
      INCLUDE 'contrl.h'
      INCLUDE 'ctparm.h'
      INCLUDE 'datain.h'
      INCLUDE 'drvout.h'
      INCLUDE 'observ.h'
      INCLUDE 'simacc.h'
      INCLUDE 'simout.h'
      INCLUDE 'trigfn.h'
      INCLUDE 'lll015.h'
      INCLUDE 'lll019.h'
      INCLUDE 'lll021.h'
      INCLUDE 'lll028.h'
      INCLUDE 'lll032.h'
      INCLUDE 'parameter.h'
C                                                                               
      EQUIVALENCE (T      , F( 1)),                                             
     .            (P      , F( 2)),(Q     , F( 3)),(R     , F( 4)),             
     .            (V      , F( 5)),(ALP   , F( 6)),(BTA   , F( 7)),             
     .            (THA    , F( 8)),(PSI   , F( 9)),(PHI   , F(10)),             
     .            (H      , F(11)),(X     , F(12)),(Y     , F(13)),             
     .            (TDOT   ,DF( 1)),                                             
     .            (PDOT   ,DF( 2)),(QDOT  ,DF( 3)),(RDOT  ,DF( 4)),             
     .            (VDOT   ,DF( 5)),(ALPDOT,DF( 6)),(BTADOT,DF( 7)),             
     .            (THADOT ,DF( 8)),(PSIDOT,DF( 9)),(PHIDOT,DF(10)),             
     .            (HDOT   ,DF(11)),(XDOT  ,DF(12)),(YDOT  ,DF(13))              
C                                                                               
      DATA D180   /  3.14159/
      DATA D360   /  6.28308/
C
C.... LIMIT STATE VARIABLES
C
      IF( THA .GE.  D180) THA   = THA  - D360
      IF( THA .LT. -D180) THA   = THA  + D360   
      IF( PHI .GE.  D180) PHI   = PHI  - D360
      IF( PHI .LT. -D180) PHI   = PHI  + D360   
      IF( PSI .GE.  D360) PSI   = PSI  - D360
      IF( PSI .LT.  0.0 ) PSI   = PSI  + D360   
C                                                                               
C.... COMPUTE NECESSRY TRIG RELATIONS                                           
C                                                                               
      SINALP=SIN(ALP)                                                          
      COSALP=COS(ALP)                                                          
      SINBTA=SIN(BTA)                                                          
      COSBTA=COS(BTA)                                                          
      SINPHI=SIN(PHI)                                                          
      COSPHI=COS(PHI)                                                          
      SINPSI=SIN(PSI)                                                          
      COSPSI=COS(PSI)                                                          
      SINTHA=SIN(THA)                                                          
      COSTHA=COS(THA)                                                          
C                                                                               
C.... COMPUTE BODY AXIS VELOCITIES.                                             
C                                                                               
      UB    =V     *COSALP*COSBTA                                               
      VB    =V     *SINBTA                                                      
      WB    =V     *SINALP*COSBTA                                               
C                                                                               
C.... COMPUTE WEIGHT TERMS USED IN EQUATIONS.                                   
C                                                                               
      GM    =AMSS  *G                                                           
      G0M   =AMSS  *G0                                                          
C                                                                               
C.... COMPUTE LOAD FACTOR                                                       
C                                                                               
      ALOADF = TLFT / ( AMSS * G )                                              
C                                                                               
C.... COMPUTE BODY AXIS FORCES.                                                 
C                                                                               
      XB    = FPX   -GM    *SINTHA       -DRAG  *COSALP+TLFT  *SINALP           
      YB    = FPY   +GM    *COSTHA*SINPHI+SIDFOR                                
      ZB    = FPZ   +GM    *COSTHA*COSPHI-DRAG  *SINALP-TLFT  *COSALP           
C                                                                               
C.... COMPUTE BODY AXIS VELOCITY RATES (FT/SEC**2).                             
C                                                                               
      UBDOT = XB / AMSS + R * VB - Q * WB                                       
      VBDOT = YB / AMSS + P * WB - R * UB                                       
      WBDOT = ZB / AMSS + Q * UB - P * VB                                       
C                                                                               
C.... BODY AXIS ACCELERATIONS (G'S).                                            
C                                                                               
      AX    = XB / G0M                                                          
      AY    = YB / G0M                                                          
      AZ    = ZB / G0M                                                          
C                                                                               
C.... COMPUTE BODY AXIS C.G. ACCELEROMETER OUTPUTS.                             
C                                                                               
      ANX   = AX    +SINTHA*G            /G0                                    
      ANY   = AY    -COSTHA*SINPHI*G     /G0                                    
      ANZ   = AZ    -COSTHA*COSPHI*G     /G0                                    
C                                                                               
C.... COMPUTE NORMAL ACCELERATION - - -                                         
C     POSITIVE UP/ +1 G FOR STRAIGHT AND LEVEL FLIGHT.                          
C                                                                               
      AN    =-ANZ                                                               
C                                                                               
C.... COMPUTE ALTITUDE ACCELERATION.                                            
C                                                                               
      HDOTDT=AX    *SINTHA-AY    *SINPHI*COSTHA                                 
     .      -AZ    *COSPHI*COSTHA                                               
C                                                                               
C**** COMPUTE TERMS FOR THE OBSERVATION VECTOR.                                 
C                                                                               
C     LOCATION OF TERMS IS DEFINED IN ROUTINE OBSCHK.                           
C                                                                               
C.... ENTER STATE VARIABLES.                                                    
C                                                                               
      DO 1 I=1,12                                                               
      OBSVEC(I)=F(I+1)                                                          
    1 CONTINUE                                                                  
C                                                                               
C.... ENTER ACCELEROMETER TERMS.                                                
C                                                                               
      OBSVEC(25)=AX                                                             
      OBSVEC(26)=AY                                                             
      OBSVEC(27)=AZ                                                             
C                                                                               
      OBSVEC(28)=ANX                                                            
      OBSVEC(29)=ANY                                                            
      OBSVEC(30)=ANZ                                                            
      OBSVEC(31)=AN                                                             
      OBSVEC(98)=ALOADF                                                         
C                                                                               
C.... BODY AXIS VELOCITY RATES.                                                 
C                                                                               
      OBSVEC(100)=UBDOT                                                         
      OBSVEC(101)=VBDOT                                                         
      OBSVEC(102)=WBDOT                                                         
C                                                                               
C.... ENTER AIR DATA TERMS.                                                     
C                                                                               
      OBSVEC(35)=AMCH                                                           
      OBSVEC(36)=QBAR                                                           
      OBSVEC(103)=RHO * V / VMU                                                 
      IF (VARPOS(37,1).EQ.0.0) VARPOS(37,1)=CBAR                                
      OBSVEC(37)=OBSVEC(103)*VARPOS(37,1)                                       
      OBSVEC(55)=PA                                                             
      OBSVEC(56)=QC                                                             
      OBSVEC(57)=QC/PA                                                          
      OBSVEC(58)=PA+QC                                                          
      OBSVEC(59)=TMPR                                                           
      OBSVEC(60)=TMPR *( 1.0 + 0.2 *AMCH**2)                                    
      OBSVEC(91)=A                                                              
      OBSVEC(92)=VEAS                                                           
      OBSVEC(93)=VCAS                                                           
C                                                                               
C.... FLIGHT PATH TERMS.                                                        
C                                                                               
      OBSVEC(41)=H     +VARPOS(41, 1)*SINTHA                                    
     .                 -VARPOS(41, 2)*SINPHI*COSTHA                             
     .                 -VARPOS(41, 3)*COSPHI*COSTHA                             
      OBSVEC(42)=HDOT  +THADOT       *                                          
     .                 (VARPOS(42, 1)*COSTHA                                    
     .                 +VARPOS(42, 2)*SINPHI*SINTHA                             
     .                 +VARPOS(42, 3)*COSPHI*SINTHA)                            
     .                 -PHIDOT       *                                          
     .                 (VARPOS(42, 2)*COSPHI*COSTHA                             
     .                 -VARPOS(42, 3)*SINPHI*COSTHA)                            
      OBSVEC(50)=HDOTDT                                                         
C                                                                               
C.... ANGLE OF ATTACK AND BETA INSTRUMENTS NOT AT C.G.                          
C                                                                               
      OBSVEC(44)=ALP   -(Q     *VARPOS(44, 1)                                   
     .                  -P     *VARPOS(44, 2))/V                                
      OBSVEC(45)=BTA   +(R     *VARPOS(45, 1)                                   
     .                  -P     *VARPOS(45, 3))/V                                
C                                                                               
C.... ENERGY TERMS.                                                             
C                                                                               
      OBSVEC(47)=H     +V     *V     /(2.0   *G     )                           
C                                                                               
C.... TOTAL ANGULAR MOMENTUM                                                    
C                                                                               
      OBSVEC(48)= 0.5  *(AIX   *P     *P                                        
     .          - 2.0  * AIXY  *P     *Q                                        
     .          - 2.0  * AIXZ  *P     *R                                        
     .          +        AIY   *Q     *Q                                        
     .          - 2.0  * AIYZ  *Q     *R                                        
     .          +        AIZ   *R     *R     )                                  
C                                                                               
C.... STABILITY AXIS RATES.                                                     
C                                                                               
      OBSVEC(49)= P     *COSALP+R     *SINALP                                   
      OBSVEC(51)=-P     *SINALP+R     *COSALP                                   
C                                                                               
C.... BODY AXIS VELOCITIES.                                                     
C                                                                               
      OBSVEC(52)=UB                                                             
      OBSVEC(53)=VB                                                             
      OBSVEC(54)=WB                                                             
C                                                                               
C.... FORCES : LIFT, DRAG, NORMAL, AND AXIAL.                                   
C                                                                               
      OBSVEC(94)=TLFT                                                           
      OBSVEC(95)=DRAG                                                           
      OBSVEC(96)=DRAG*SINALP + TLFT*COSALP                                      
      OBSVEC(97)=DRAG*COSALP - TLFT*SINALP                                      
C                                                                               
C.... CONTROL SURFACES.                                                         
C                                                                               
      DO 3 I=1,30
      OBSVEC(I+60)=DC(I)                                                
    3 CONTINUE                                                                  
C                                                                               
C.... ENTER TIME DERIVATIVES OF STATE VARIABLES.                                
C                                                                               
      DO 2 I=1,12                                                               
      OBSVEC(I+12)=DF(I+1)                                                      
    2 CONTINUE                                                                  
C                                                                               
                    ENTRY INSTR2                                                
C                                                                               
C.... ENTRY TO COMPUTE AND STORE OBSERVATION VARIABLES DEPENDENT ON THE         
C     CALCULATION OF THE TIME DERIVATIVE OF THE STATE VECTOR.                   
C                                                                               
C.... COMPUTE ACCELEROMETER TERMS.                                              
C                                                                               
      OBSVEC(32)=   ANX                                                         
     .          -( (Q     *Q     +R     *R     )*VARPOS(32, 1)                  
     .            -(P     *Q     -RDOT         )*VARPOS(32, 2)                  
     .            -(P     *R     +QDOT         )*VARPOS(32, 3))/G0              
      OBSVEC(33)=   ANY                                                         
     .          -(-(P     *Q     +RDOT         )*VARPOS(33, 1)                  
     .            +(P     *P     +R     *R     )*VARPOS(33, 2)                  
     .            -(Q     *R     -PDOT         )*VARPOS(33, 3))/G0              
      OBSVEC(34)=   ANZ                                                         
     .          -(-(P     *R     -QDOT         )*VARPOS(34, 1)                  
     .            -(Q     *R     +PDOT         )*VARPOS(34, 2)                  
     .            +(Q     *Q     +P     *P     )*VARPOS(34, 3))/G0              
      OBSVEC(99)=   AN                                                          
     .          +(-(P     *R     -QDOT         )*VARPOS(99, 1)                  
     .            -(Q     *R     +PDOT         )*VARPOS(99, 2)                  
     .            +(Q     *Q     +P     *P     )*VARPOS(99, 3))/G0              
      OBSVEC(40)=(V      *HDOTDT-HDOT  *VDOT )/V                                
     .           /SQRT  (V      *V     -HDOT  *HDOT  )                         
C                                                                               
C.... COMPUTE GLIDE PATH ANGLE.                                                 
C                                                                               
      GMA = ASIN ( HDOT / V )                                                  
      OBSVEC(39)=GMA                                                            
C                                                                               
C.... COMPUTE FLIGHT PATH ACCELERATION.                                         
C                                                                               
      OBSVEC(38) = VDOT  /G0                                                    
C                                                                               
      OBSVEC(43)=HDOT  /57.29578                                                
C                                                                               
C.... ENERGY TERMS.                                                             
C                                                                               
      OBSVEC(46)=HDOT  +V     *VDOT  / G                                        
C                                                                               
C.... SET TRIM PARAMETERS                                                       
C                                                                               
      OBSVEC(104) = DEX                                                         
      OBSVEC(105) = DAX                                                         
      OBSVEC(106) = DRX                             
C... ADDED 2ND ENGINE THROTTLE  RWB 12/21/90
      OBSVEC(107) = THRSTX(1)
      OBSVEC(108) = THRSTX(2)
C                                                                               
      RETURN                                                                    
      END                                                                       
