C
      SUBROUTINE DATINP
C
C.... ROUTINE TO INPUT VEHICLE GEOMETRY AND MASS PROPERTIES.
C
C.... WRITTEN MAY 4, 1981
C     LEE DUKE NASA/DFRC
C
C
      CHARACTER * 4 ICGTLT(12)
C
      REAL WEIGHT
C
c     INCLUDE 'include.h'
      INCLUDE 'cgshft.h'
      INCLUDE 'datain.h'
      INCLUDE 'lll006.h'
      INCLUDE 'lll022.h'
      INCLUDE 'lll029.h'
      INCLUDE 'parameter.h'
C
C.... READ GEOMETRY AND MASS INFORMATION.
C
      READ(LUN001,100) S     ,B     ,CBAR  ,WEIGHT
C
C.... CONVERT WEIGHT TO MASS.
C
      AMSS = WEIGHT / 32.174
C
C.... READ INERTIA DATA.
C
      READ(LUN001,100) AIX   ,AIY   ,AIZ   ,AIXZ  ,AIXY  ,AIYZ
C
C.... READ DATA DEFINING VECTOR FROM VEHICLE CENTER OF GRAVITY TO
C     REFERENCE POINT OF AERODYNAMIC MODEL.
C
      READ(LUN001,400) DELX  ,DELY  ,DELZ  ,ICGTLT
C
      CGSET = .TRUE.
C
C.... DETERMINES WHERE TO CORRECT FORCE AND MOMENT COEFFICIENTS
C     FROM THE REFERENCE POINT OF THE BASIC AERODYNAMIC MODEL TO
C     THE VEHICLE CENTER OF GRAVITY.
C
C     IF CGSET IS TRUE, THE FORCE AND MOMENT COEFFICIENT
C         CORRECTIONS WILL BE CALCULATED IN CGCALCC
C     IF CGSET IS FALSE, THE FORCE AND MOMENT COEFFICIENT
C         CORRECTIONS WILL BE CALCULATED IN THE USER'S CCALC.
C
      IF (ICGTLT(1).EQ.'NO C'.OR.ICGTLT(1).EQ.'CCAL'.OR.
     .      ICGTLT(1).EQ.'FORC')
     .      CGSET = .FALSE.
C.... READ IN LIMITS FOR ANGLE OF ATTACK
C
      READ(LUN001,100) ALPMIN,ALPMAX
C
C.... CONVERT TO RADIANS
C
      ALPMIN = ALPMIN / DGR
      ALPMAX = ALPMAX / DGR
C
      RETURN
 100   FORMAT(6F13.0)
C
 400    FORMAT (3F10.0,12A4)
C
      END
