C
      SUBROUTINE CGCALC                                                         
C                                                                               
C.... ROUTINE TO CORRECT FORCE AND MOMENT COEFFICIENTS FROM THE                 
C     REFERENCE POINT OF THE BASIC AERODYNAMIC MODEL TO THE                     
C     VEHICLE CENTER OF GRAVITY AND TO COMPUTE THE AERODYNAMIC                  
C     FORCES AND MOMENTS.                                                       
C                                                                               
C.... WRITTEN MAY 12, 1981                                                      
C     LEE DUKE NASA/DFRC                                                        
C                                                                               
      REAL ALP, QS
      REAL FX, FY, FZ, DELTL, DELTM, DELTN
C
c     INCLUDE 'include.h'
      INCLUDE 'cgshft.h'
      INCLUDE 'clcout.h'
      INCLUDE 'datain.h'
      INCLUDE 'drvout.h'
      INCLUDE 'simout.h'
      INCLUDE 'trigfn.h'
      INCLUDE 'lll006.h'
      INCLUDE 'lll019.h'
C
      EQUIVALENCE (ALP   ,F     ( 6))                                           
C                                                                               
C.... COMPUTE TRIGONOMETRIC FUNCTIONS FOR AXIS TRANSFORMATION.                  
C                                                                               
C                                                                               
      COSALP = COS (ALP)                                                       
      SINALP = SIN (ALP)                                                       
C
C.... COMPUTE THE AERODYNAMIC FORCE AND MOMENT COEFFICIENTS
C
      CALL CCALC
C                                                                               
C.... CALCULATE MOMENT TERMS                                                    
C                                                                               
      ALM   =QBAR*S*B*CL                                                        
      AMM   =QBAR*S*CBAR*CM                                                     
      ANM   =QBAR*S*B*CN                                                        
C                                                                               
C.... COMPUTE FORCES                                                            
C                                                                               
      QS     = QBAR * S                                                         
C                                                                               
      TLFT   = QS * CLFT                                                        
      DRAG   = QS * CD                                                          
      SIDFOR = QS * CY                                                          
C                                                                               
C.... DETERMINES WHETHER TO CALCULATE FORCE AND MOMENT                          
C     CORRECTIONS                                                               
C                                                                               
      IF (.NOT.CGSET) RETURN                                                   
C                                                                               
C.... COMPUTE BODY AXIS FORCE COEFFICIENTS.                                     
C                                                                               
      FX = -CD * COSALP + CLFT * SINALP                                         
      FY =  CY                                                                  
      FZ = -CD * SINALP - CLFT * COSALP                                         
C                                                                               
C.... COMPUTE MOMENTS INDUCED BY CHANGE OF REFERENCE.                           
C                                                                               
      DELTL = ( FZ * DELY - FY * DELZ ) / B                                     
      DELTM = ( FX * DELZ - FZ * DELX ) / CBAR                                  
      DELTN = ( FY * DELX - FX * DELY ) / B                                     
C                                                                               
C.... CORRECT MOMENT COEFFICIENTS.                                              
C                                                                               
      CL = CL + DELTL                                                           
      CM = CM + DELTM                                                           
      CN = CN + DELTN                                                           
C                                                                               
C.... CALCULATE MOMENT TERMS                                                    
C                                                                               
      ALM   =QBAR*S*B*CL                                                        
      AMM   =QBAR*S*CBAR*CM                                                     
      ANM   =QBAR*S*B*CN                                                        
C                                                                               
      RETURN                                                                    
      END                                                                                            
