// genclass -2 double val doublereal ref real double
#include "math.h"
class doublereal {
  public:
	 double	X[1+VARIABLES];
	 doublereal(const doublereal&	x);
	 doublereal(const double 	x);
	 doublereal(const int	i);
	 doublereal();
	~doublereal();
     
	 doublereal&	neg(const doublereal& y);

	 doublereal&	mul(const doublereal& x, const doublereal& y);
	 doublereal&	div(const doublereal& x, const doublereal& y);
	 doublereal&	add(const doublereal& x, const doublereal& y);
	 doublereal&	sub(const doublereal& x, const doublereal& y);

	 doublereal&	mul(const doublereal& x, const double  y);
	 doublereal&	div(const doublereal& x, const double  y);
	 doublereal&	add(const doublereal& x, const double  y);
	 doublereal&	sub(const doublereal& x, const double  y);

	 doublereal&	mul(const double  x, const doublereal& y);
	 doublereal&	div(const double  x, const doublereal& y);
	 doublereal&	add(const double  x, const doublereal& y);
	 doublereal&	sub(const double  x, const doublereal& y);

	 doublereal&	pow(const doublereal& x, const double  y);
	 doublereal&	sgn(const doublereal& x, const doublereal& y);
	 doublereal&	sgn(const double  x, const doublereal& y);
	 doublereal&	abs(const doublereal& x);
	 doublereal&	cos(const doublereal& x);
	 doublereal&	sin(const doublereal& x);
	 doublereal&	sqrt(const doublereal& x);
	 doublereal&	asin(const doublereal& x);

	 double	operator [] (int i) const;

	 doublereal	operator -  () const;

		operator int() const;
		operator double() const;
		operator double*() const;

	 doublereal&	operator  = (const doublereal& y);
	 doublereal&	operator *= (const doublereal& y);
	 doublereal&	operator /= (const doublereal& y);
	 doublereal&	operator += (const doublereal& y);
	 doublereal&	operator -= (const doublereal& y);

	 doublereal&	operator  = (const double  y);
	 doublereal&	operator *= (const double  y);
	 doublereal&	operator /= (const double  y);
	 doublereal&	operator += (const double  y);
	 doublereal&	operator -= (const double  y);

  };
inline	doublereal::doublereal(const doublereal& x) {
  *this = x;
  }

inline	doublereal::doublereal(const double  x) {
  *this = x;
  }

inline	doublereal::doublereal(const int i) {
  *this = (double) i;
  }

inline	doublereal::doublereal() {
  *this = (double) 0.0;
  }

inline	doublereal::~doublereal() {
  }

inline	double	doublereal::operator [] (int i) const {
  return X[i];
  }

inline	doublereal	doublereal::operator -  () const {
  doublereal z;
  return z.neg(*this);
  }

inline		doublereal::operator int() const {
  return (int)X[0];
  }
inline		doublereal::operator double() const {
  return X[0];
  }
inline		doublereal::operator double*() const {
  return X;
  }
inline	doublereal	operator *  (const doublereal& x, const doublereal& y) {
  doublereal	z;
  return z.mul(x, y);
  }
inline	doublereal	operator /  (const doublereal& x, const doublereal& y) {
  doublereal	z;
  return z.div(x, y);
  }
inline	doublereal	operator +  (const doublereal& x, const doublereal& y) {
  doublereal	z;
  return z.add(x, y);
  }
inline	doublereal	operator -  (const doublereal& x, const doublereal& y) {
  doublereal	z;
  return z.sub(x, y);
  }

inline	doublereal	operator *  (const doublereal& x, const double  y) {
  doublereal	z;
  return z.mul(x, y);
  }
inline	doublereal	operator /  (const doublereal& x, const double  y) {
  doublereal	z;
  return z.div(x, y);
  }
inline	doublereal	operator +  (const doublereal& x, const double  y) {
  doublereal	z;
  return z.add(x, y);
  }
inline	doublereal	operator -  (const doublereal& x, const double  y) {
  doublereal	z;
  return z.sub(x, y);
  }

inline	doublereal	operator *  (const double  x, const doublereal& y) {
  doublereal	z;
  return z.mul(x, y);
  }
inline	doublereal	operator /  (const double  x, const doublereal& y) {
  doublereal	z;
  return z.div(x, y);
  }
inline	doublereal	operator +  (const double  x, const doublereal& y) {
  doublereal	z;
  return z.add(x, y);
  }
inline	doublereal	operator -  (const double  x, const doublereal& y) {
  doublereal	z;
  return z.sub(x, y);
  }
inline	int	operator <  (const doublereal& x, const doublereal& y) {
  return x[0] <  y[0];
  }
inline	int	operator <= (const doublereal& x, const doublereal& y) {
  return x[0] <= y[0];
  }
inline	int	operator >  (const doublereal& x, const doublereal& y) {
  return x[0] >  y[0];
  }
inline	int	operator >= (const doublereal& x, const doublereal& y) {
  return x[0] >= y[0];
  }
inline	int	operator == (const doublereal& x, const doublereal& y) {
  return x[0] == y[0];
  }
inline	int	operator != (const doublereal& x, const doublereal& y) {
  return x[0] != y[0];
  }

inline	int	operator <  (const doublereal& x, const double  y) {
  return x[0] <  y;
  }
inline	int	operator <= (const doublereal& x, const double  y) {
  return x[0] <= y;
  }
inline	int	operator >  (const doublereal& x, const double  y) {
  return x[0] >  y;
  }
inline	int	operator >= (const doublereal& x, const double  y) {
  return x[0] >= y;
  }
inline	int	operator == (const doublereal& x, const double  y) {
  return x[0] == y;
  }
inline	int	operator != (const doublereal& x, const double  y) {
  return x[0] != y;
  }

inline	int	operator <  (const double  x, const doublereal& y) {
  return x <  y[0];
  }
inline	int	operator <= (const double  x, const doublereal& y) {
  return x <= y[0];
  }
inline	int	operator >  (const double  x, const doublereal& y) {
  return x >  y[0];
  }
inline	int	operator >= (const double  x, const doublereal& y) {
  return x >= y[0];
  }
inline	int	operator == (const double  x, const doublereal& y) {
  return x == y[0];
  }
inline	int	operator != (const double  x, const doublereal& y) {
  return x != y[0];
  }
inline
doublereal&	doublereal::operator += (const double  y) {
  X[0]	+= y;
  return *this;
  }
inline
doublereal&	doublereal::operator -= (const double  y) {
  X[0]	-= y;
  return *this;
  }
inline	doublereal	pow_dd(const doublereal *x, const double *y) {
  doublereal	z;
  return z.pow(*x, *y);
  }
inline	doublereal	d_sign(const doublereal *x, const doublereal *y) {
  doublereal	z;
  return z.sgn(*x, *y);
  }
inline	doublereal	d_sign(const double *x, const doublereal *y) {
  doublereal	z;
  return z.sgn(*x, *y);
  }
inline	doublereal	abs(const doublereal& x) {
  doublereal	z;
  return z.abs(x);
  }
inline	doublereal	cos(const doublereal& x) {
  doublereal	z;
  return z.cos(x);
  }
inline	doublereal	sin(const doublereal& x) {
  doublereal	z;
  return z.sin(x);
  }
inline	doublereal	sqrt(const doublereal& x) {
  doublereal	z;
  return z.sqrt(x);
  }
inline	doublereal	asin(const doublereal& x) {
  doublereal	z;
  return z.asin(x);
  }
