#include "variables.h"
#include "doublereal.h"

doublereal&	doublereal::operator  = (const doublereal& y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	 = y[i];
  return *this;
  }
doublereal&	doublereal::operator *= (const doublereal& y) {
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = X[i]*y[0] + y[i]*X[0];
  X[0]		*= y[0];
  return *this;
  }
doublereal&	doublereal::operator /= (const doublereal& y) {
  X[0]		*= (1.0/y[0]);
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 =(X[i] - y[i]*X[0])*(1.0/y[0]);
  return *this;
  }
doublereal&	doublereal::operator += (const doublereal& y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	+= y[i];
  return *this;
  }
doublereal&	doublereal::operator -= (const doublereal& y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	-= y[i];
  return *this;
  }
doublereal&	doublereal::operator  = (const double  y) {
  X[0]	 = y;
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = 0.0;
  return *this;
  }
doublereal&	doublereal::operator *= (const double  y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	*= y;
  return *this;
  }
doublereal&	doublereal::operator /= (const double  y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	*= (1.0/y);
  return *this;
  }
doublereal&	doublereal::neg(const doublereal& y) {
  for(int i = 0; i <= VARIABLES; i++)
    X[i]	 = -y[i];
  return *this;
  }

doublereal&	doublereal::mul(const doublereal& x, const doublereal& y) {
  X[0]	 = x[0]*y[0];
  for (int i = 1; i <= VARIABLES; i++)
    X[i] = x[i]*y[0] + y[i]*x[0];
  return *this;
  }
doublereal&	doublereal::div(const doublereal& x, const doublereal& y) {
  X[0]	 = x[0]*(1.0/y[0]);
  for (int i = 1; i <= VARIABLES; i++)
    X[i] =(x[i] - y[i]*X[0])*(1.0/y[0]);
  return *this;
  }
doublereal&	doublereal::add(const doublereal& x, const doublereal& y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	 = x[i] + y[i];
  return *this;
  }
doublereal&	doublereal::sub(const doublereal& x, const doublereal& y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	 = x[i] - y[i];
  return *this;
  }
doublereal&	doublereal::mul(const doublereal& x, const double  y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	 = x[i]*y;
  return *this;
  }
doublereal&	doublereal::div(const doublereal& x, const double  y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	 = x[i]*(1.0/y);
  return *this;
  }
doublereal&	doublereal::add(const doublereal& x, const double  y) {
  X[0]	 = x[0] + y;
  for (int i = 1; i <= VARIABLES; i++)
    X[i] = x[i];
  return *this;
  }
doublereal&	doublereal::sub(const doublereal& x, const double  y) {
  X[0]	 = x[0] - y;
  for (int i = 1; i <= VARIABLES; i++)
    X[i] = x[i];
  return *this;
  }
doublereal&	doublereal::mul(const double  x, const doublereal& y) {
  for (int i = 0; i <= VARIABLES; i++)
    X[i]	 = x*y[i];
  return *this;
  }
doublereal&	doublereal::div(const double  x, const doublereal& y) {
  X[0]	 = x/y[0];
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = y[i]*(-X[0]/y[0]);
  return *this;
  }
doublereal&	doublereal::add(const double  x, const doublereal& y) {
  X[0]	 = x + y[0];
  for (int i = 1; i <= VARIABLES; i++)
    X[i] = y[i];
  return *this;
  }
doublereal&	doublereal::sub(const double  x, const doublereal& y) {
  X[0]	 = x - y[0];
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = -y[i];
  return *this;
  }
doublereal&	doublereal::pow(const doublereal& x, const double  y) {
  if (0.0 < x) {
    X[0]	 = ::pow(x[0], y);
    for (int i = 1; i <= VARIABLES; i++)
      X[i]	 = x[i]*X[0]*y/x[0];
    }
  else
    *this	 = 0.0;
  return *this;
  }
doublereal&	doublereal::sgn(const doublereal& x, const doublereal& y) {
  if (0.0 < x && y < 0.0 || 0.0 < y && x < 0.0)
    *this	 =-x;
  else
    *this	 = x;
  return *this;
  }
doublereal&	doublereal::sgn(const double  x, const doublereal& y) {
  if (0.0 < x && y < 0.0 || 0.0 < y && x < 0.0)
    *this	 =-x;
  else
    *this	 = x;
  return *this;
  }
doublereal&	doublereal::abs(const doublereal& x) {
  if (x < 0.0)
    *this	 = -x;
  else
    *this	 =  x;
  return *this;
  }
doublereal&	doublereal::cos(const doublereal& x) {
  X[0]	 = ::cos(x[0]);
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = x[i]*::sin(-x[0]);
  return *this;
  }
doublereal&	doublereal::sin(const doublereal& x) {
  X[0]	 = ::sin(x[0]);
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = x[i]*::cos( x[0]);
  return *this;
  }
doublereal&	doublereal::sqrt(const doublereal& x) {
  X[0]	 = ::sqrt(x[0]);
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = x[i]*(0.5/::sqrt(x[0]));
  return *this;
  }
doublereal&	doublereal::asin(const doublereal& x) {
  X[0]	 = ::asin(x[0]);
  for (int i = 1; i <= VARIABLES; i++)
    X[i]	 = x[i]*(1.0/::sqrt(1.0 - x[0]*x[0]));
  return *this;
  }
