#include <math.h>
#include <bool.h>
#include <MLCG.h>
#include <Normal.h>
#include <GetOpt.h>
#include <double.Matrix.h>
#define  matrix doubleMatrix
#define  array  doubleArray

int
main (int argc, char **argv) {
  int		verbose  = FALSE;		// verbose reporting off
  long		seedval	 = 43;			// random number seed value
  double	noise	 = -20.0;		// lg(variance)/2.0
  GetOpt	getopt (argc, argv, "n:s:v");

  int option;
  while ((option = getopt()) != EOF)
    switch (option) {
      case 'n':					// noise level
	noise		= atof(getopt.optarg);
        break;
      case 's':					// seed value
	seedval	= atoi(getopt.optarg);
        break;
      case 'v':					// verbose reporting on
	verbose	= TRUE;
        break;
      case '?':
        cerr << "Unrecognized option!\n";
      };

  if (verbose)
    cerr	<< seedval	<< " = seedval "
		<< noise	<< " = noise\n";

  MLCG	gen(13, seedval);			// random number generator
  Normal	rnd (0.0, pow(2.0, noise), &gen);// probability distribution
  int		layers; cin >> layers;		// number of layers
#ifdef	__GNUC__
  matrix	b[layers];			// threshold biases
  matrix	W[layers];			// connection weights
#else
  matrix *const b	 = new matrix[layers];	// threshold biases
  matrix *const W	 = new matrix[layers];	// connection weights
#endif
  int		outputs; cin >> outputs;	// number of outputs
  int		inputs = outputs;		// number of  inputs
  if (verbose)
    cerr << "N(" << inputs;
  int layer;
  for (layer = 0; layer < layers; layer++) {
    int inputs = outputs;
    cin >> outputs;
    if (verbose)
      cerr << ", " << outputs;
    W[layer].resize(outputs, inputs);
    b[layer].resize(outputs);
    for (int i = 0; i < outputs; i++) {
      b[layer][0][i] = rnd()/(inputs+1);
      for (int j = 0; j < inputs; j++)
	W[layer][i][j] = rnd()/(inputs+1);
	}
      };
  if (verbose)
    cerr << ")\n";

  matrix	x0(inputs), dx(inputs);		// inputs
  cin >> x0 >> dx;
  matrix	y0(outputs), dy(outputs);	// outputs
  cin >> y0 >> dy;

  W[       0]	/= dx;
  b[       0]	-= x0%W[0];
  W[layers-1]	*= dy.t();
  b[layers-1]	*= dy;
  b[layers-1]	+= y0;

  format("%19.12e", 4, " ");			// matrix output format

  cout << layers << "\n";			// number of  layers
  cout << inputs << "\n";			// number of  inputs
  for (layer = 0; layer < layers; layer++) {
    int outputs = b[layer].n();
    cout << outputs << "\n";			// number of outputs
    for (int output = 0; output < outputs; output++)
      cout << form("%19.12e\n", b[layer][0][output])
	   << W[layer].s(output);
    };
  cout << x0 << dx;
  cout << y0 << dy;
  return 0;
  }

