#include "cog.h"


/* Function print_layer */
void print_layer(layer)
int layer;
{
  int x,y;
  fprintf(runfp, "Values in layer %d\n",layer);
  for (y=0; y<SIZE; y++)
  {
	for (x=0; x<SIZE; x++) fprintf(runfp, "%1.5f ", (float)u[layer][x][y]);
	fprintf(runfp, "\n");
  }
}


void print_weights(name)
char *name;
{
  int layer, x, y, vx, vy;
  char wts[100], *dot;
  FILE *wfp;

  strcpy(wts, name); if ((dot = strchr(wts, '.')) != NULL) *dot='\0';
  strcat(wts, ".wts");

  if ((wfp = fopen(wts, "wb")) == NULL)
	panic("%s:  can't create %s\n", progname, wts);

  for (layer=1; layer<LAYERS; layer++)
	for (x=0; x<SIZE; x++) {
		for (y=0; y<SIZE; y++) for (vx=0; vx<S_SIZE; vx++)
			if (fwrite(a[layer][x][y][vx], sizeof(FLOAT),
			S_SIZE, wfp) != S_SIZE) 
				panic("%s:  can't write weights\n", progname);
		if (fwrite(b[layer][x], sizeof(FLOAT), SIZE, wfp) != SIZE)
			panic("%s:  can't write weights\n", progname);
	}

  fclose(wfp);
}


char thing(num, max)
DOUBLE num, max;
{
  if (num == 0.0) return(' ');
  if (num <= max/4.0) return('-');
  if (num <= max/2.0) return('=');
  return('#');
}


char *rep(len, s)
int len; char *s;
{
  struct strings_struct {
	char *s;
	struct strings_struct *next;
  };

  static struct strings_struct *start, *strings, *prev;
  static int first_run = 1;
  static char nul_string[1];
  int i;

  if (first_run) {
	start = strings = prev = NULL;
	first_run = 0;
  }

  if (len < 0) {
	strings = start;
	while (strings != NULL) {
		struct strings_struct *help;

		help = strings;
		strings = strings->next;
		free(help);
	}
	strings = start = prev = NULL;
	return nul_string;
  }

  if ((strings = (struct strings_struct *)
	malloc(sizeof(struct strings_struct))) == NULL) {
#ifdef __TURBOC__
		strerror(errno);
#else
		fprintf(stderr, "Can't allocate memory for strings[]\n");
#endif
		return NULL;
  }

  if (prev != NULL)
	prev->next = strings;
  else
	start = strings;

  if ((strings->s = (char *) malloc(len * strlen(s)+1)) == NULL) {
#ifdef __TURBOC__
	strerror(errno);
#else
	fprintf(stderr, "Can't allocate memory for strings[][]\n");
#endif
	return NULL;
  }

  (strings->s)[len*strlen(s)] = '\0';
  for (i=0; i<len; i++)
	strcpy((strings->s) + i*strlen(s), s);

  prev = strings; strings->next = NULL;
  return strings->s;
}


#define PRINT_S(s) {fputs(s, runfp); if (verbose && ITERATIONS==0 && runfp != stdout) fputs(s, stdout);}
#define PRINT_C(c) {fputc(c, runfp); if (verbose && ITERATIONS==0 && runfp != stdout) fputc(c, stdout);}


void show_layers()
{
  int x, y, l;
  DOUBLE *max;
  char s[100];

  if ((max = (DOUBLE *) calloc(LAYERS, sizeof(DOUBLE))) == NULL)
	panic("%s:  cannot allocate memory in show_layers()\n");

  for (l=0; l<LAYERS; l++)
  {
	max[l] = 0;
	for (x=0; x<SIZE; x++) for (y=0; y<SIZE; y++)
		if (u[l][x][y] > max[l])
			max[l] = u[l][x][y];
	sprintf(s, "%d%s%1.2f%s%d%s", l, rep((SIZE-4)/2, "*"),
		(float) max[l], rep((SIZE-3)/2, "*"), l,
		l<LAYERS-1 ? "  " : "");
	PRINT_S(s);
	rep(-1, NULL);
  }

  for (y=0; y<SIZE; y++)
  {
	PRINT_C('\n');
	for (l=0; l<LAYERS; l++)
	{
		PRINT_C('*');
		for (x=0; x<SIZE; x++)
			PRINT_C(thing(u[l][x][y], max[l]));
		PRINT_C('*');
		if (l < LAYERS-1) PRINT_S("  ");
	}
  }
  PRINT_C('\n');
  for (l=0; l<LAYERS; l++) {
	sprintf(s, "%d%s%d%s", l, rep(SIZE, "*"), l, l<LAYERS-1 ? "  ":"");
	PRINT_S(s);
	rep(-1, NULL);
  }
  PRINT_C('\n');

  free(max);
}
