#include <stdio.h>
#include <math.h>

#define inputs 2			/* no of input nodes */
#define outputs 100			/* number of output nodes */
#define cluster 10			/* clusters in each dimension; sq rt
					/* of output nodes, since 2-D */
#define maxiteration 5000		/* maximum number of iterations */

double weight[inputs][outputs];		/* weight matrix */
double innode[inputs];			/* input vector */
double gain = 0.9;			/* gain for weight change */
double attn = 0.99;			/* gain change factor */
int neighbour = 4;			/* number of nodes in neighbourhood */
					/* on each side (vertical and horiz)*/
					/* of selected node */
double nattn = 0.99;			/* neighbourhood shrink factor */
double distance[outputs];		/* normalized distance from input */
					/* vector to output nodes */

/****************************************************************************/
/*                                                                          */
/*                            Random Number Generator                       */
/*                                                                          */
/****************************************************************************/

long randseed = 568731L;
int random()
{
	randseed = 15625L * randseed + 22221L;
	return((randseed >> 16) & 0x7FFF);
}

/* initialize weights with random numbers between 4.0 and 5.0             */
/* Since inputs come from a range of 0-9, 4.5 is mid value, and hence the */
/* range.                                                                 */

initwt()
{
	int i,j;
	
	for (j = 0; j < inputs; j++)
	   for (i = 0; i < outputs; i++)
		weight[j][i] = random() / pow(2.0,15.0) - 0.5 + 4.5;
}

main()
{

	int i,j,k;
	double tgain, dist, dneighbour;
	int minnode;
	int iteration = 0;
	int ind, index;

	initwt();
 	tgain = gain;
	dneighbour = neighbour;

	do {
	    /* input vector; contains two integers between 0 and 9 */
	    innode[0] = random() % 10;
	    innode[1] = random() % 10;
	    /* initialize distance vector */
	    for (i = 0; i < inputs; i++)
		distance[i] = 0;
	    /* calculate normalized distance; i.e., sum of dist sqares */
	    for (j = 0; j < outputs; j++)
		for (i = 0; i < inputs; i++)
			distance[j] += pow((innode[i] - weight[i][j]), 2.0);
	    /* find the node with minimum distance */
	    minnode = 0;
	    dist = distance[0];
	    for (i = 1; i < outputs; i++)
		if (distance[i] < dist) {
		    minnode = i;
		    dist = distance[i];
		}
	    /* update weights of nodes in the neighbourhood of selected node */
	    for (j = -neighbour; j <= neighbour; j++)
		for (i = -neighbour; i <= neighbour; i++) {
		     ind = i + minnode % cluster;
		     index = i + minnode + (j * cluster);/*to account for 2-D*/
		     /* reject neighbours found by wrap around */
		     if ((index >= 0) && (index < outputs) && (ind >= 0) &&
			 (ind < cluster)) 
			 for (k = 0; k < inputs; k++) {
			      dist = innode[k] - weight[k][index];
			      weight[k][index] +=  tgain * dist;
			}
		}
	    /* reduce gain */
	    tgain *= attn;
	    /* shrink neighbourhood; actual shrinking takes place when
		the real value becomes equal to integer value */
	    dneighbour *= nattn;
	    neighbour = (int) dneighbour;
	    iteration++;
	} while (iteration < maxiteration);
	/* printout weights */
	for (j = 0; j < inputs; j++) {
	   for(i = 0; i < outputs; i++)
		printf("\n%f", weight[j][i]);
	}
}
