/********************************************************
  template for Homework #2, competitive learning

  Justin Boyan (jab=ta@cs.cmu.edu), 9/28/93
*********************************************************/

#include <stdio.h>

char *filename = "cities2.data";

#define MAX_PATS 100
#define MAX_INP_DIM 100
#define MAX_NAME_LEN 30

char  pat_name[MAX_PATS][MAX_NAME_LEN];  /* array of pattern names    */
float pat[MAX_PATS][MAX_INP_DIM];        /* the actual pattern values */

int npatterns;
int ninputs;

void read_pat();

int main()
{
  read_pat();  /* this sets up pat[][], pat_name[], npatterns & ninputs */
  if (npatterns==0) {
    fprintf(stderr, "\nUnable to read patterns.\n");
    return 1;
  }

  /*** YOUR CODE GOES HERE! ***/

  return 0;
}


/* reads pat[][] from filename; sets ninputs and npatterns. */
void read_pat()
{
  FILE *stream;
  char digitstring[MAX_INP_DIM], *d;
  int p,j;
  
  if ((stream=fopen(filename,"r"))==NULL) {
    npatterns=0;
    return;
  }
  for (p=0; p<MAX_PATS && !feof(stream); p++) {
    fgets(pat_name[p], MAX_NAME_LEN, stream);
    /** remove trailing newline from inputname: **/
    for (d=pat_name[p]; d && (*d>'\n'); d++) {}; *d='\0';
    /**/
    if (feof(stream)) { /** odd # of lines in data file; ignore final line **/
      break;
    }
    fgets(digitstring, MAX_INP_DIM, stream);
    for (j=0, d=digitstring; d && (*d!='\n') && j<MAX_INP_DIM; d++, j++) {
      pat[p][j] = (float) ((int) *d - (int) '0') ;
    }
    if (p==0) {
      ninputs = j;   /** set ninputs = length of 1st digitstring in file **/
    }
    else if (j != ninputs) {
      fprintf(stderr, "\nError: pattern %d has dimension %d, wanted %d.\n",
	      p, j, ninputs);
    }
  } /* end of for loop */
  npatterns=p;
  printf("\nRead %d patterns (%s ... %s) * %d inputs from %s.\n",
	 npatterns, pat_name[0], pat_name[npatterns-1], ninputs, filename);
  return;
}
