;;; A simple-minded simulator for two-input perceptrons.
;;;
;;; To run it, load this file into Lisp and type (perceptron).
;;;
;;;  -- David S. Touretzky, January, 1990.


(defvar *initial-weights*)

(setf *initial-weights*
 ;   w0   w1   w2
  '( -1   +1   -3))

(defvar *training-set*)

(setf *training-set*
 ;      x1  x2  desired
  '(   ((0  0)    1)
       ((0  1)    1)
       ((1  0)    0)
       ((1  1)    1)
    ))

(defun perceptron (&aux (weights (copy-list *initial-weights*))
			(len (length *training-set*)))
  (print-header)
  (do ((i 0 (1+ i))
       (done-flag nil))
      (nil)
    (let* ((pat (nth (mod i len) *training-set*))
	   (inputs (first pat))
	   (desired (second pat)))
      (when (zerop (mod i len))
	(terpri)
	(if done-flag (return t)
	    (setf done-flag t)))
      (let* ((sum (+ (nth 0 weights)
		     (* (nth 1 weights) (first inputs))
		     (* (nth 2 weights) (second inputs))))
	     (output (if (> sum 0) 1 0))
	     (error (- desired output)))
	(unless (zerop error) (setf done-flag nil))
	(print-item i inputs weights output desired error)
	(incf (nth 0 weights) error)
	(incf (nth 1 weights) (* (first inputs) error))
	(incf (nth 2 weights) (* (second inputs) error))))))

(defun print-header ()
  (format t "~%Trial   w0      x1 *  w1      x2 *  w2     output  desired"))

(defun print-item (i inputs weights output desired error)
  (format t
    "~%~3D.   ~4,1@F~C   ~2D    ~4,1@F~C   ~2D    ~4,1@F~C      ~1D        ~1D"
    i
    (nth 0 weights)
    (update-char error)
    (first inputs) (nth 1 weights) (update-char (* (first inputs) error))
    (second inputs) (nth 2 weights) (update-char (* (second inputs) error))
    output desired))

(defun update-char (x)
  (cond ((zerop (abs x)) #\space)
	((plusp x) #\>)
	(t #\<)))
