/*
    A simple-minded simulator for 2 bool input-->1 bool output perceptrons.
    Translated to C from David Touretzky's Lisp code.

    -Justin Boyan, September 1993
*/
#include <stdio.h>

float initial_weights[3] = {-1,1,-3};

#define NPATS 4
   /* each training pattern is stored as {input1,input2,desired_output} */
int training_set[NPATS][3] = {{0,0, 1}, {0,1, 1}, {1,0, 0}, {1,1, 1}};

void print_trial();
char update_char();

int main() {
  int i, pat, input1, input2, desired, sum, output, error;
  int no_error_yet=0;
  float *weights = initial_weights;
  
  printf("\nTrial   w0      x1 *  w1      x2 *  w2     output  desired");
  for (i=0; ; i++) {
    pat = i % NPATS;
    if (pat==0) {
      printf("\n");
      if (no_error_yet) break; /* got all patterns with no error:  done. */
      else
	no_error_yet = 1;
    }
    input1=training_set[pat][0];
    input2=training_set[pat][1];
    desired=training_set[pat][2];

    sum = weights[0] + weights[1]*input1 + weights[2]*input2;
    output = (sum > 0) ? 1 : 0;
    error = desired - output;
    no_error_yet = no_error_yet && (error==0);
    print_trial(i, input1, input2, weights, output, desired, error);
    weights[0] += error;
    weights[1] += input1*error;
    weights[2] += input2*error;
  }
}

void print_trial(i, input1, input2, weights, output, desired, error)
int i, input1, input2, output, desired, error;
float weights[3];
{
  printf("\n%3d.   %4.1f%c   %2d    %4.1f%c   %2d    %4.1f%c      %1d        %1d",
	 i, weights[0], update_char(error),
	 input1, weights[1], update_char(input1*error),
	 input2, weights[2], update_char(input2*error),
	 output, desired);
}

char update_char(error)
int error;
{
  if (error==0) return ' ';
  else if (error > 0) return '>';
  else return '<';
}
