;;; from Ray Mooney's database at UT
;;;================================================================
;;; Features of cities
;;;
;;; size      pop.       temp.      humdty      beach      alt 
;;; terrn     rain       air-p      scnry       e.q.       hurrcn
;;; snow      park       hstry      trffc       l-e        jobs 
;;; h-c       h-t-i      c-r        museums     thtr       trsp
;;; ppl       tax        unv        n-c         sports     rest 
;;;================================================================

(setf *domains*
      '((small medium large) (low medium high) (low medium high)
        (dry normal humid) (yes no) (low medium high) (hilly flat)
        (rare normal heavy) (yes no) (good normal awful)
        (yes no) (yes no) (yes no) (few average many) (old new)
        (normal heavy) (low medium high) (few average many)
        (good normal bad) (yes no) (low medium high) (few average many)
        (few average many) (none bus bus-subway) (rude aloof friendly)
        (low medium high) (few average many) (few average many)
        (few average many) (few average many)
        ))

(setf *feature-names*
      '(size population temperature humidity beaches altitude
        terrain rainfall air-pollution scenery earth-quakes hurricanes
        snow parks history traffic living-expense job-opportunity
        health-care high-tech-industry criminal-rate museums
        theater-concerts public-transportation people sales-tax
        universities nightclub sport-activities restaurants
        ))

(setf locations

; LA
  '((- (large    high     medium   normal     yes
        low      flat     rare     yes        normal
        yes      no       no       few        new
        heavy    high     many     normal     yes
        high     average  many     bus        aloof
        medium   many     many     average    many)) 

; Austin
    (+ (medium   medium   high     dry        no
        low      flat     rare     no         normal
        no       yes      no       many       new
        normal   low      average  good       yes
        low      few      average  bus        friendly
        high     average  average  many       many)) 

; New York
    (- (large    high     low      humid      no
        low      flat     normal   yes        normal
        no       no       yes      few        new
        heavy    high     many     normal     yes
        high     average  many     bus-subway aloof
        medium   many     many     few        many)) 

; Seattle
    (+ (large    medium   medium   normal     yes
        low      flat     normal   no         good
        no       no       yes      average    new
        normal   high     many     good       yes       
        medium   average  many     bus        friendly
        medium   average  average  many       many))
 
; San Francisco
    (+ (large    high     medium   humid      no
        low      hilly    heavy    yes        good
        yes      no       yes      average    new
        heavy     high     many     normal     yes
        high     many     many     bus-subway aloof
        medium   many     many     average    many))

; Las Vegas
    (- (medium   medium   medium   dry        no
        low      flat     rare     no         normal
        no       no       yes      few        new
        normal   medium   few      normal     no
        medium   few      average  none       aloof
        medium   few      many     few        many))

; San Diego
    (+ (medium   medium   medium   normal     yes
        low      flat     rare     no         normal
        no       no       no       average    new
        normal   medium   average  normal     no
        medium   average  average  bus        aloof
        medium   average  many     average    many))
 
; Hsilo, Taiwan
    (- (small    low    medium   humid       no
        low      flat     normal   no         normal
        yes      yes      no       few         new
        normal   medium   few      normal     no
        low      few      few      bus        aloof
        low      few      average  average    average))
 
; Taipei, Taiwan
    (- (large    high     medium   humid      no
        low      flat     normal   yes        normal
        yes      yes      no       average    new
        heavy    high     many     normal     no
        medium   average  many     bus        aloof
        low      many     many     average    many))

; Santa Babara
    (+ (medium   medium   medium   normal     yes
        low      flat     rare     no         good
        yes      no       no       average    new
        normal   medium   average  normal     no
        low      few      average  none       friendly
        medium   average  average  average    average)) 

; Boston
    (+ (large    high     medium   humid      yes
        low      flat     normal   yes        normal
        no       no       yes      average    old
        heavy    high     average  normal     yes
        high     many     average  bus-subway aloof
        medium   many     many     many       many))

; Pasadena, CA
    (+ (medium   medium   medium   dry        no
        low      hilly    normal   yes        good
        yes      no       no       few        new
        normal   medium   few      normal     no
        medium   average  few      bus        aloof
        high     average  few      few        average))

; Singapore
    (+ (large    high    high     humid      yes
        low      flat     normal   no         good
        no       no       no       many       old
        normal   medium   average  normal     yes
        medium   average  many     bus-subway aloof
        medium   few      many     average    many))

; Zurich, CH
    (+ (large    medium   low      normal     no
        medium   hilly    normal   no         good
        no       no       yes      many       old
        normal   high     average  good       no
        medium   many     many     bus        aloof
        medium   average  few      few        average))

; Ft. Collins, CO
    (- (medium   low      low      dry        no
        high     hilly    normal   no         good
        no       no       yes      average    new
        normal   low      few      normal     yes
        low      few      few      none       aloof
        low      few      few      few        few))

; Kaanapali, HI
    (- (small    low      high     dry        yes
        low      hilly    rare      no         good
        no       no       no       many       new
        normal   high     few      normal     no
        low      few      few      none       friendly
        high     few      many     average    average))



; Santa Clara, CA
    (- (medium   medium   medium   normal     no
        medium   flat     normal   yes        normal
        yes      no       no       average    new
        heavy    high     many     normal     yes
        medium   few      few      bus        friendly
        high     few      few      few        average))


; London, England
    (+ (large    high     medium   dry        no
        low      flat     heavy    yes        normal
        no       no       yes      many       old
        heavy    high     average  good       no
        high     many     many     bus-subway aloof
        high     many     many     many       many))


; New Orleans, LA
    (+ (large    medium   high     humid      no
        low      flat     normal   no         normal
        no       yes      no       many       old
        normal   medium   few      normal     no
        medium   average  average  bus        friendly
        low      average  many     many       many))

; Dallas
    (- (large    high     high     normal     no
        medium   flat     normal   no         normal
        no       no       no       average    new
        heavy    medium   many     normal     yes
        high     average  many     bus        friendly
        high     average  many     many       many))

; Palo Alto
    (+ (small    low      medium   humid      no                
        medium   hilly    heavy    no         good
        yes      no       no       average    new
        normal   high     average  normal     yes
        low      few      few      none       friendly
        medium   few      few      few        few))

; Sachse, Tx
    (- (small    low      high     normal     no
        medium   flat     normal   no         awful
        no       no       no       few        new
        normal   low      few      normal     no
        low      few      few      none       friendly
        medium   few      few      few        few))

; Denver
    (+ (large    high     low      dry        no
        high     hilly    normal   yes        good
        no       no       yes      average    new
        heavy    high     many     normal     yes
        medium   average  many     bus        friendly
        high     average  average  many       average))

; Paris
    (- (large    high     high     normal     no
        medium   flat     normal   yes        normal
        no       no       no       average    old
        normal   high     many     normal     no
        high     many     many     bus-subway rude
        medium   average  many     average    many))

; Orlando, Fla
    (+ (medium   medium   high     humid      yes
        low      flat     heavy    no         good
        no       no       no       average    new
        normal   medium   average  normal     no
        low      few      few      none       friendly
        low      few      few      average    average))

; Detroit 
    (- (large    high     low      normal     no
        medium   flat     normal   yes        awful
        no       no       yes      average    new
        heavy    medium   many     normal     yes
        high     average  average  bus        aloof
        medium   few      many     many       many))

; Legrange, Tx.
    (+ (small low high normal no medium hilly normal
        no good no no no average old normal low few
        normal no low few few none friendly high few
        few few few))

; Ann Arbor, MI
    (+ (medium medium low dry no medium hilly normal
        no good no no yes many old normal medium many
        good no low average average bus friendly medium few
        average average average))

; Joplin, Mo.
    (- (small low medium normal no medium hilly normal
        no normal no no yes average old normal low
        average normal no low average average bus friendly
        medium average average average average))

; Omaha, Neb.
    (- (large medium medium normal no medium hilly
        heavy no normal no no yes average old normal
        medium average normal yes medium average average
        bus friendly medium average average average average))

; St. Paul, MN
    (- (medium medium medium dry no low flat normal no
        good no no yes many old normal medium many
        good yes medium many many bus friendly
        medium many many many many))

; Springfield, Mo.
    (- (medium medium medium humid no medium hilly
        normal no good no no yes average old
        normal low average normal no low average average
        bus friendly medium average average average average))

; Williamstown, Mass.
    (- (large low low dry no low hilly normal no
        good no no yes average old normal low few
        good no low many few none friendly low average average
        average average))

; Madison, Wi
    (- (small low medium normal yes medium flat normal
        no good no no yes many new normal low many good
        no low few few bus friendly low many average few few))

; Chicago
    (- (large high medium normal yes medium flat normal
        yes good no no yes many old heavy high many good
        yes high many many bus-subway friendly high few
        many many many))

; Newark, NJ.
    (- (medium medium medium normal no medium flat normal
        yes awful no no yes few old heavy medium few bad
        yes high few few bus rude high few few few few))

; San Antonio
    (+ (medium medium high humid no medium flat normal yes
        good no no no many old normal low average normal
        yes medium average average bus friendly low few
        many average average))

; Milwaukee, Wi.
    (- (large high low dry no medium flat normal yes awful
        no no yes average old heavy medium average normal
        yes high few average bus friendly medium few average
        many average))

; Houston
    (+ (large high high humid no low flat normal yes normal
        no yes no average old heavy low few normal yes high
        average many bus friendly low few many many many))

; Waco, Tx
    (- (small low high normal no medium flat normal no awful
        no no no average new normal low average normal no low
        few few bus friendly low few few few few))

; Lafayette
    (- (small low low dry no medium hilly rare no normal no
        no yes few new normal medium few bad no medium few
        few bus aloof high few few few few))

; Miami
    (- (large high high humid yes low flat normal yes awful
        no yes no few new heavy high few bad no high few few
        bus rude high average many average average))

; Washington D. C.
    (+ (large high low dry no high hilly rare no good no no
        yes many old normal high average good no low many
        many bus friendly medium average average few average))

; Lubbock
    (- (small low high dry no medium hilly rare no normal
        no yes no few new normal medium few normal
        no medium few few bus aloof high few few few few))

; Eugene
    (+ (medium medium low normal no high hilly normal no
        good no no yes many old normal medium average good
        no low few many bus friendly medium few average many many))

; Bombay
    (- (large high high humid yes low flat heavy yes awful no
        yes no few old heavy high few bad yes high average average
        bus-subway friendly high few few many many))

; HongKong
    (+ (large high high humid yes low hilly heavy yes good no
        yes no average old heavy medium many good yes low average
        average bus-subway rude low few many few many))

; Tokyo
    (- (large     high       medium     humid       yes        low  
        flat      normal     yes        awful       yes        yes
        yes       few        old        heavy       high       many 
        good      yes        low        many        many       bus-subway
        aloof     high       many       many        few        many))

; Kyoto
    (+ (medium    medium     medium     humid       no         medium
        hilly     normal     yes        good        no         yes
        yes       many       old        heavy       high       average
        good      yes        low        many        average    bus-subway
        aloof     high       many       many        average    many))

; Providence
    (+ (small     low      low        dry         yes        low
        hilly     normal     no         good        no         yes
        yes       many       old        normal      medium     few
        normal   no         high       average     average    bus
        aloof     medium     average    few         average    average))

; Poughkeepsie
    (- (small     low      low        dry         no         medium
        flat      normal     no         normal      no         yes
        yes       many       new        normal      medium     average
        normal   yes        medium     average     average    bus
        aloof     medium     few        few         average    many))

; Kansas City
    (- (medium medium medium dry no medium flat rare
        no awful no yes yes few new normal low few
        normal no low few few bus friendly low few
        few few few))

; white water, WI 
    (+(small low medium normal no medium hilly
       normal yes good no yes yes average old normal
       low average normal yes medium average average
       bus rude medium average average many average))

;; MADRID
    (- (large high medium 
        normal no medium 
        flat normal yes 
        normal no no 
        no average old
        heavy medium average
        normal yes high 
        many many bus-subway
        rude low many 
        many average many
        ))

;; BARCELONA
    (+ (medium medium high
        normal yes medium 
        hilly normal no 
        good no no 
        no many old 
        normal low average
        normal yes medium  
        average many bus-subway
        friendly low average 
        average average many
        ))

;; ROCHESTER, MINNESOTA
    (+ (small medium low
        normal no medium 
        flat normal no 
        good no no 
        yes  many new
        normal low average 
        good yes low 
        few average bus
        friendly medium few 
        few average average
        ))

;; NEW REIGEL, OHIO
    (- (small low low 
        normal no  medium  
        flat normal no 
        normal no no 
        yes few old 
        normal low few
        normal no low  
        few few none 
        friendly medium few 
        few few few 
        ))

;; TORRE DEL MAR, SPAIN
    (- (small low high
        normal yes low  
        flat rare no 
        awful no no 
        no few new
        normal medium few 
        bad  no high 
        few few bus
        aloof medium few 
        average few many
        ))

; Sacramento
    (+ (small low high normal no medium hilly normal no good
        no no no many old normal low average good yes
        low few average bus friendly high average average many average))

; Baton-Rouge
    (- (large high medium normal yes low hilly normal yes awful
        yes no no average old heavy high many normal yes
        high average many bus rude medium many many average many))

; Boulder
    (+ (medium medium low normal no high hilly heavy no good
        no no yes many new normal medium average normal yes
        low few average bus aloof medium few few many average))

; Rio de Janeiro
    (+ (Large High High Humid Yes Low Hilly                    
        Heavy Yes Good No No No Average Old 
        Heavy Low Average Normal No High Many Many 
        Bus-Subway Rude Low Many Many Many Many))

; Sao Paulo
    (+ (Large High Medium Normal Yes Medium Flat
        Normal Yes Awful No No No Few New 
        Heavy Low Many Normal Yes High Average Many 
        Bus-Subway Aloof Low Many Many Many Many))

; Mexico City
    (+ (Large High Medium Dry No High Flat
        Normal Yes Awful Yes No Yes Average Old 
        Heavy Low Average Normal No High Many Many 
        Bus Aloof Low Many Average Average Many))

; Buenos Aires
    (+ (Large High Medium Humid Yes Low Flat
        Heavy Yes Normal No No Yes average Old 
        Heavy Low Average Normal No High Many Average 
        Bus Aloof Low Average Average Average Many))

; Pittsburgh
    (- (medium medium medium normal no  medium
	hilly normal yes good no no
	yes  many  new normal medium  many
	good yes medium many many bus
	friendly medium average average many many))
))

;;; *****************************
;;; Justin Boyan, 9/27/93:

;;; the following hack converts cities data into compact digit strings
(defun format-city (city)
  (do ((numeric-string nil)
       (f (cadr city) (cdr f))
       (dom *domains* (cdr dom)))
      ((null f) (coerce (reverse numeric-string) 'string))
    (push (character (+ 48 (position (car f) (car dom))))
	  numeric-string)))

(defun format-city-1inN (city)
  (do ((numeric-string nil)
       (f (cadr city) (cdr f))
       (dom *domains* (cdr dom)))
      ((null f) (coerce (reverse numeric-string) 'string))
    (setf numeric-string
	  (append 
	   (do ((bitlist nil)
		(d (car dom) (cdr d)))
	       ((null d) bitlist)
	     (push (if (eq (car d) (car f)) #\1 #\0)
		   bitlist))
	   ; '(#\SPACE)
	   numeric-string))))
	

; (setf strings (mapcar #'format-city locations))
; (mapc #'(lambda (s) (format t "~%~A" s)) strings)
; cut-n-paste results to cities.data


(defun make-latex-table ()
  ; # & #--# & feature-name & value & value & value \\
  (let ((i1 0)
	(i2 0))
    (do ((v *domains* (cdr v))
	 (n *feature-names* (cdr n))
	 )
	((null v))
      (format t "~%~T~A & ~A--~A & ~A &  ~A & ~A & ~A \\\\"
	      i1
	      i2
	      (+ i2 (length (car v)) -1)
	      (car n)
	      (caar v)
	      (cadar v)
	      (or (caddar v) "")
	      )
      (incf i1)
      (incf i2 (length (car v)))
      )))
