@Make(Text) @Style(FileDate "March 8, 1952")
@Define[IndFmt=Format, LeftMargin +4]
@Modify[Subheading, Above 1, Need 3]
@Modify[Itemize, Below 0, Break After]

@Define(AdminNote1=Text, FaceCode P)
@Equate(AdminNote = Comment)

@Heading[Lecture Schedule and Syllabus for
15-882A:  Introduction to Artificial Neural Networks]

@center[
@b[Dave Touretzky, Scott Fahlman, Alex Waibel, and Dean Pomerleau
Teaching Assistant:  Justin Boyan]

Version of @value[filedate]
This is file /afs/cs/project/connect/intro-course/handouts/syllabus.mss.
]

@blankspace(1 lines)

@Subheading[Basic Information]

@Format[@tabclear()@tabset(.65inch)
@b[Dates:]@\ September 13 though December 1, 1993
@b[Time:]@\ Mondays and Wednesdays, from 12:00 to 1:20
@b[Place:]@\ Wean Hall 5409
@b[Credit:]@\ 12 units (or core unit credit for CS grads) if you do a project and take the final exam
@b[Grading:]@\ 20% homeworks; 30% final exam; 50% research project
@b[BBoard:]@\ cmu.cs.class.cs882
]

@b[Textbook:] Introduction to the Theory of Neural Computation.  By J.
Hertz, A. Krogh, and R. G. Palmer.  Addison Wesley, 1991.

@b[Readings:] two binders of course readings are on reserve in the E&S
Library on the fourth floor of Wean Hall.  The books by Hertz, Krogh &
Palmer; Rumelhart & McClelland (the PDP book); Duda & Hart; and Churchland
are also on reserve.

@b[Course directory:] the directory @t[/afs/cs/project/connect/intro-course]
contains the latest version of this syllabus and several other useful
files.  Software resides in the @t[simulators/] subdirectory.

@b[Research project:] for those taking the course for credit, there will be
a research project involving the computer.  Research projects must be
approved in advance by one of the instructors.  Students are encouraged to
meet with the instructors for help in finding good research projects.

@blankspace(2 lines)
@Subheading[Instructor Info:]
@itemize[
Dave Touretzky (dst@@cs, WeH 8128, x8-7561): computational neuroscience;
connectionist knowledge representation; linguistics.

Scott Fahlman (sef@@cs, WeH 3210, x8-2575): learning algorithms; hardware
and software for high-performance implementations.

Alex Waibel (ahw@@cs, WeH 4608, x8-7676): speech and language processing;
multi-modal interfaces; pattern recognition.

Dean Pomerleau (pomerlea@@cs, WeH 1309, x8-3210): visually-guided control;
multi-modal interfaces.

Justin Boyan (jab@@cs, WeH 5123, x8-5728): reinforcement learning.]

@newpage()
@Subheading<Monday, Sept. 13:  Pattern Recognition 1  [Waibel]>
@itemize[
 Duda, R. O., and Hart, P. E.  @i[Pattern Classification and Scene
Analysis], John Wiley & Sons, 1973.  (On reserve.)]

@IndFmt[
  Study in depth sections 2.1-2.8, 3.1-3.2, 4.4, and 4.10.
  Skim remainder of chapters 2, 3 and 4 (pp. 10 - 129).]


@Subheading<Wednesday, Sept. 15:  Pattern Recognition 2 [Waibel]>
@itemize[
 Chapters 5 and 6 of Duda & Hart.]
@IndFmt[
  Study sections 5.1-5.8, 6.1, 6.2, 6.6, 6.7, and 6.10.
  Skim remainder of chapters 5 and 6 (pp. 130 - 260).]

@Subheading<Monday, Sept 20:  Backprop 1 [Fahlman]>
@AdminNote<Alex out of town>
@itemize[
@Multiple{
 Hertz, J., Krogh, A., and Palmer, R. G.  @i[Introduction to the Theory of
Neural Computation.]  Addison Wesley, 1991.  (Course text; on reserve.
Hereafter HK&P.)

  HK&P sections 5.4, 6.1, 6.2, and 6.3.}

Optional: Rumelhart, D. E., Hinton, G. E, and Williams, R. J. Learning
internal representations by error propagation.  In D. E. Rumelhart and J.
L. McClelland (eds.), @i[Parallel Distributed Processing: Explorations in
the Microstructure of Cognition], chapter 8.  MIT Press, 1986.  (On
reserve.)
 ]

@Subheading<Wednesday, Sept. 22:  Perceptrons, and Simulators [Touretzky/Boyan]>
@AdminNote<Scott in Munich; Alex in Berlin>
@itemize[
 HK&P chapter 5.

McClelland, J. L., and Rumelhart, D. E. (1988) @i[Explorations in Parallel
Distributed Processing: A Handbook of Models, Programs, and Exercises.]
MIT Press.  (On reserve.  Accompanying software will be found in the
@t[simulators/] directory.)

  SNNS simulator documentation (online).]

@Subheading<Monday, Sept. 27:   Competitive Learning/ART [Touretzky]>

@itemize[
 HK&P chapter 9.

 Carpenter, G. A., Grossberg, S., and Reynolds, J. H. (1991) ARTMAP:  Supervised
real-time learning and classification of nonstationary data by a
self-organizing neural network.  @i[Neural Networks] 4(5):565-588.]

You'll find chapter 9 of HK&P rather terse.  For expanded treatments, see
the following:

@itemize[
Rumelhart & McClelland, chapter 5, ``Feature Discovery by Competitive
Learning.''

Carpenter, G. A., and Grossberg, S. (1988) A massively parallel
architecture for a self-organizing neural pattern recognition machine.
Reprinted in S.  Grossberg (ed.), @i[Neural Networks and Natural
Intelligence].  MIT Press.

Grossberg, S. (1987) Competitive learning: from interactive activation to
adaptive resonance.  @i[Cognitive Science] vol. 11, no. 1, pp. 23-63.
@i[(This is very similar to the preceding article, but somewhat easier to
read.  Skim the introduction section.)]

Hecht-Nielsen, R. (1987) Counter-propagation networks.  @i[Applied Optics],
vol. 26, no. 23, pp. 4979-4984.
 ]

@Subheading<Wednesday, Sept. 29:  ALVINN and SM@+[2] [Pomerleau]>
@AdminNote<Waibel, Fahlman not here>
@itemize[
Pomerleau, D.A. (1991) Efficient Training of Artificial Neural Networks
for Autonomous Navigation.  @i{Neural Computation} 3:1, pp. 88-97.

Pomerleau, D.A. (in press) Neural Network Based Vision for Precise Control of
a Walking Robot. To appear in a special issue of @i{Machine Learning}. Alex
Waibel (Ed.).
 ]

@Subheading<Monday, Oct. 4:  Speech 1 [Waibel]>
@AdminNote<Dean out of town>
@itemize[
 Waibel, A. H., and Lee, K.-F. (eds.) (1990) @i[Readings in Speech
Recognition.]  (On reserve.)  Read intro to chapter 7, and sections 7.1 and
7.2.  Skim the rest of chapter 7.]

@Subheading<Wednesday, Oct. 6:   Speech 2 [Waibel]>
@itemize[
 Continue skimming chapter 7 of Waibel & Lee.]

@Subheading<Monday, Oct. 11:  @i[no class (mid-semester holiday)]>

@Subheading<Wednesday, Oct. 13:  OCR and Handwriting Recognition [Waibel]>
@itemize[
 LeCun, Y., Boser, B., Denker, J. S., Henderson, D., Howard, R. E., Hubbard, W.,
and Jackel, L. D.  Backpropagation applied to handwritten zip code recognition.
@i[Neural Computation] 1:4, pp. 541-551.

 Guyon, I., et al. (Handwriting recognition network from Bell Labs.  Full
reference to follow.)
 ]

@Subheading<Monday, Oct. 18:  Backprop 2 [Fahlman]>
@AdminNote(Justin out of town)
@itemize[
  HK&P sections 6.4 and 6.6.

  Fahlman, S. E. (1988) ``An Empirical Study of Learning Speed in Back-Propagation
  Networks,'' technical report CMU-CS-88-162.

  Fahlman, S. E., and Lebiere, C. (1990) ``The Cascade-Correlation Learning Algorithm,''
  technical report CMU-CS-90-100.]

@Subheading<Wednesday, Oct. 20:  Hopfield Nets and Boltzmann Machines  [Fahlman]>
@AdminNote(Justin out of town)
@itemize[
  HK&P sections 2.1, 2.2, 4.1, 4.2, 7.1.]

@Subheading<Monday, Oct. 25:  Reinforcement Learning [Boyan]>
@itemize[
  HK&P section 7.4.

  Lin, L.-J. (1990) ``Self-improving reactive agents: case studies of
reinforcement learning frameworks.''  Technical report CMU-CS-90-109.

  Tesauro, G. (1992) Practical issues in temporal difference learning.
@i[Machine Learning], May 1992.

  ]

@Subheading<Wednesday, Oct. 27:  Basic Neurophysiology [Touretzky]>
 @itemize[
 Churchland, P. S. (1986) @i[Neurophilosophy].  Cambridge, MA: Bradford
Books/The MIT Press.  Chapter 2, ``Modern Theory of Neurons.'']

@Subheading<Monday, Nov. 1:  Recurrent Nets 1  [Touretzky]>
@itemize[
HK&P section 7.3 up to the middle of p. 184.   Gives an overview of the topic.

 Rumelhart, D. E., Hinton, G. E, and Williams, R. J. (1986) Learning
internal representations by error propagation (just pages 354-362).  In D.
E.  Rumelhart and J.  L. McClelland (eds.), @i[Parallel Distributed
Processing: Explorations in the Microstructure of Cognition].  MIT Press.
(On reserve.)

Elman, J. L. (1991) Distributed representations, simple recurrent networks,
and grammatical structure.  @i[Machine Learning] 7(2,3):195-225.

McClelland, J. L., St. John, Mark D. and Taraban, R.   (1989). Sentence
comprehension: a parallel distributed processing approach.   Language
and Cognitive Processes, 4, SI 287-335.
 ]

@Subheading<Wednesday, Nov. 3:  Recurrent Nets 2 [Touretzky]>
@Itemize[
 Pollack, J. B. (1990) Recursive distributed representations.  @i[Artificial
Intelligence] 46.

Chalmers, D. J.  (1990) Syntactic transformations on distributed representations.
@i[Connection Science] 2(1,2):53-62.

 HK&P section 7.2, and section 7.3 pp. 184-187.

  Churchland, P. S., and Sejnowski, T. J. @i[The Computational Brain.]  MIT
Press, 1992.  Section 6.2, ``LeechNet.''
 ]

@Subheading<Monday, Nov. 8: Neurobiology of the Visual System [Pomerleau]>
@itemize[
 Churchland, P. S., and Sejnowski, T. J. @i[The Computational Brain.]  MIT
Press, 1992.  Chapter 4, ``Representing the World.''
 ]

@Subheading<Wednesday, Nov 10:  Connectionist Vision [Pomerleau]>
 @itemize[
 Ballard, D. H. (1984) Parameter nets.  @i[Artificial Intelligence],
22:235-267.

Ballard, D. H., Hinton, G. E., and Sejnowski, T. J. (1983) Parallel
visual computation.  @i[Nature], 306:21-26.

Hinton, G. E. and Lang, K. (1985) Shape recognition and illusory
conjunctions.  Proceedings of the 9th International Joint Conference on
Artificial Intelligence, Los Angeles, CA, pp. 252-259.]

@Subheading<Monday, Nov. 15:  Language Processing [Touretzky]>
@itemize[
 Jain, A. N. (1991) Parsing complex sentences with structured
connectionist networks.  Neural Computation 3(1):110-120.

Miikkulainen, R. (1990) A PDP architecture for processing sentences with
relative clauses.  In Karlgren, H. (ed.), Proceedings of the 13th
International Conference on Computational Linguistics, pp. 201-206.
Helsinki, Finland: Yliopistopaino.

Gorin, A. L., S. E. Levinson, A. Ljolje, A. N. Gertner, E. R. Goldman, and
L. Miller (1990) On adaptive acquisition of language.  In Proceedings of
the 1990 IEEE International Conference on Acoustics, Speech, and Signal
Processing.
 ]

@Subheading<Wednesday, Nov. 17:  Hardware and Simulators [Fahlman]>
@AdminNote<Waibel not here>
@itemize[
 D. A. Pomerleau, G. L. Gusciora, D. S. Touretzky, and H. T. Kung, (1988) neural
network simulation at Warp speed: How we got 17 million connections per
second. Proceedings of IEEE International Conference on Neural Networks,
1988.

 Telfer, B., and Casasent, D. (1991) Neural closure associative processor.
@i[Neural Networks] 4(5):589-598.
 ]

@Subheading<Monday, Nov. 22:  Distributed Representations [Touretzky]>
@itemize[
Touretzky, D. S. and Hinton, G. E.  (1988) A distributed connectionist
production system.  @i[Cognitive Science], vol. 12, number 3, pp. 423-466.
 ]

@Subheading<Wednesday, Nov. 24:  @i[Thanksgiving Recess -- no class]>
@AdminNote<Waibel not here>

@Subheading<Monday, Nov. 29:  Structured Connectionist Modeling [Nigel Goddard]>
@AdminNote<Waibel, Touretzky, Fahlman, Pomerleau not here (NIPS)>
@itemize[
@Multiple[
 Feldman, J.A., Fanty, M.A., Goddard, N.H. and Lynne, K.J. (1988).
Computing with Structured Connectionist Networks.  @i[Communications of the
ACM], February 1988, pp.170-187.  Also in Zornetzer, S.F., Davis, J.L and
Lau, C. (Eds.), @i[An Introduction to Neural and Electronic Networks]
Academic Press, 1990, pp. 433-454.

Can skip sections on simulator (pp. 173-181 in CACM or pp. 438-447 in the book).]

Shastri, L. (1992). Neurally motivated constraints on the working memory
capacity of a production system for parallel processing: Implications of
a connectionist model based on temporal synchrony.  Proceedings Fourteenth
Annual Conference of the Cognitive Science Society, pp 159-164.

Goddard, N.H. (1993). Associating what and where using temporal cues.
Proceedings 15th Annual Conference of the Cognitive Science Society, pp.
469-474.]

@Subheading<Wednesday, Dec. 1:  @i[No class (NIPS conference)]>
@AdminNote<Waibel, Touretzky, Fahlman, Pomerleau, Boyan not here (NIPS)>

@Subheading<Tuesday, Dec. 7:  Final Exam>
 The exam is scheduled for 5:30 to 8:30 PM in Wean Hall 5409.

@begin[comment]

*** OLD STUFF FROM THE 1991 COURSE ***

@Subheading<Tuesday, Nov. 5:  Language 3 [Plaut]>
@AdminNote<Thesis summary>
@itemize[
Hinton, G. E. and Shallice, T. (1991) Lesioning an attractor network:
	Investigations of acquired dyslexia.  Psychological Review, 98(1),
	74-95.

Plaut, D. C. and Shallice, T. (1991) Effects of abstractness in a connectionist
	model of deep dyslexia.  Proceedings of the 13th Annual Meeting of the
	Cognitive Science Society, pages 73-78, Chicago, IL.
 ]

@Subheading<Tuesday, Nov. 19:  Symbolic Connectionism 1 [Touretzky]>
@AdminNote<DCPS, tensor products, circular convolution>
@itemize[
 Touretzky, D. S., and Hinton, G. E. (1988) A distributed connectionist
production system.  @i[Cognitive Science] 12, 423-466.

 Dolan, C. P., and Smolensky, P. (1989) Tensor product production
system: a modular architecture and representation.  @i[Connection
Science] 1, 53-68.

 Plate, T. (1991) Holographic reduced representations:  convolution
algebra for compositional distributed representations.  @i[Proceedings
of IJCAI-91], pp. 30-35.
 ]

@Subheading<Thursday, Nov. 21:  Symbolic Connectionism 2 [Wan]>
@AdminNote<RAAMs, Chalmers, van Gelder>
@AdminNote<Waibel not here>
@itemize[
 van Gelder, T. (1990) Compositionality:  a connectionist variation on a
classical theme.  @i[Cognitive Science] 14(3):355-384.]


**************** currently unused stuff

 Mozer, M. C., and Bachrach, J. (1991) SLUG: a connectionist architecture
for inferring the structure of finite-state environments.  @i[Machine Learning]
7(2,3):139-160.

 Gasser, M., and Lee, C.-D. (1991) A short-term memory architecture for the
learning of morphophonemic rules.  In R. P. Lippmann, J. Moody, and D. S.
Touretzky (eds.), @i[Advances in Neural Information Processing Systems 3],
605-611.  San Mateo, CA:  Morgan Kaufmann.

Elman, J. (1990).  Finding structure in time.  Cognitive Science, 14, 179-212.


@end[comment]
