

UNIT ClasInst; {Classical_Instructor}
{
This unit provides a critique of note sequences based on a data file of
example sequences, 'SEQUENCE.DAT'.
}
{

Copyright 1989 by Wesley R. Elsberry.  All rights reserved.

Commercial use of this software is prohibited without written consent of
the author.

For information, bug reports, and updates contact

Wesley R. Elsberry
528 Chambers Creek Drive South
Everman, Texas 76140
Telephone: (817) 551-7018

}


INTERFACE

USES DOS, misc1, ANSI_Z, globals;

{General}
FUNCTION Classical_instructor(Seq : Notes_):INTEGER;
{This function does a look-up of a sequence of notes and returns a 1 if it
 is a listed sequence, a 0 if it is not recognized as being a classical
 sequence.  This function is used in the training of Salieri, the PDP network.}


IMPLEMENTATION

 CONST
    Max_Seq = 100;

 TYPE
    N_str_ = STRING[v_len_in];
    N_Str_Ary_Ptr_ = ^N_Str_Ary_;
    N_Str_Ary_ = ARRAY[1..Max_Seq] OF N_Str_;

 CONST
    Seq_Table : N_Str_ary_ptr_ = NIL;
    Number_of_seqs : INTEGER = 0;

 VAR
    Target, Instring : N_Str_;
    Inf : TEXT;
    Inchar : CHAR;
    ii, jj : INTEGER;
    Found : BOOLEAN;
    nchar : CHAR;

 FUNCTION Classical_instructor(Seq : Notes_):INTEGER;
{This function does a look-up of a sequence of notes and returns a 1 if it
 is a listed sequence, a 0 if it is not recognized as being a classical
 sequence.  This function is used in the training of Salieri, the PDP
 network.}

{Determine if a sequence of notes can be considered to be classical in
 form.  Does this by executing a look-up matching against the last
 n notes in the passed-in sequence.  Returns 0 if not found, 1 if found.

 Requires the following TYPE definition:

   Notes_ = ARRAY[1..v_len_in] OF INTEGER;
 }

    BEGIN                          {Classical_instructor}

  {Convert notes to string representation}
       Target := '';               {Clear string}
       FOR ii := 1 TO v_len_out DO BEGIN
          nchar := Chr(seq[ii]+48);
          Target := Target + nchar;
          END;

       ANSI_CUP(0,39);
       Write('Classical_Instructor: Target: ',target);
       ANSI_CUP(23,0);
  {Run through possible sequences, mark if found}
       ii := 1;
       Found := FALSE;
       REPEAT                      {}
          jj := Length(Seq_Table^[ii]);
          Found := (Copy(Target,v_len_out-jj+1,jj) = Seq_Table^[ii]);
          ii := ii + 1;
          UNTIL (ii>Number_of_seqs) OR (Found);
                                   {}

       IF (Found) THEN             {Return 1}
            BEGIN
          Classical_instructor  := 1;
          END
       ELSE                        {Return 0}
            BEGIN
          Classical_instructor := 0;
          END;

       END;                        {Classical_instructor}

BEGIN
      ii := 1;
      NEW(Seq_Table);			{Allocate space for table}
      ASSIGN(Inf,'SEQUENCE.DAT');	{Set up to read data}
      RESET(Inf);
      WHILE (NOT EOF(Inf)) AND (ii <= Max_Seq) DO	{Get data, put in table}
        BEGIN
          READLN(Inf,Seq_Table^[ii]);
          ii := ii + 1;
        END;
      CLOSE(Inf);
      Number_of_seqs := ii - 1;
END.

