UNIT ANSI_Z;
{
This unit provides certain ANSI and VT-52 screen control functions.
}
{

Copyright 1989 by Wesley R. Elsberry.  All rights reserved.

Commercial use of this software is prohibited without written consent of
the author.

For information, bug reports, and updates contact

Wesley R. Elsberry
528 Chambers Creek Drive South
Everman, Texas 76140
Telephone: (817) 551-7018

}


INTERFACE

USES DOS, MISC1;

TYPE
  ANSI_MODE_ = (NULL_,ANSI_,VT52_,IBM_PC_);

CONST
  ANSI_MODE : ANSI_MODE_ = ANSI_;

PROCEDURE ANSI_CLRSCR;
{Clear the screen using ANSI control}

PROCEDURE ANSI_CUU(VAR ii : INTEGER);
{Cursor up}

PROCEDURE  ANSI_CUD(VAR ii : INTEGER);
{Cursor down}

PROCEDURE  ANSI_CUF(VAR ii : INTEGER);
{Cursor forward or right}

PROCEDURE  ANSI_CUB(VAR ii : INTEGER);
{Cursor backward or left}

PROCEDURE  ANSI_EEOL;
{Erase to End Of Line (VT52)}

PROCEDURE  ANSI_CUH;
{Cursor home}

PROCEDURE  ANSI_CUP(line, col : INTEGER);
{Cursor position}



IMPLEMENTATION


 TYPE
    Position_ = RECORD
       l : BYTE;
       c : BYTE;
       END;

 CONST
    C_pos : Position_ = (l : 0;
    c : 0);

 VAR
    inch : CHAR;

{  ANSI Control sequences

ESC [ Pn ; Pn R         -> Cursor Position Report       (CPR)
ESC [ Pn D              -> Cursor Backward              (CUB)
ESC [ Pn B              -> Cursor Down                  (CUD)
ESC [ Pn C              -> Cursor Forward               (CUF)
ESC [ Pn ; Pn H         -> Cursor Position              (CUP)
ESC [ Pn A              -> Cursor Up                    (CUU)
ESC [ Pn c              -> Device Attributes            (DA)
ESC # 8                 -> Screen Alignment Display     (DECALN)
ESC Z                   -> Identify Terminal            (DECID)
ESC =                   -> Keypad Application Mode      (DECKPAM)
ESC >                   -> Keypad Numeric Mode          (DECKPNM)
ESC 8                   -> Restore Cursor               (DECRC)
ESC [ <sol> ; <par> ; <nbits> ; <xspeed> ; <rspeed> ; <clkmul> ; <flags> x
                        -> Report Terminal Parameters   (DECREPTPARM)
ESC [ <sol> x           -> Request Terminal Parameters  (DECREQTPARM)
ESC 7                   -> Save Cursor                  (DECSC)
ESC [ Pn ; Pn r         -> Set Top and Bottom Margins   (DECSTBM)
ESC [ Ps n              -> Device Status Report         (DSR)
ESC [ Ps J              -> Erase in Display             (ED)
ESC [ Ps K              -> Erase in Line                (EL)
ESC H                   -> Horizontal Tabulation Set    (HTS)
ESC [ Pn ; Pn f         -> Horizontal and Vertical Position (HVP)
ESC D                   -> Index                        (IND)
ESC E                   -> Next Line                    (NEL)
ESC M                   -> Reverse Index                (RI)
ESC c                   -> Reset to Initial State       (RIS)
ESC [ Ps ; Ps ; ... ; Ps l  -> Reset Mode               (RM)
ESC ( A | B | 0 | 1 | 2     -> Select Character Set     (SCS)
ESC [ Ps ; ... ; Ps m   -> Select Graphic Rendition     (SGR)
ESC Ps ; ... Ps h       -> Select Mode                  (SM)
ESC [ Ps g              -> Tabulation Clear             (TBC)


VT52 Mode control sequences
ESC A                   -> Cursor Up
ESC B                   -> Cursor Down
ESC C                   -> Cursor Right
ESC D                   -> Cursor Left
ESC F                   -> Enter Graphics Mode
ESC G                   -> Exit Graphics Mode
ESC H                   -> Cursor to Home
ESC I                   -> Reverse Line Feed
ESC J                   -> Erase To End Of Screen
ESC K                   -> Erase to End Of Line
ESC Y line column       -> Direct Cursor Address
ESC Z                   -> Identify
ESC =                   -> Enter Alternate Keypad Mode
ESC >                   -> Exit Alternate Keypad Mode
ESC <                   -> Enter ANSI Mode

}

{
  CASE ANSI_MODE OF
    ANSI_   : BEGIN
      END;
    VT52_   : BEGIN
      END;
    IBM_PC_ : BEGIN
      END;
  END;
}


{$V-}

 FUNCTION INT_TO_STR (ii : INTEGER):STRING;

    VAR
       tstr : STRING;

    BEGIN
       Str(ii,tstr);
       int_to_str := tstr;
       END;
{$V-}


 PROCEDURE ANSI_CLRSCR ;
{Clear the screen using ANSI control}

    BEGIN                          {}
       CASE ANSI_MODE OF
          ANSI_   : BEGIN
             Write(Output,ascii_esc,ascii_obracket,ascii_two,'J');
             END;
          VT52_  : BEGIN
             Write(Output,ascii_esc,'H',ascii_esc,'J',ascii_esc,'H');
             END;
{    IBM_PC_ : BEGIN
        CRT.CLRSCR;
      END; }
          END;
       c_pos.l := 0;
       c_pos.c := 0;
       END;                        {}



 PROCEDURE  ANSI_CUU(VAR ii : INTEGER);
{Cursor up}

    BEGIN                          {}
       IF ii <= 1 THEN ii := 1;
       CASE ANSI_MODE OF
          ANSI_   : BEGIN
             Write(Output,ascii_esc,ascii_obracket);
             IF (ii > 1) THEN Write(Output,int_to_str(ii));
             Write(Output,'A');
             END;
          VT52_   : BEGIN
             Write(Output,ascii_esc,'A');
             END;
{    IBM_PC_ : BEGIN
        c_pos.l := CRT.WHEREY;
        c_pos.c := CRT.WHEREX;
        IF c_pos.l-ii >= 0 THEN
          c_pos.l := c_pos.l - ii
        ELSE
          c_pos.l := 0;
        CRT.GOTOXY(c_pos.c,c_pos.l);
      END; }
          END;
       END;                        {}

 PROCEDURE  ANSI_CUD(VAR ii : INTEGER);
{Cursor down}

    BEGIN                          {}
       CASE ANSI_MODE OF
          ANSI_   : BEGIN
             Write(Output,ascii_esc,ascii_obracket);
             IF (ii > 1) THEN Write(Output,int_to_str(ii));
             Write(Output,'B');
             END;
          VT52_   : BEGIN
             Write(Output,ascii_esc,'B');
             END;
{    IBM_PC_ : BEGIN
        c_pos.l := CRT.WHEREY;
        c_pos.c := CRT.WHEREX;
        IF c_pos.l+ii <= 24 THEN
          c_pos.l := c_pos.l + ii
        ELSE
          c_pos.l := 24;
        CRT.GOTOXY(c_pos.c,c_pos.l);
      END; }
          END;
       END;                        {}

 PROCEDURE  ANSI_CUF(VAR ii : INTEGER);
{Cursor forward or right}

    BEGIN                          {}
       CASE ANSI_MODE OF
          ANSI_   : BEGIN
             Write(Output,ascii_esc,ascii_obracket);
             IF (ii > 1) THEN Write(Output,int_to_str(ii));
             Write(Output,'C');
             END;
          VT52_   : BEGIN
             Write(Output,ascii_esc,'C');
             END;
{    IBM_PC_ : BEGIN
        c_pos.l := CRT.WHEREY;
        c_pos.c := CRT.WHEREX;
        IF c_pos.c+ii <= 79 THEN
          c_pos.c := c_pos.c + ii
        ELSE
          c_pos.c := 79;
        CRT.GOTOXY(c_pos.c,c_pos.l);
      END;}
          END;
       END;                        {}

 PROCEDURE  ANSI_CUB(VAR ii : INTEGER);
{Cursor backward or left}

    BEGIN                          {}
       CASE ANSI_MODE OF
          ANSI_   : BEGIN
             Write(Output,ascii_esc,ascii_obracket);
             IF (ii > 1) THEN Write(Output,int_to_str(ii));
             Write(Output,'D');
             END;
          VT52_   : BEGIN
             Write(Output,ascii_esc,'D');
             END;
{    IBM_PC_ : BEGIN
        c_pos.l := CRT.WHEREY;
        c_pos.c := CRT.WHEREX;
        IF ((c_pos.c-ii) >= 0) THEN
          c_pos.c := c_pos.c - ii
        ELSE
          c_pos.c := 0;
        CRT.GOTOXY(c_pos.c,c_pos.l);
      END; }
          END;
       END;                        {}

 PROCEDURE  ANSI_EEOL;
{Erase to End Of Line (VT52)}

    BEGIN                          {}
       CASE ANSI_MODE OF
          ANSI_   : BEGIN
             Write(Output,ascii_esc,ascii_obracket,ascii_zero,'K');
             END;
          VT52_   : BEGIN
             Write(Output,ascii_esc,'K');
             END;
{    IBM_PC_ : BEGIN
        CRT.CLREOL;
      END;  }
          END;
       END;                        {}

 PROCEDURE  ANSI_EEOS;
{Erase to End Of Screen (VT52)}

    BEGIN                          {}
       CASE ANSI_MODE OF
          ANSI_   : BEGIN
             END;
          VT52_   : BEGIN
             Write(Output,ascii_esc,'J');
             END;
{    IBM_PC_ : BEGIN
      END; }
          END;
       END;                        {}

 PROCEDURE  ANSI_CUH;
{Cursor home}

    BEGIN                          {}
       CASE ANSI_MODE OF
          ANSI_   : BEGIN
             Write(Output,ascii_esc,ascii_obracket,'0;0','H');
             END;
          VT52_   : BEGIN
             Write(Output,ascii_esc,'H');
             END;
{    IBM_PC_ : BEGIN
        CRT.GOTOXY(BYTE(1),BYTE(1));
      END;  }
          END;
       c_pos.l := 0;
       c_pos.c := 0;
       END;                        {}

 PROCEDURE  ANSI_CUP(line, col : INTEGER);
{Cursor position}

    BEGIN                          {}
       line := line MOD 256;
       col := col MOD 256;
       CASE ANSI_MODE OF
          ANSI_   : BEGIN
             Write(Output,ascii_esc,ascii_obracket,int_to_str(line),';',
                  int_to_str(col),'f');
             END;
          VT52_   : BEGIN
             Write(Output,ascii_esc,'Y',Chr(Ord(BYTE(line+32))),Chr(Ord(
                  BYTE(col+32))));
             END;
{    IBM_PC_ : BEGIN
        CRT.GOTOXY(BYTE(col+1),BYTE(line+1));
      END; }
          END;
       c_pos.l := line;
       c_pos.c := col;
       END;                        {}


{
  IF (ANSI_MODE = ANSI) THEN BEGIN
    END
  ELSE BEGIN {VT52}
    END;
}

BEGIN {Initialization}
  ASSIGN (INPUT,'');
  RESET(INPUT);
  ASSIGN(OUTPUT,'');
  REWRITE(OUTPUT);
  WRITELN(OUTPUT);
  REPEAT
    WRITE('Is this machine''s video  1) ANSI or  2) VT-52 compatible ?');
    READLN(inch);
    inch := UPCASE(inch);
  UNTIL (inch IN ['1','2','3']);
  CASE inch OF
    '1' : ANSI_MODE := ANSI_;
    '2' : ANSI_MODE := VT52_;
{    '3' : ANSI_MODE := IBM_PC_;  }
  END;
  ANSI_CLRSCR;
END.

