/* graphnet.c

   graphics support for network display

   version 1.0   RWD 28 Jan 1990

   Copyright (c)  1990  R.W.Dobbins and R.C.Eberhart
   All Rights Reserved

   $Revision:$            $Date:$
*/

#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>
#include <ctype.h>
#include "graphnet.h"

void InitScreen()
{
   /* Initialise graphics screen */
   for (;;)
   {
      int    graphdriver;
      int    graphmode;
      static char     drivers[66] = "\\tc";
      int    len;
      int    result;

      graphdriver = DETECT;
      initgraph(&graphdriver, &graphmode, drivers);
      if ((result = graphresult()) == 0)
         break;
      printf("Trouble loading BGI driver!   Error code %d\n",  result);
      if (result != -3)
         exit(1);
      printf("Can't find driver file. Enter driver directory pathname: ");
      fgets(drivers, 65, stdin);
      if ((len  =  strlen(drivers) - 1)   <=   0)
         exit(1);
      if (drivers[len]  ==  '\n')
         drivers[len]  =  '\0';
   }
}

void ResetScreen()
{
   closegraph();
}

int Left;
int Top;
int Right;
int Bottom;

void openviewport(VIEW *v)
{
   setviewport(v->left, v->top, v->right,
                 v->bottom, 1);
   clearviewport();
   /* Define some handy parameters for the active viewport */
   Left   = 0;
   Top    = 0;
   Right  = v->right - v->left;
   Bottom = v->bottom - v->top;
   rectangle(Left, Top, Right, Bottom);
}


int   GraphicsGetString(char *s, int maxchars)
{
   int     i;
   char    c;
   char    cDump[2];
   char    done = 0;

   cDump[1] = '\0';

   for (i = 0; i <= maxchars  &&  !done;)
   {
      c = GraphicsGetChar();
      if ( !isprint(c))
      {
         /* Any non-printable key */
         switch(c)
         {
            case 8:
               /* Backspace */
               if (i)
               {
                  /* Not at beginning yet */
                  moveto(getx() - textwidth("_"), gety());
                  s--;
                  i--;
               }
               break;
            case '\n':
            case '\r':
               /* Finish */
               done++;
               break;
            default:
               break;
         }
      }
      else
      {
         *s++ = c;
         *cDump = c;
         outtext(cDump);
         i++;
      }
   }
   *s = '\0';

   return  i;
}


int   GraphicsGetChar()
{
   int         i;                   /* blink counter */
   int         X;
   int         Y;
   char        cursoron;            /* TRUE when cursor displayed */
   static void *cursorblt;          /* address of bit image */
   static char HasBlt = 0;      /* TRUE when cursor bit image captured */
   int         CursorBlinkRate = 1000;

   cursoron = ~0;                   /* Initially, cursor displayed */
   X       = getx();                /* Current position */
   Y       = gety();

   if (!HasBlt)
   {
      int         XRight  = X + textwidth("X");
      int         YBottom = Y + textheight("X");
      unsigned    size;                /* Size of cursor image */

      /* Generate a cursor bit image */
      outtext("_");       /* Put initial cursor symbol */
      size = imagesize(X, Y, XRight, YBottom);
      if ((cursorblt = (void *)malloc(size)) == NULL)
      {
         GraphAbort("Not enough memory");
      }
      getimage(X, Y, XRight, YBottom, cursorblt);
      moveto(X, Y);
      HasBlt = 1;
   }
   putimage(X, Y, cursorblt, COPY_PUT);

   for (;;)
   {
      for (i = 0; i < CursorBlinkRate; i++)
      {
         if (kbhit())
         {
            /* Key has been pressed: erase cursor before returning */
            if (cursoron)
            {
               putimage(X, Y, cursorblt, XOR_PUT);
            }
            return   getch();
         }
      }

      /* Blink cursor */
      putimage(X, Y, cursorblt, XOR_PUT);
      cursoron = ~cursoron;
   }
}


int    FoldColor(int  color)
{
   int   MaxColor = getmaxcolor();

   return  min(MaxColor, color);
}


int   GraphAbort(char *Message)
{
   outtext(Message);
   getch();
   closegraph();
   exit(1);
}
