;;; -*- syntax: common-lisp; package: cmn; base: 10; mode: lisp -*-
;;;
;;; various special-case rests: multi-measure rests, slanted measure rests, abbreviated rest names

(in-package :cmn)


;;; ------------------------------------------------
;;;   multi-measure rest symbols occasionally used in orchestral parts
;;;
;;; (wrest used below is cmn's internal name for the rest class -- the name "rest" caused
;;; no end of strange lisp problems)


(defclass multirest (wrest)
  ((measures :initarg :measures :initform 0 :accessor measures)))

(defclass write-protected-multirest (write-protect multirest) () )

(defmacro define-multirest (name ms)
  `(progn
     (defvar ,name (make-instance 'write-protected-multirest :mark %measurerest :dots 0 :flags 0 :quarters nil :duration nil :measures ,ms))
     (defun ,name (&rest objects) 
       (apply #'ur-rest (make-instance 'multirest :mark %measurerest :dots 0 :flags 0 :quarters nil :duration nil :measures ,ms) objects))))

(define-multirest two-measure-rest 2)
(define-multirest three-measure-rest 3)
(define-multirest four-measure-rest 4)
(define-multirest five-measure-rest 5)
(define-multirest six-measure-rest 6)
(define-multirest seven-measure-rest 7)
(define-multirest eight-measure-rest 8)

(defmethod display ((rest multirest) container score &rest others)
  (declare (ignore container))
  (let* ((x0 (- (+ (* .5 (+ (box-x0 rest) (box-x1 rest))) (dxy-dx rest)) (center rest)))
	 (y0 (+ (%staff-y0 rest) (dxy-dy rest) (* 6 (staff-line-separation score))))
	 (ms (measures rest)))
    (setf  (box-y0 rest) (+ (%staff-y0 rest) (* 6 (staff-line-separation score))))
    (when (rest-pause rest) (display (rest-pause rest) rest score))
    (if (and (beams rest) 
	     (not (member :just-fooling others))
	     (not (member :just-do-it others)))
	(display (beams rest) rest score))
    (if (marks rest) (apply #'display-marks rest score others))
    (when (not (invisible-matrix-p rest))
      (moveto score (+ x0 .25) y0)
      (if (and (/= ms 2) (/= ms 4))
	  (rmoveto score -.25 0))
      (setf (line-width score) .4)
      (if (or (= ms 2) (= ms 3))
	  (rlineto score 0 -.25)
	(rlineto score 0 -.5))
      (if (/= ms 7) 
	  (if (= ms 3)
	      (rmoveto score 1 .25)
	    (rmoveto score 1 .5))
	(rmoveto score .75 .5))
      (if (or (= ms 3) (= ms 5))
	  (rlineto score 0 -.125)
	(if (or (= ms 6) (= ms 7))
	    (rlineto score 0 -.25)
	  (if (= ms 8)
	      (rlineto score 0 -.5))))
      (if (= ms 7)
	  (progn
	    (rmoveto score .75 .25)
	    (rlineto score 0 -.125)))
      (draw score)
      (setf (line-width score) 0))))
	    
(defmethod house ((rest multirest) score)
  (declare (ignore score))
  (setf (box-x1 rest) (+ .5 (if (> (measures rest) 2) 1.5 0) (if (= (measures rest) 7) .5 0)))
  (setf (walls rest) rest-walls)
  (setf (fences rest) rest-fences)
  (if (not (expanders rest))
      (setf (expanders rest) rest-expanders)))

(defmethod copy ((old-rest multirest) &optional object)
  (let ((new-rest (if (not object) (make-instance 'multirest)
		    (if (write-protected object) (copy object)
		      object))))
    (setf (measures new-rest) (measures old-rest))
    (if (next-method-p) (call-next-method old-rest new-rest))
    new-rest))

(defmethod notify ((rest multirest) &optional objects)
  (apply #'ur-rest rest objects))


;;; (cmn staff treble c4 q bar two-measure-rest bar three-measure-rest bar 
;;;   four-measure-rest bar five-measure-rest bar six-measure-rest bar seven-measure-rest bar eight-measure-rest)
;;;
;;; if we were going to use these extensively, we'd want descry and identify methods as well


;;; ------------------------------------------------
;;; slanted measure rest
;;;

(defclass slanted-wrest (wrest) () )
(defclass write-protected-slanted-wrest (write-protect slanted-wrest) () )

(defvar slanted-measure-rest (make-instance 'write-protected-slanted-wrest :mark %measurerest :dots 0 :flags 0 :quarters nil :duration nil))
(defun slanted-measure-rest (&rest objects) 
  (apply #'ur-rest (make-instance 'slanted-wrest :mark %measurerest :dots 0 :flags 0 :quarters nil :duration nil) objects))

(defmethod display ((rest slanted-wrest) container score &rest others)
  (declare (ignore container))
  (let* ((x0 (- (+ (* .5 (+ (box-x0 rest) (box-x1 rest))) (dxy-dx rest)) (center rest)))
	 (line 4)
	 (y0 (+ (%staff-y0 rest) (dxy-dy rest) (* line (staff-line-separation score)))))
    (setf  (box-y0 rest) (+ (%staff-y0 rest) (* line (staff-line-separation score))))
    (when (rest-pause rest) (display (rest-pause rest) rest score))
    (if (and (beams rest) 
	     (not (member :just-fooling others))
	     (not (member :just-do-it others)))
	(display (beams rest) rest score))
    (if (marks rest) (apply #'display-marks rest score others))
    (when (not (invisible-matrix-p rest))
      (let* ((msx (- (box-x1 rest) (box-x0 rest)))
	     (mdx (max 0.0 (min .5 (/ (- msx 1.0) 4))))
	     (rx0 (- x0 mdx))
	     (rx1 (+ x0 .5 mdx)))
	(moveto score rx0 y0)
	(rlineto score 0 -.5)
	(moveto score rx1 (+ y0 .5))
	(rlineto score 0 -.5)
	(draw score)
	(moveto score rx0 (- y0 .125))
	(g-begin-filled-polygon score)    
	(lineto score rx1 (+ y0 .375))
	(lineto score rx1 (+ y0 .125))
	(lineto score rx0 (- y0 .375))
	(fill-in score :closepath t))

      (let ((mn (and (store-data rest) 
		     (find-if #'(lambda (n) (and (listp n) (eq (first n) :measure-number))) (store-data rest)))))
	(when mn
	  (let ((num (second mn)))
	    (moveto score 
		    (- x0 (if (> num 10) (if (> num 100) .3 .15) 0)) 
		    (+ (%staff-y0 rest) (dxy-dy rest) 1.45))
	    (show score (number-to-glyph num))))))))

(defmethod copy ((old-rest slanted-wrest) &optional object)
  (let ((new-rest (if (not object) (make-instance 'slanted-wrest)
		    (if (write-protected object) (copy object)
		      object))))
    (if (next-method-p) (call-next-method old-rest new-rest))
    new-rest))

(defmethod notify ((rest slanted-wrest) &optional objects)
  (apply #'ur-rest rest objects))



;;; ------------------------------------------------
;;; abbreviated rest names

(define-rest r1   %wholerest     0 0 nil)
(define-rest r2   %halfrest      0 0 2)
(define-rest r2.  %halfrest      1 0 3)
(define-rest r4   %quarterrest   0 0 1)
(define-rest r4.  %quarterrest   1 0 3/2)
(define-rest r8   %eighthrest    0 1 1/2)
(define-rest r8.  %eighthrest    1 1 3/4)
(define-rest r16  %sixteenthrest 0 2 1/4)
(define-rest r16. %sixteenthrest 1 2 3/8)
(define-rest r32  %thirtyrest    0 3 1/8)
(define-rest r64  %sixtyfourrest 0 4 1/16)
(define-rest r128 %one28rest     0 5 1/32)
