;;; -*- syntax: common-lisp; package: cmn; base: 10; mode: lisp -*-
;;;
;;; quarter tone symbols -- non-standard!
;;;
;;; I think the 1/4 tone symbols listed in "Music Notation" by G Read are all defective.
;;; One entire set depends on drop-outs to distinguish between the 1/4 sign and the
;;; normal one (i.e. the flat with part of the stem missing) -- this is not only
;;; unreadable at a distance, it's asking for trouble when anyone tries to Xerox a part.
;;; The other sets are internally inconsistent, ugly, impossible to remember, and unreadable.  
;;; So, ta da!, here's my entry -- I claim it's the best.

(in-package :cmn)

;;; quarter up always has up arrow on the right, quarter down has down arrow on the left.
;;;
;;; sharp-up sharp-down flat-up flat-down natural-up natural-down


;;; ---------------- Sharp-up/down ----------------

(defun display-sharp-up (mark note score &rest rest)
  (declare (ignore note rest))
  (rmoveto score (dx mark) (dy mark))
  (let ((x0 (/ (x score) (size score)))
	(y0 (/ (y score) (size score)))
	(old-width (line-width score)))
    (setf (line-width score) .0275)
    (moveto score (+ x0 .065) (+ y0 .25))
    (rlineto score 0 .325)
    (draw score)
    (moveto score (+ x0 .065) (+ y0 .625))
    (rmoveto score .1 -.2)
    (g-begin-filled-polygon score)    
    (rlineto score -.1 .2)
    (rlineto score -.1 -.2)
    (rlineto score .1 .1)
    (rlineto score .1 -.1)
    (fill-in score)
    (moveto score x0 y0)
    (setf (line-width score) old-width)))

(defun sharp-up (&rest args)
  (sharp (apply #'mark #'display-sharp-up :sharp-up args)))

(defvar sharp-up (make-instance 'write-protected-accidental 
		     :index (index sharp) :x0 (x0 sharp) :x1 (x1 sharp) :y0 (y0 sharp) :y1 (y1 sharp) :rx (g-rx sharp) 
		     :marks (list (make-instance 'write-protected-sundry :mark #'display-sharp-up :name :sharp-up))))



(defun display-sharp-down (mark note score &rest rest)
  (declare (ignore note rest))
  (rmoveto score (dx mark) (dy mark))
  (let ((x0 (/ (x score) (size score)))
	(y0 (/ (y score) (size score)))
	(old-width (line-width score)))
    (setf (line-width score) .0275)
    (moveto score (+ x0 .1 .06125) (- y0 .6))
    (rlineto score 0 .325)
    (draw score)
    (moveto score (+ x0 .1 .06125) (- y0 .625))
    (rmoveto score .1 .2)
    (g-begin-filled-polygon score)    
    (rlineto score -.1 -.2)
    (rlineto score -.1 .2)
    (rlineto score .1 -.1)
    (rlineto score .1 .1)
    (fill-in score)
    (moveto score x0 y0)
    (setf (line-width score) old-width)))

(defun sharp-down (&rest args)
  (sharp (apply #'mark #'display-sharp-down :sharp-down args)))

(defvar sharp-down (make-instance 'write-protected-accidental 
		     :index (index sharp) :x0 (x0 sharp) :x1 (x1 sharp) :y0 (y0 sharp) :y1 (y1 sharp) :rx (g-rx sharp) 
		     :marks (list (make-instance 'write-protected-sundry :mark #'display-sharp-down :name :sharp-down))))




;;; ---------------- Natural-up/down ----------------

(defun display-natural-up (mark note score &rest rest)
  (declare (ignore note rest))
  (rmoveto score (dx mark) (dy mark))
  (let ((x0 (/ (x score) (size score)))
	(y0 (/ (y score) (size score)))
	(old-width (line-width score)))
    (moveto score (+ x0 .0125) (+ y0 .45))
    (rmoveto score .1 -.2)
    (g-begin-filled-polygon score)    
    (rlineto score -.1 .2)
    (rlineto score -.1 -.2)
    (rlineto score .1 .1)
    (rlineto score .1 -.1)
    (fill-in score)
    (moveto score x0 y0)
    (setf (line-width score) old-width)))

(defun natural-up (&rest args)
  (natural (apply #'mark #'display-natural-up :natural-up args)))

(defvar natural-up (make-instance 'write-protected-accidental 
		       :index (index natural) :x0 (x0 natural) :x1 (x1 natural) :y0 (y0 natural) :y1 (y1 natural) :rx (g-rx natural) 
		       :marks (list (make-instance 'write-protected-sundry :mark #'display-natural-up :name :natural-up))))



(defun display-natural-down (mark note score &rest rest)
  (declare (ignore note rest))
  (rmoveto score (dx mark) (dy mark))
  (let ((x0 (/ (x score) (size score)))
	(y0 (/ (y score) (size score)))
	(old-width (line-width score)))
    (moveto score (+ x0 .1 .06) (- y0 .45))
    (rmoveto score .1 .2)
    (g-begin-filled-polygon score)    
    (rlineto score -.1 -.2)
    (rlineto score -.1 .2)
    (rlineto score .1 -.1)
    (rlineto score .1 .1)
    (fill-in score)
    (moveto score x0 y0)
    (setf (line-width score) old-width)))

(defun natural-down (&rest args)
  (natural (apply #'mark #'display-natural-down :natural-down args)))

(defvar natural-down (make-instance 'write-protected-accidental 
			 :index (index natural) :x0 (x0 natural) :x1 (x1 natural) :y0 (y0 natural) :y1 (y1 natural) :rx (g-rx natural) 
			 :marks (list (make-instance 'write-protected-sundry :mark #'display-natural-down :name :natural-down))))



;;; ---------------- Flat-up/down ----------------

(defun display-flat-up (mark note score &rest rest)
  (declare (ignore note rest))
  (rmoveto score (dx mark) (dy mark))
  (let ((x0 (/ (x score) (size score)))
	(y0 (/ (y score) (size score)))
	(old-width (line-width score)))
    (moveto score (+ x0 .015) (+ y0 .6))
    (rmoveto score .1 -.2)
    (g-begin-filled-polygon score)    
    (rlineto score -.1 .2)
    (rlineto score -.1 -.2)
    (rlineto score .1 .1)
    (rlineto score .1 -.1)
    (fill-in score)
    (moveto score x0 y0)
    (setf (line-width score) old-width)))

(defun flat-up (&rest args)
  (flat (apply #'mark #'display-flat-up :flat-up args)))

(defvar flat-up (make-instance 'write-protected-accidental 
		     :index (index flat) :x0 (x0 flat) :x1 (x1 flat) :y0 (y0 flat) :y1 (y1 flat) :rx (g-rx flat) 
		     :marks (list (make-instance 'write-protected-sundry :mark #'display-flat-up :name :flat-up))))



(defun display-flat-down (mark note score &rest rest)
  (declare (ignore note rest))
  (rmoveto score (dx mark) (dy mark))
  (let ((x0 (/ (x score) (size score)))
	(y0 (/ (y score) (size score)))
	(old-width (line-width score)))
    (setf (line-width score) .0275)
    (moveto score (+ x0 .0125) (- y0 .375))
    (rlineto score 0 .3)
    (draw score)
    (moveto score (+ x0 .0125) (- y0 .4))
    (rmoveto score .1 .2)
    (g-begin-filled-polygon score)    
    (rlineto score -.1 -.2)
    (rlineto score -.1 .2)
    (rlineto score .1 -.1)
    (rlineto score .1 .1)
    (fill-in score)
    (moveto score x0 y0)
    (setf (line-width score) old-width)))

(defun flat-down (&rest args)
  (flat (apply #'mark #'display-flat-down :flat-down args)))

(defvar flat-down (make-instance 'write-protected-accidental 
		     :index (index flat) :x0 (x0 flat) :x1 (x1 flat) :y0 (y0 flat) :y1 (y1 flat) :rx (g-rx flat) 
		     :marks (list (make-instance 'write-protected-sundry :mark #'display-flat-down :name :flat-down))))

