;;; -*- syntax: common-lisp; package: cmn; base: 10; mode: lisp -*-
;;;
;;; percussion symbols taken from "Music Notation" by Read
;;;
;;; included here are:
;;;
;;;    cymbal (a big circle)
;;;    gong (same circle with another inside it)
;;;    suspended-cymbal
;;;    triangle
;;;    cow-bells
;;;    hi-hat
;;;    maracas
;;;    tambourine
;;;
;;;    mallet symbols (bass-drum, hard-stick, soft-stick, metal-stick, rubber-stick, triangle-stick, wire-brush, wood-stick)
;;;
;;;    harp-setting (to display Salzedo's diagram of the harp pedal settings)
;;;
;;; all these symbols here assume they're attached to some object, but beyond
;;; that it's up to the user to place them correctly using dx and dy or whatever

(in-package :cmn)

#|
 (cmn (size 60) staff (staff-lines 1) (start-line 2) percussion (meter 4 4) 
    (b4 w (cymbal (dy 1.1) (dx .2))) (b4 w (gong (dy 1.1) (dx .2))) 
    (b4 w (suspended-cymbal (dy 1.1) (dx .2))) (b4 w (hi-hat (dy 1.1) (dx .2))) 
    (b4 w (tambourine (dy 1.1) (dx .2))) (b4 w (maracas (dy 1.1) (dx .2))) 
    (b4 w (cow-bells (dy 1.1) (dx .2)))  (b4 w (triangle (dy 1.1) (dx .2))) )

 (cmn (size 60) staff (staff-lines 1) (start-line 2) percussion (meter 4 4) 
    (b4 w (cymbal (dy 1.1) (dx .2)) wood-stick) (b4 w (gong (dy 1.1) (dx .2)) bass-drum)
    (b4 w (suspended-cymbal (dy 1.1) (dx .2)) metal-stick) (b4 w (hi-hat (dy 1.1) (dx .2)) triangle-stick) 
    (b4 w (tambourine (dy 1.1) (dx .2)) soft-stick) (b4 w (maracas (dy 1.1) (dx .2)) hard-stick) 
    (b4 w (cow-bells (dy 1.1) (dx .2)) wire-brush)  (b4 w (triangle (dy 1.1) (dx .2)) wood-stick))
|#



;;; cymbal

(defun display-cymbal (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (r (/ 10 40))
	 (x-off (+ (box-x0 note) (dxy-dx mark))))
    (setf (line-width score) .025)
    (circle score x-off y-off r)
    (draw score)
    (setf (line-width score) 0)))

(defvar cymbal (make-instance 'write-protected-sundry :name :cymbal :mark #'display-cymbal))
(defun cymbal (&rest objects) (apply #'mark #'display-cymbal :cymbal objects))



;;; ------------------------------------------------
;;; gong

(defun display-gong (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (r (/ 10 40))
	 (r1 (/ 3 40))
	 (x-off (+ (box-x0 note) (dxy-dx mark))))
    (setf (line-width score) .025)
    (circle score x-off y-off r)
    (draw score)
    (circle score x-off y-off r1)
    (draw score)
    (setf (line-width score) 0)))

(defvar gong (make-instance 'write-protected-sundry :name :gong :mark #'display-gong))
(defun gong (&rest objects) (apply #'mark #'display-gong :gong objects))


;;; ------------------------------------------------
;;; maracas

(defun display-maracas (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (r (/ 10 40))
	 (x-off (+ (box-x0 note) (dxy-dx mark))))
    (setf (line-width score) .025)
    (circle score x-off y-off r)
    (draw score)
    (setf (line-width score) 0)
    (moveto score x-off (- y-off .05))
    (rlineto score 0 -.35)
    (draw score)))

(defvar maracas (make-instance 'write-protected-sundry :name :maracas :mark #'display-maracas))
(defun maracas (&rest objects) (apply #'mark #'display-maracas :maracas objects))


;;; ------------------------------------------------
;;; tambourine

(defun display-tambourine (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (r (/ 10 40))
	 (dis .1)
	 (len .15)
	 (x-off (+ (box-x0 note) (dxy-dx mark))))
    (setf (line-width score) .025)
    (circle score x-off y-off r)
    (draw score)
    (setf (line-width score) 0)
    (moveto score (- x-off dis) (+ y-off dis))
    (rlineto score (- len) len)
    (moveto score (- x-off dis) (- y-off dis))
    (rlineto score (- len) (- len))
    (moveto score (+ x-off dis) (+ y-off dis))
    (rlineto score len len)
    (moveto score (+ x-off dis) (- y-off dis))
    (rlineto score len (- len))
    (draw score)))

(defvar tambourine (make-instance 'write-protected-sundry :name :tambourine :mark #'display-tambourine))
(defun tambourine (&rest objects) (apply #'mark #'display-tambourine :tambourine objects))


;;; ------------------------------------------------
;;; suspended-cymbal

(defun display-suspended-cymbal (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (x-off (+ (box-x0 note) (dxy-dx mark))))
    (setf (line-width score) .05)
    (moveto score (- x-off .2) y-off)
    (rlineto score .4 0)
    (draw score)
    (setf (line-width score) 0)
    (moveto score x-off (+ y-off .1))
    (rlineto score 0 -.1)
    (draw score)))

(defvar suspended-cymbal (make-instance 'write-protected-sundry :name :suspended-cymbal :mark #'display-suspended-cymbal))
(defun suspended-cymbal (&rest objects) (apply #'mark #'display-suspended-cymbal :suspended-cymbal objects))


;;; ------------------------------------------------
;;; hi-hat

(defun display-hi-hat (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (x-off (+ (box-x0 note) (dxy-dx mark))))
    (setf (line-width score) .05)
    (moveto score (- x-off .2) y-off)
    (rlineto score .4 0)
    (moveto score (- x-off .2) (- y-off .1))
    (rlineto score .4 0)
    (draw score)
    (setf (line-width score) 0)
    (moveto score x-off (+ y-off .1))
    (rlineto score 0 -.1)
    (moveto score x-off (- y-off .1))
    (rlineto score 0 -.1)
    (draw score)))

(defvar hi-hat (make-instance 'write-protected-sundry :name :hi-hat :mark #'display-hi-hat))
(defun hi-hat (&rest objects) (apply #'mark #'display-hi-hat :hi-hat objects))


;;; ------------------------------------------------
;;; triangle

(defun display-triangle (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (x-off (+ (box-x0 note) (dxy-dx mark))))
    (setf (line-width score) .01)
    (moveto score (- x-off .2) (- y-off .2))
    (rlineto score .4 0)
    (rlineto score -.2 .25)
    (rlineto score -.2 -.25)
    (draw score)
    (setf (line-width score) 0)))

(defvar triangle (make-instance 'write-protected-sundry :name :triangle :mark #'display-triangle))
(defun triangle (&rest objects) (apply #'mark #'display-triangle :triangle objects))


;;; ------------------------------------------------
;;; cow-bells

(defun display-cow-bells (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (x-off (+ (box-x0 note) (dxy-dx mark))))
    (setf (line-width score) .01)
    (circle score x-off y-off .25 0 180)
    (rlineto score 0 -.15)
    (rlineto score .5 0)
    (rlineto score 0 .15)
    (draw score)
    (setf (line-width score) 0)))

(defvar cow-bells (make-instance 'write-protected-sundry :name :cow-bells :mark #'display-cow-bells))
(defun cow-bells (&rest objects) (apply #'mark #'display-cow-bells :cow-bells objects))


;;; ------------------------------------------------
;;; mallets
;;;
;;; I am blindly copying "Music Notation" of Gardner Read here
;;;

;;; -------- bass-drum

(defun display-bass-drum (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (x-off (+ (box-x0 note) (dxy-dx mark)))
	 (r .1)
	 (r2 .075)
	 (cr (coerce (cos (/ pi 4)) 'single-float))
	 (ri (* r cr))
	 (ri2 (* r2 cr)))
    (setf (line-width score) 0)
    (circle score x-off y-off r -45 135)
    (draw score)
    (circle score (- x-off .05) (- y-off .05) r 135 315)
    (draw score)
    (moveto score (- x-off ri) (+ y-off ri))
    (rlineto score -.05 -.05)
    (moveto score (+ x-off ri) (- y-off ri))
    (rlineto score -.05 -.05)
    (moveto score (+ x-off ri) (+ y-off ri))
    (rlineto score (* r 1.5) (* r 1.5))
    (draw score)
    (circle score (+ x-off (* r 1.5) ri ri2) (+ y-off (* r 1.5) ri ri2) r2)
    (draw score)
    (setf (line-width score) 0)))

(defvar bass-drum (make-instance 'write-protected-sundry :name :bass-drum :mark #'display-bass-drum))
(defun bass-drum (&rest objects) (apply #'mark #'display-bass-drum :bass-drum objects))


;;; -------- hard-stick

(defun display-hard-stick (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (x-off (+ (box-x0 note) (dxy-dx mark)))
	 (r .075))
    (setf (line-width score) .02)
    (moveto score x-off y-off)
    (rlineto score 0 .2)
    (draw score)
    (setf (line-width score) 0)
    (circle score x-off (+ y-off r .2) r 0 360 t)))

(defvar hard-stick (make-instance 'write-protected-sundry :name :hard-stick :mark #'display-hard-stick))
(defun hard-stick (&rest objects) (apply #'mark #'display-hard-stick :hard-stick objects))


;;; -------- soft-stick

(defun display-soft-stick (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (x-off (+ (box-x0 note) (dxy-dx mark)))
	 (r .075))
    (setf (line-width score) .02)
    (moveto score x-off y-off)
    (rlineto score 0 .2)
    (draw score)
    (setf (line-width score) 0)
    (circle score x-off (+ y-off r .2) r)
    (draw score)))

(defvar soft-stick (make-instance 'write-protected-sundry :name :soft-stick :mark #'display-soft-stick))
(defun soft-stick (&rest objects) (apply #'mark #'display-soft-stick :soft-stick objects))


;;; -------- metal-stick

(defun display-metal-stick (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (x-off (+ (box-x0 note) (dxy-dx mark)))
	 (r .075))
    (setf (line-width score) .02)
    (moveto score x-off y-off)
    (rlineto score 0 .2)
    (draw score)
    (setf (line-width score) 0)
    (fill-in score :rectangle t :closepath t :path (list (- x-off r) (+ y-off .2) .15 .15))))

(defvar metal-stick (make-instance 'write-protected-sundry :name :metal-stick :mark #'display-metal-stick))
(defun metal-stick (&rest objects) (apply #'mark #'display-metal-stick :metal-stick objects))


;;; -------- rubber-stick

(defun display-rubber-stick (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (x-off (+ (box-x0 note) (dxy-dx mark)))
	 (r .075))
    (setf (line-width score) .02)
    (moveto score x-off y-off)
    (rlineto score 0 .2)
    (draw score)
    (setf (line-width score) 0)
    (circle score x-off (+ y-off r .2) r)
    (draw score)
    (circle score (- x-off .025) (+ y-off r .175) .01 0 360 t)
    (circle score x-off (+ y-off r .225) .01 0 360 t)
    (circle score (+ x-off .025) (+ y-off r .175) .01 0 360 t)))

(defvar rubber-stick (make-instance 'write-protected-sundry :name :rubber-stick :mark #'display-rubber-stick))
(defun rubber-stick (&rest objects) (apply #'mark #'display-rubber-stick :rubber-stick objects))


;;; -------- wood-stick

(defun display-wood-stick (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (x-off (+ (box-x0 note) (dxy-dx mark)))
	 (r .075))
    (circle score x-off (+ y-off r .2) r 0 360 t)
    (moveto score (- x-off .02) (+ y-off .2))
    (g-begin-filled-polygon score)    
    (rlineto score .04 0)
    (rlineto score .04 -.2)
    (rlineto score -.12 0)
    (rlineto score .04 .2)
    (fill-in score)))

(defvar wood-stick (make-instance 'write-protected-sundry :name :wood-stick :mark #'display-wood-stick))
(defun wood-stick (&rest objects) (apply #'mark #'display-wood-stick :wood-stick objects))


;;; -------- wire-brush

(defun display-wire-brush (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (x-off (+ (box-x0 note) (dxy-dx mark))))
    (setf (line-width score) .02)
    (moveto score x-off y-off)
    (rlineto score 0 .3)
    (moveto score x-off (+ y-off .2))
    (rlineto score .15 .04)
    (moveto score x-off (+ y-off .2))
    (rlineto score .1 .0875)
    (moveto score x-off (+ y-off .2))
    (rlineto score -.1 .0875)
    (moveto score x-off (+ y-off .2))
    (rlineto score -.15 .04)
    (draw score)
    (setf (line-width score) 0)))

(defvar wire-brush (make-instance 'write-protected-sundry :name :wire-brush :mark #'display-wire-brush))
(defun wire-brush (&rest objects) (apply #'mark #'display-wire-brush :wire-brush objects))


;;; -------- triangle-stick

(defun display-triangle-stick (mark note score &rest rest)
  (declare (ignore rest))
  (let* ((y-off (+ (dxy-dy mark) (%staff-y0 note)))
	 (x-off (+ (box-x0 note) (dxy-dx mark))))
    (setf (line-width score) .01)
    (moveto score (- x-off .2) (- y-off .2))
    (rlineto score .4 0)
    (rlineto score -.2 .25)
    (rlineto score -.2 -.25)
    (moveto score x-off (- y-off .2))
    (rlineto score 0 .1)
    (draw score)
    (circle score x-off (- y-off .1) .04 0 360 t)
    (setf (line-width score) 0)))

(defvar triangle-stick (make-instance 'write-protected-sundry :name :triangle-stick :mark #'display-triangle-stick))
(defun triangle-stick (&rest objects) (apply #'mark #'display-triangle-stick :triangle-stick objects))


;;; ------------------------------------------------
;;; harp set-up diagram

(defun harp-setting (D-ped C-ped B-ped E-ped F-ped G-ped A-ped &rest args)
  ;; pedals can be :sharp :flat :natural 
  (apply #'mark #'(lambda (mark note score &rest rest)
		    (declare (ignore rest))
		    (let ((ped-height .3)
			  (x0 (+ (x0 note) (dxy-dx mark)))
			  (y0 (+ (staff-y0 note) (dxy-dy mark))))
		      (flet ((pedup (n) (if (eq n :flat) (+ ped-height .05)
					  (if (eq n :natural) (* .5 ped-height) 
					    -.05))))
			(moveto score (- x0 .05) (+ y0 ped-height))
			(setf (line-width score) .025)
			(rlineto score 2.3 0)
			(rmoveto score -1.2 -.2)
			(rlineto score 0 .4)
			(draw score)
			(setf (line-width score) .1)
			(moveto score (+ x0 .05) (+ y0 (pedup D-ped)))
			(rlineto score 0 ped-height)
			(moveto score (+ x0 .05 .3) (+ y0 (pedup C-ped)))
			(rlineto score 0 ped-height)
			(moveto score (+ x0 .05 .6) (+ y0 (pedup B-ped)))
			(rlineto score 0 ped-height)
			(moveto score (+ x0 .05 1.2) (+ y0 (pedup E-ped)))
			(rlineto score 0 ped-height)
			(moveto score (+ x0 .05 1.5) (+ y0 (pedup F-ped)))
			(rlineto score 0 ped-height)
			(moveto score (+ x0 .05 1.8) (+ y0 (pedup G-ped)))
			(rlineto score 0 ped-height)
			(moveto score (+ x0 .05 2.1) (+ y0 (pedup A-ped)))
			(rlineto score 0 ped-height)
			(draw score)
			(setf (line-width score) 0))))
	 :harp-setting
	 args))

;;; (cmn staff treble c4 w (harp-setting :sharp :flat :natural :flat :sharp :natural :flat (dy -1.5)))
